package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object MethodInst {
  def apply(graph: Graph, id: Long) = new MethodInst(graph, id)

  val Label = "METHOD_INST"
  val LabelId: Int = 32

  object PropertyNames {
    val Name = "NAME" 
    val Signature = "SIGNATURE" 
    val FullName = "FULL_NAME" 
    val MethodFullName = "METHOD_FULL_NAME" 
    val Order = "ORDER" 
    val all: Set[String] = Set(Name, Signature, FullName, MethodFullName, Order)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Name = new PropertyKey[String]("NAME") 
    val Signature = new PropertyKey[String]("SIGNATURE") 
    val FullName = new PropertyKey[String]("FULL_NAME") 
    val MethodFullName = new PropertyKey[String]("METHOD_FULL_NAME") 
    val Order = new PropertyKey[Integer]("ORDER") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("AST","CONTAINS_NODE")
  }

  val factory = new NodeFactory[MethodInstDb] {
    override val forLabel = MethodInst.Label
    override val forLabelId = MethodInst.LabelId

    override def createNode(ref: NodeRef[MethodInstDb]) =
      new MethodInstDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = MethodInst(graph, id)
  }
}

trait MethodInstBase extends CpgNode with AstNodeBase with HasName with HasSignature with HasFullName with HasMethodFullName with HasOrder {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class MethodInst(graph: Graph, id: Long) extends NodeRef[MethodInstDb](graph, id)
  with MethodInstBase
  with StoredNode
  with AstNode {
    override def name: String = get().name
  override def signature: String = get().signature
  override def fullName: String = get().fullName
  override def methodFullName: String = get().methodFullName
  override def order: Integer = get().order
  
  def _typeArgumentViaAstOut: Iterator[TypeArgument] = get()._typeArgumentViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodInst.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "signature" 
case 3 => "fullName" 
case 4 => "methodFullName" 
case 5 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => signature
case 3 => fullName
case 4 => methodFullName
case 5 => order
    }

  override def productPrefix = "MethodInst"
  override def productArity = 6
}

class MethodInstDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
  with AstNode with MethodInstBase {

  override def layoutInformation: NodeLayoutInformation = MethodInst.layoutInformation

private var _name: String = null
def name(): String = _name

private var _signature: String = null
def signature(): String = _signature

private var _fullName: String = null
def fullName(): String = _fullName

private var _methodFullName: String = null
def methodFullName(): String = _methodFullName

private var _order: Integer = null
def order(): Integer = _order


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (name != null) { properties.put("NAME", name) }
if (signature != null) { properties.put("SIGNATURE", signature) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (methodFullName != null) { properties.put("METHOD_FULL_NAME", methodFullName) }
if (order != null) { properties.put("ORDER", order) }

  properties
}

  def _typeArgumentViaAstOut: Iterator[TypeArgument] = _astOut.asScala.collect { case node: TypeArgument => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MethodInst.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "signature" 
case 3 => "fullName" 
case 4 => "methodFullName" 
case 5 => "order" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => signature
case 3 => fullName
case 4 => methodFullName
case 5 => order
    }

  override def productPrefix = "MethodInst"
  override def productArity = 6

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodInstDb]

  override def property(key:String): AnyRef = {
    key match {
      case "NAME" => this._name
      case "SIGNATURE" => this._signature
      case "FULL_NAME" => this._fullName
      case "METHOD_FULL_NAME" => this._methodFullName
      case "ORDER" => this._order
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "NAME" => this._name = value.asInstanceOf[String]
      case "SIGNATURE" => this._signature = value.asInstanceOf[String]
      case "FULL_NAME" => this._fullName = value.asInstanceOf[String]
      case "METHOD_FULL_NAME" => this._methodFullName = value.asInstanceOf[String]
      case "ORDER" => this._order = value.asInstanceOf[Integer]
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewMethodInst]
   this._name = other.name
   this._signature = other.signature
   this._fullName = other.fullName
   this._methodFullName = other.methodFullName
   this._order = other.order

  graph.indexManager.putIfIndexed("FULL_NAME", other.fullName, this.ref)
}

}

/** Traversal steps for MethodInst */
class MethodInstTraversal[NodeType <: MethodInst](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to name property */
  def name: Traversal[String] =
    traversal.map(_.name)

    /**
    * Traverse to nodes where the name matches the regular expression `value`
    * */
  def name(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the name matches at least one of the regular expressions in `values`
    * */
  def name(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where name matches `value` exactly.
    * */
  def nameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME, value)

  /**
    * Traverse to nodes where name matches one of the elements in `values` exactly.
    * */
  def nameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where name does not match the regular expression `value`.
    * */
  def nameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where name does not match any of the regular expressions in `values`.
    * */
  def nameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.within(values.to(Set))))



  /** Traverse to signature property */
  def signature: Traversal[String] =
    traversal.map(_.signature)

    /**
    * Traverse to nodes where the signature matches the regular expression `value`
    * */
  def signature(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.SIGNATURE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the signature matches at least one of the regular expressions in `values`
    * */
  def signature(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.SIGNATURE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where signature matches `value` exactly.
    * */
  def signatureExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.SIGNATURE, value)

  /**
    * Traverse to nodes where signature matches one of the elements in `values` exactly.
    * */
  def signatureExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.SIGNATURE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where signature does not match the regular expression `value`.
    * */
  def signatureNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.SIGNATURE.where(P.matches(regex)))

  /**
    * Traverse to nodes where signature does not match any of the regular expressions in `values`.
    * */
  def signatureNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.SIGNATURE.where(P.within(values.to(Set))))



  /** Traverse to fullName property */
  def fullName: Traversal[String] =
    traversal.map(_.fullName)

    /**
    * Traverse to nodes where the fullName matches the regular expression `value`
    * */
  def fullName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the fullName matches at least one of the regular expressions in `values`
    * */
  def fullName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.FULL_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where fullName matches `value` exactly.
    * */
  def fullNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.FULL_NAME, value)

  /**
    * Traverse to nodes where fullName matches one of the elements in `values` exactly.
    * */
  def fullNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.FULL_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where fullName does not match the regular expression `value`.
    * */
  def fullNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where fullName does not match any of the regular expressions in `values`.
    * */
  def fullNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.FULL_NAME.where(P.within(values.to(Set))))



  /** Traverse to methodFullName property */
  def methodFullName: Traversal[String] =
    traversal.map(_.methodFullName)

    /**
    * Traverse to nodes where the methodFullName matches the regular expression `value`
    * */
  def methodFullName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.METHOD_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the methodFullName matches at least one of the regular expressions in `values`
    * */
  def methodFullName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.METHOD_FULL_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where methodFullName matches `value` exactly.
    * */
  def methodFullNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.METHOD_FULL_NAME, value)

  /**
    * Traverse to nodes where methodFullName matches one of the elements in `values` exactly.
    * */
  def methodFullNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.METHOD_FULL_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where methodFullName does not match the regular expression `value`.
    * */
  def methodFullNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.METHOD_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where methodFullName does not match any of the regular expressions in `values`.
    * */
  def methodFullNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.METHOD_FULL_NAME.where(P.within(values.to(Set))))



  /** Traverse to order property */
  def order: Traversal[Integer] =
    traversal.map(_.order)

    /**
    * Traverse to nodes where the order equals the given `value`
    * */
  def order(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where the order equals at least one of the given `values`
    * */
  def order(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the order is greater than the given `value`
    * */
  def orderGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ > value))

  /**
    * Traverse to nodes where the order is greater than or equal the given `value`
    * */
  def orderGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ >= value))

  /**
    * Traverse to nodes where the order is less than the given `value`
    * */
  def orderLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ < value))

  /**
    * Traverse to nodes where the order is less than or equal the given `value`
    * */
  def orderLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ <= value))

  /**
    * Traverse to nodes where order is not equal to the given `value`.
    * */
  def orderNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where order is not equal to any of the given `values`.
    * */
  def orderNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER.where(P.within(values.toSet)))



}
