package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object MethodParameterIn {
  def apply(graph: Graph, id: Long) = new MethodParameterIn(graph, id)

  val Label = "METHOD_PARAMETER_IN"
  val LabelId: Int = 34

  object PropertyNames {
    val Code = "CODE" 
    val Order = "ORDER" 
    val Name = "NAME" 
    val EvaluationStrategy = "EVALUATION_STRATEGY" 
    val TypeFullName = "TYPE_FULL_NAME" 
    val DynamicTypeHintFullName = "DYNAMIC_TYPE_HINT_FULL_NAME" 
    val LineNumber = "LINE_NUMBER" 
    val ColumnNumber = "COLUMN_NUMBER" 
    val all: Set[String] = Set(Code, Order, Name, EvaluationStrategy, TypeFullName, DynamicTypeHintFullName, LineNumber, ColumnNumber)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Code = new PropertyKey[String]("CODE") 
    val Order = new PropertyKey[Integer]("ORDER") 
    val Name = new PropertyKey[String]("NAME") 
    val EvaluationStrategy = new PropertyKey[String]("EVALUATION_STRATEGY") 
    val TypeFullName = new PropertyKey[String]("TYPE_FULL_NAME") 
    val DynamicTypeHintFullName = new PropertyKey[Seq[String]]("DYNAMIC_TYPE_HINT_FULL_NAME") 
    val LineNumber = new PropertyKey[Integer]("LINE_NUMBER") 
    val ColumnNumber = new PropertyKey[Integer]("COLUMN_NUMBER") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.TaggedBy.layoutInformation, edges.ReachingDef.layoutInformation, edges.DynamicType.layoutInformation, edges.Ast.layoutInformation, edges.TaintRemove.layoutInformation, edges.ContainsNode.layoutInformation, edges.Propagate.layoutInformation, edges.ParameterLink.layoutInformation, edges.EvalType.layoutInformation).asJava,
    List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.Ref.layoutInformation, edges.ReachingDef.layoutInformation, edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.Ast.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","REF","REACHING_DEF","IS_SENSITIVE_DATA_DESCR_OF_REF","AST","CONTAINS_NODE")
    val Out: Array[String] = Array("TAGGED_BY","REACHING_DEF","DYNAMIC_TYPE","AST","TAINT_REMOVE","CONTAINS_NODE","PROPAGATE","PARAMETER_LINK","EVAL_TYPE")
  }

  val factory = new NodeFactory[MethodParameterInDb] {
    override val forLabel = MethodParameterIn.Label
    override val forLabelId = MethodParameterIn.LabelId

    override def createNode(ref: NodeRef[MethodParameterInDb]) =
      new MethodParameterInDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = MethodParameterIn(graph, id)
  }
}

trait MethodParameterInBase extends CpgNode with DeclarationBase with LocalLikeBase with TrackingPointBase with AstNodeBase with HasCode with HasOrder with HasName with HasEvaluationStrategy with HasTypeFullName with HasDynamicTypeHintFullName with HasLineNumber with HasColumnNumber {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class MethodParameterIn(graph: Graph, id: Long) extends NodeRef[MethodParameterInDb](graph, id)
  with MethodParameterInBase
  with StoredNode
  with Declaration with LocalLike with TrackingPoint with AstNode {
    override def code: String = get().code
  override def order: Integer = get().order
  override def name: String = get().name
  override def evaluationStrategy: String = get().evaluationStrategy
  override def typeFullName: String = get().typeFullName
  override def dynamicTypeHintFullName: List[String] = get().dynamicTypeHintFullName
  override def lineNumber: Option[Integer] = get().lineNumber
  override def columnNumber: Option[Integer] = get().columnNumber
  
  def _tagViaTaggedByOut: Iterator[Tag] = get()._tagViaTaggedByOut
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut
def _identifierViaReachingDefOut: Iterator[Identifier] = get()._identifierViaReachingDefOut
def _callViaReachingDefOut: Iterator[Call] = get()._callViaReachingDefOut
def _literalViaReachingDefOut: Iterator[Literal] = get()._literalViaReachingDefOut
override def _reachingDefOut(): JIterator[StoredNode] = get()._reachingDefOut
def _returnViaReachingDefOut: Iterator[Return] = get()._returnViaReachingDefOut
def _methodViaDynamicTypeOut: Iterator[Method] = get()._methodViaDynamicTypeOut
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = get()._typeDeclViaDynamicTypeOut
override def _dynamicTypeOut(): JIterator[StoredNode] = get()._dynamicTypeOut
def _annotationViaAstOut: Iterator[Annotation] = get()._annotationViaAstOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
def _methodParameterOutViaTaintRemoveOut: Iterator[MethodParameterOut] = get()._methodParameterOutViaTaintRemoveOut
override def _taintRemoveOut(): JIterator[StoredNode] = get()._taintRemoveOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodParameterOutViaPropagateOut: Iterator[MethodParameterOut] = get()._methodParameterOutViaPropagateOut
def _methodReturnViaPropagateOut: Iterator[MethodReturn] = get()._methodReturnViaPropagateOut
override def _propagateOut(): JIterator[StoredNode] = get()._propagateOut
def _methodParameterOutViaParameterLinkOut: Iterator[MethodParameterOut] = get()._methodParameterOutViaParameterLinkOut
override def _parameterLinkOut(): JIterator[StoredNode] = get()._parameterLinkOut
def _typeViaEvalTypeOut: Type = get()._typeViaEvalTypeOut
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut
def _sensitiveVariableViaIsSensitiveDataDescrOfIn: Iterator[SensitiveVariable] = get()._sensitiveVariableViaIsSensitiveDataDescrOfIn
override def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfIn
def _closureBindingViaRefIn: Iterator[ClosureBinding] = get()._closureBindingViaRefIn
def _identifierViaRefIn: Iterator[Identifier] = get()._identifierViaRefIn
override def _refIn(): JIterator[StoredNode] = get()._refIn
def _methodViaReachingDefIn: Iterator[Method] = get()._methodViaReachingDefIn
override def _reachingDefIn(): JIterator[StoredNode] = get()._reachingDefIn
def _sensitiveReferenceViaIsSensitiveDataDescrOfRefIn: Iterator[SensitiveReference] = get()._sensitiveReferenceViaIsSensitiveDataDescrOfRefIn
override def _isSensitiveDataDescrOfRefIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefIn
def _methodViaAstIn: Method = get()._methodViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = get()._methodSummaryViaContainsNodeIn
def _sinkViaContainsNodeIn: Iterator[Sink] = get()._sinkViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodParameterIn.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
case 3 => "name" 
case 4 => "evaluationStrategy" 
case 5 => "typeFullName" 
case 6 => "dynamicTypeHintFullName" 
case 7 => "lineNumber" 
case 8 => "columnNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => code
case 2 => order
case 3 => name
case 4 => evaluationStrategy
case 5 => typeFullName
case 6 => dynamicTypeHintFullName
case 7 => lineNumber
case 8 => columnNumber
    }

  override def productPrefix = "MethodParameterIn"
  override def productArity = 9
}

class MethodParameterInDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
  with Declaration with LocalLike with TrackingPoint with AstNode with MethodParameterInBase {

  override def layoutInformation: NodeLayoutInformation = MethodParameterIn.layoutInformation

private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order

private var _name: String = null
def name(): String = _name

private var _evaluationStrategy: String = null
def evaluationStrategy(): String = _evaluationStrategy

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _dynamicTypeHintFullName: List[String] = Nil
def dynamicTypeHintFullName(): List[String] = _dynamicTypeHintFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
if (name != null) { properties.put("NAME", name) }
if (evaluationStrategy != null) { properties.put("EVALUATION_STRATEGY", evaluationStrategy) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
if (dynamicTypeHintFullName.nonEmpty) { properties.put("DYNAMIC_TYPE_HINT_FULL_NAME", dynamicTypeHintFullName.asJava) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }

  properties
}

  def _tagViaTaggedByOut: Iterator[Tag] = _taggedByOut.asScala.collect { case node: Tag => node }
override def _taggedByOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _returnViaReachingDefOut: Iterator[Return] = _reachingDefOut.asScala.collect { case node: Return => node }
def _literalViaReachingDefOut: Iterator[Literal] = _reachingDefOut.asScala.collect { case node: Literal => node }
def _callViaReachingDefOut: Iterator[Call] = _reachingDefOut.asScala.collect { case node: Call => node }
def _identifierViaReachingDefOut: Iterator[Identifier] = _reachingDefOut.asScala.collect { case node: Identifier => node }
override def _reachingDefOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _methodViaDynamicTypeOut: Iterator[Method] = _dynamicTypeOut.asScala.collect { case node: Method => node }
def _typeDeclViaDynamicTypeOut: Iterator[TypeDecl] = _dynamicTypeOut.asScala.collect { case node: TypeDecl => node }
override def _dynamicTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _annotationViaAstOut: Iterator[Annotation] = _astOut.asScala.collect { case node: Annotation => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _methodParameterOutViaTaintRemoveOut: Iterator[MethodParameterOut] = _taintRemoveOut.asScala.collect { case node: MethodParameterOut => node }
override def _taintRemoveOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _methodParameterOutViaPropagateOut: Iterator[MethodParameterOut] = _propagateOut.asScala.collect { case node: MethodParameterOut => node }
def _methodReturnViaPropagateOut: Iterator[MethodReturn] = _propagateOut.asScala.collect { case node: MethodReturn => node }
override def _propagateOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _methodParameterOutViaParameterLinkOut: Iterator[MethodParameterOut] = _parameterLinkOut.asScala.collect { case node: MethodParameterOut => node }
override def _parameterLinkOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
def _typeViaEvalTypeOut: Type = _evalTypeOut.asScala.collect { case node: Type => node }.next
override def _evalTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
def _sensitiveVariableViaIsSensitiveDataDescrOfIn: Iterator[SensitiveVariable] = _isSensitiveDataDescrOfIn.asScala.collect { case node: SensitiveVariable => node }
override def _isSensitiveDataDescrOfIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
def _closureBindingViaRefIn: Iterator[ClosureBinding] = _refIn.asScala.collect { case node: ClosureBinding => node }
def _identifierViaRefIn: Iterator[Identifier] = _refIn.asScala.collect { case node: Identifier => node }
override def _refIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
def _methodViaReachingDefIn: Iterator[Method] = _reachingDefIn.asScala.collect { case node: Method => node }
override def _reachingDefIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
def _sensitiveReferenceViaIsSensitiveDataDescrOfRefIn: Iterator[SensitiveReference] = _isSensitiveDataDescrOfRefIn.asScala.collect { case node: SensitiveReference => node }
override def _isSensitiveDataDescrOfRefIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstIn: Method = _astIn.asScala.collect { case node: Method => node }.next
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = _containsNodeIn.asScala.collect { case node: MethodSummary => node }
def _sinkViaContainsNodeIn: Iterator[Sink] = _containsNodeIn.asScala.collect { case node: Sink => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MethodParameterIn.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
case 3 => "name" 
case 4 => "evaluationStrategy" 
case 5 => "typeFullName" 
case 6 => "dynamicTypeHintFullName" 
case 7 => "lineNumber" 
case 8 => "columnNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => code
case 2 => order
case 3 => name
case 4 => evaluationStrategy
case 5 => typeFullName
case 6 => dynamicTypeHintFullName
case 7 => lineNumber
case 8 => columnNumber
    }

  override def productPrefix = "MethodParameterIn"
  override def productArity = 9

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodParameterInDb]

  override def property(key:String): AnyRef = {
    key match {
      case "CODE" => this._code
      case "ORDER" => this._order
      case "NAME" => this._name
      case "EVALUATION_STRATEGY" => this._evaluationStrategy
      case "TYPE_FULL_NAME" => this._typeFullName
      case "DYNAMIC_TYPE_HINT_FULL_NAME" => this._dynamicTypeHintFullName
      case "LINE_NUMBER" => this._lineNumber.orNull
      case "COLUMN_NUMBER" => this._columnNumber.orNull
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "CODE" => this._code = value.asInstanceOf[String]
      case "ORDER" => this._order = value.asInstanceOf[Integer]
      case "NAME" => this._name = value.asInstanceOf[String]
      case "EVALUATION_STRATEGY" => this._evaluationStrategy = value.asInstanceOf[String]
      case "TYPE_FULL_NAME" => this._typeFullName = value.asInstanceOf[String]
      case "DYNAMIC_TYPE_HINT_FULL_NAME" => this._dynamicTypeHintFullName = value match {
        case singleValue: String => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[String]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[String]]
      }
      case "LINE_NUMBER" => this._lineNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "COLUMN_NUMBER" => this._columnNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewMethodParameterIn]
   this._code = other.code
   this._order = other.order
   this._name = other.name
   this._evaluationStrategy = other.evaluationStrategy
   this._typeFullName = other.typeFullName
   this._dynamicTypeHintFullName = other.dynamicTypeHintFullName
   this._lineNumber = other.lineNumber
   this._columnNumber = other.columnNumber


}

}

/** Traversal steps for MethodParameterIn */
class MethodParameterInTraversal[NodeType <: MethodParameterIn](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to code property */
  def code: Traversal[String] =
    traversal.map(_.code)

    /**
    * Traverse to nodes where the code matches the regular expression `value`
    * */
  def code(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the code matches at least one of the regular expressions in `values`
    * */
  def code(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where code matches `value` exactly.
    * */
  def codeExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE, value)

  /**
    * Traverse to nodes where code matches one of the elements in `values` exactly.
    * */
  def codeExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where code does not match the regular expression `value`.
    * */
  def codeNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where code does not match any of the regular expressions in `values`.
    * */
  def codeNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.within(values.to(Set))))



  /** Traverse to order property */
  def order: Traversal[Integer] =
    traversal.map(_.order)

    /**
    * Traverse to nodes where the order equals the given `value`
    * */
  def order(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where the order equals at least one of the given `values`
    * */
  def order(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the order is greater than the given `value`
    * */
  def orderGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ > value))

  /**
    * Traverse to nodes where the order is greater than or equal the given `value`
    * */
  def orderGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ >= value))

  /**
    * Traverse to nodes where the order is less than the given `value`
    * */
  def orderLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ < value))

  /**
    * Traverse to nodes where the order is less than or equal the given `value`
    * */
  def orderLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ <= value))

  /**
    * Traverse to nodes where order is not equal to the given `value`.
    * */
  def orderNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where order is not equal to any of the given `values`.
    * */
  def orderNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER.where(P.within(values.toSet)))


  /** Traverse to name property */
  def name: Traversal[String] =
    traversal.map(_.name)

    /**
    * Traverse to nodes where the name matches the regular expression `value`
    * */
  def name(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the name matches at least one of the regular expressions in `values`
    * */
  def name(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where name matches `value` exactly.
    * */
  def nameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME, value)

  /**
    * Traverse to nodes where name matches one of the elements in `values` exactly.
    * */
  def nameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where name does not match the regular expression `value`.
    * */
  def nameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where name does not match any of the regular expressions in `values`.
    * */
  def nameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.within(values.to(Set))))



  /** Traverse to evaluationStrategy property */
  def evaluationStrategy: Traversal[String] =
    traversal.map(_.evaluationStrategy)

    /**
    * Traverse to nodes where the evaluationStrategy matches the regular expression `value`
    * */
  def evaluationStrategy(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.EVALUATION_STRATEGY.where(P.matches(regex)))

  /**
    * Traverse to nodes where the evaluationStrategy matches at least one of the regular expressions in `values`
    * */
  def evaluationStrategy(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.EVALUATION_STRATEGY.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where evaluationStrategy matches `value` exactly.
    * */
  def evaluationStrategyExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.EVALUATION_STRATEGY, value)

  /**
    * Traverse to nodes where evaluationStrategy matches one of the elements in `values` exactly.
    * */
  def evaluationStrategyExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.EVALUATION_STRATEGY.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where evaluationStrategy does not match the regular expression `value`.
    * */
  def evaluationStrategyNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.EVALUATION_STRATEGY.where(P.matches(regex)))

  /**
    * Traverse to nodes where evaluationStrategy does not match any of the regular expressions in `values`.
    * */
  def evaluationStrategyNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.EVALUATION_STRATEGY.where(P.within(values.to(Set))))



  /** Traverse to typeFullName property */
  def typeFullName: Traversal[String] =
    traversal.map(_.typeFullName)

    /**
    * Traverse to nodes where the typeFullName matches the regular expression `value`
    * */
  def typeFullName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.TYPE_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the typeFullName matches at least one of the regular expressions in `values`
    * */
  def typeFullName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.TYPE_FULL_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where typeFullName matches `value` exactly.
    * */
  def typeFullNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.TYPE_FULL_NAME, value)

  /**
    * Traverse to nodes where typeFullName matches one of the elements in `values` exactly.
    * */
  def typeFullNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.TYPE_FULL_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where typeFullName does not match the regular expression `value`.
    * */
  def typeFullNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.TYPE_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where typeFullName does not match any of the regular expressions in `values`.
    * */
  def typeFullNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.TYPE_FULL_NAME.where(P.within(values.to(Set))))



  /** Traverse to dynamicTypeHintFullName property */
  def dynamicTypeHintFullName: Traversal[String] =
    traversal.flatMap(_.dynamicTypeHintFullName)

  

  /** Traverse to lineNumber property */
  def lineNumber: Traversal[Integer] =
    traversal.flatMap(_.lineNumber)

    /**
    * Traverse to nodes where the lineNumber equals the given `value`
    * */
  def lineNumber(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER, value)

  /**
    * Traverse to nodes where the lineNumber equals at least one of the given `values`
    * */
  def lineNumber(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the lineNumber is greater than the given `value`
    * */
  def lineNumberGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ > value))

  /**
    * Traverse to nodes where the lineNumber is greater than or equal the given `value`
    * */
  def lineNumberGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ >= value))

  /**
    * Traverse to nodes where the lineNumber is less than the given `value`
    * */
  def lineNumberLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ < value))

  /**
    * Traverse to nodes where the lineNumber is less than or equal the given `value`
    * */
  def lineNumberLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ <= value))

  /**
    * Traverse to nodes where lineNumber is not equal to the given `value`.
    * */
  def lineNumberNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LINE_NUMBER, value)

  /**
    * Traverse to nodes where lineNumber is not equal to any of the given `values`.
    * */
  def lineNumberNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LINE_NUMBER.where(P.within(values.toSet)))


  /** Traverse to columnNumber property */
  def columnNumber: Traversal[Integer] =
    traversal.flatMap(_.columnNumber)

    /**
    * Traverse to nodes where the columnNumber equals the given `value`
    * */
  def columnNumber(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER, value)

  /**
    * Traverse to nodes where the columnNumber equals at least one of the given `values`
    * */
  def columnNumber(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the columnNumber is greater than the given `value`
    * */
  def columnNumberGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ > value))

  /**
    * Traverse to nodes where the columnNumber is greater than or equal the given `value`
    * */
  def columnNumberGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ >= value))

  /**
    * Traverse to nodes where the columnNumber is less than the given `value`
    * */
  def columnNumberLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ < value))

  /**
    * Traverse to nodes where the columnNumber is less than or equal the given `value`
    * */
  def columnNumberLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ <= value))

  /**
    * Traverse to nodes where columnNumber is not equal to the given `value`.
    * */
  def columnNumberNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.COLUMN_NUMBER, value)

  /**
    * Traverse to nodes where columnNumber is not equal to any of the given `values`.
    * */
  def columnNumberNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.COLUMN_NUMBER.where(P.within(values.toSet)))



}
