package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object MethodParameterOut {
  def apply(graph: Graph, id: Long) = new MethodParameterOut(graph, id)

  val Label = "METHOD_PARAMETER_OUT"
  val LabelId: Int = 33

  object PropertyNames {
    val Code = "CODE" 
    val Order = "ORDER" 
    val Name = "NAME" 
    val EvaluationStrategy = "EVALUATION_STRATEGY" 
    val TypeFullName = "TYPE_FULL_NAME" 
    val LineNumber = "LINE_NUMBER" 
    val ColumnNumber = "COLUMN_NUMBER" 
    val all: Set[String] = Set(Code, Order, Name, EvaluationStrategy, TypeFullName, LineNumber, ColumnNumber)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Code = new PropertyKey[String]("CODE") 
    val Order = new PropertyKey[Integer]("ORDER") 
    val Name = new PropertyKey[String]("NAME") 
    val EvaluationStrategy = new PropertyKey[String]("EVALUATION_STRATEGY") 
    val TypeFullName = new PropertyKey[String]("TYPE_FULL_NAME") 
    val LineNumber = new PropertyKey[Integer]("LINE_NUMBER") 
    val ColumnNumber = new PropertyKey[Integer]("COLUMN_NUMBER") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.EvalType.layoutInformation, edges.TaggedBy.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Ast.layoutInformation, edges.TaintRemove.layoutInformation, edges.ContainsNode.layoutInformation, edges.Propagate.layoutInformation, edges.ParameterLink.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("AST","TAINT_REMOVE","CONTAINS_NODE","PROPAGATE","PARAMETER_LINK")
    val Out: Array[String] = Array("EVAL_TYPE","TAGGED_BY","CONTAINS_NODE")
  }

  val factory = new NodeFactory[MethodParameterOutDb] {
    override val forLabel = MethodParameterOut.Label
    override val forLabelId = MethodParameterOut.LabelId

    override def createNode(ref: NodeRef[MethodParameterOutDb]) =
      new MethodParameterOutDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = MethodParameterOut(graph, id)
  }
}

trait MethodParameterOutBase extends CpgNode with DeclarationBase with TrackingPointBase with AstNodeBase with HasCode with HasOrder with HasName with HasEvaluationStrategy with HasTypeFullName with HasLineNumber with HasColumnNumber {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class MethodParameterOut(graph: Graph, id: Long) extends NodeRef[MethodParameterOutDb](graph, id)
  with MethodParameterOutBase
  with StoredNode
  with Declaration with TrackingPoint with AstNode {
    override def code: String = get().code
  override def order: Integer = get().order
  override def name: String = get().name
  override def evaluationStrategy: String = get().evaluationStrategy
  override def typeFullName: String = get().typeFullName
  override def lineNumber: Option[Integer] = get().lineNumber
  override def columnNumber: Option[Integer] = get().columnNumber
  
  def _typeViaEvalTypeOut: Iterator[Type] = get()._typeViaEvalTypeOut
override def _evalTypeOut(): JIterator[StoredNode] = get()._evalTypeOut
def _tagViaTaggedByOut: Iterator[Tag] = get()._tagViaTaggedByOut
override def _taggedByOut(): JIterator[StoredNode] = get()._taggedByOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodViaAstIn: Iterator[Method] = get()._methodViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _methodParameterInViaTaintRemoveIn: Iterator[MethodParameterIn] = get()._methodParameterInViaTaintRemoveIn
override def _taintRemoveIn(): JIterator[StoredNode] = get()._taintRemoveIn
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = get()._methodSummaryViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
def _methodParameterInViaPropagateIn: Iterator[MethodParameterIn] = get()._methodParameterInViaPropagateIn
override def _propagateIn(): JIterator[StoredNode] = get()._propagateIn
def _methodParameterInViaParameterLinkIn: Iterator[MethodParameterIn] = get()._methodParameterInViaParameterLinkIn
override def _parameterLinkIn(): JIterator[StoredNode] = get()._parameterLinkIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    MethodParameterOut.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
case 3 => "name" 
case 4 => "evaluationStrategy" 
case 5 => "typeFullName" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => code
case 2 => order
case 3 => name
case 4 => evaluationStrategy
case 5 => typeFullName
case 6 => lineNumber
case 7 => columnNumber
    }

  override def productPrefix = "MethodParameterOut"
  override def productArity = 8
}

class MethodParameterOutDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
  with Declaration with TrackingPoint with AstNode with MethodParameterOutBase {

  override def layoutInformation: NodeLayoutInformation = MethodParameterOut.layoutInformation

private var _code: String = null
def code(): String = _code

private var _order: Integer = null
def order(): Integer = _order

private var _name: String = null
def name(): String = _name

private var _evaluationStrategy: String = null
def evaluationStrategy(): String = _evaluationStrategy

private var _typeFullName: String = null
def typeFullName(): String = _typeFullName

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (code != null) { properties.put("CODE", code) }
if (order != null) { properties.put("ORDER", order) }
if (name != null) { properties.put("NAME", name) }
if (evaluationStrategy != null) { properties.put("EVALUATION_STRATEGY", evaluationStrategy) }
if (typeFullName != null) { properties.put("TYPE_FULL_NAME", typeFullName) }
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }

  properties
}

  def _typeViaEvalTypeOut: Iterator[Type] = _evalTypeOut.asScala.collect { case node: Type => node }
override def _evalTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _tagViaTaggedByOut: Iterator[Tag] = _taggedByOut.asScala.collect { case node: Tag => node }
override def _taggedByOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstIn: Iterator[Method] = _astIn.asScala.collect { case node: Method => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _methodParameterInViaTaintRemoveIn: Iterator[MethodParameterIn] = _taintRemoveIn.asScala.collect { case node: MethodParameterIn => node }
override def _taintRemoveIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = _containsNodeIn.asScala.collect { case node: MethodSummary => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _methodParameterInViaPropagateIn: Iterator[MethodParameterIn] = _propagateIn.asScala.collect { case node: MethodParameterIn => node }
override def _propagateIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _methodParameterInViaParameterLinkIn: Iterator[MethodParameterIn] = _parameterLinkIn.asScala.collect { case node: MethodParameterIn => node }
override def _parameterLinkIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    MethodParameterOut.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "code" 
case 2 => "order" 
case 3 => "name" 
case 4 => "evaluationStrategy" 
case 5 => "typeFullName" 
case 6 => "lineNumber" 
case 7 => "columnNumber" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => code
case 2 => order
case 3 => name
case 4 => evaluationStrategy
case 5 => typeFullName
case 6 => lineNumber
case 7 => columnNumber
    }

  override def productPrefix = "MethodParameterOut"
  override def productArity = 8

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[MethodParameterOutDb]

  override def property(key:String): AnyRef = {
    key match {
      case "CODE" => this._code
      case "ORDER" => this._order
      case "NAME" => this._name
      case "EVALUATION_STRATEGY" => this._evaluationStrategy
      case "TYPE_FULL_NAME" => this._typeFullName
      case "LINE_NUMBER" => this._lineNumber.orNull
      case "COLUMN_NUMBER" => this._columnNumber.orNull
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "CODE" => this._code = value.asInstanceOf[String]
      case "ORDER" => this._order = value.asInstanceOf[Integer]
      case "NAME" => this._name = value.asInstanceOf[String]
      case "EVALUATION_STRATEGY" => this._evaluationStrategy = value.asInstanceOf[String]
      case "TYPE_FULL_NAME" => this._typeFullName = value.asInstanceOf[String]
      case "LINE_NUMBER" => this._lineNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "COLUMN_NUMBER" => this._columnNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewMethodParameterOut]
   this._code = other.code
   this._order = other.order
   this._name = other.name
   this._evaluationStrategy = other.evaluationStrategy
   this._typeFullName = other.typeFullName
   this._lineNumber = other.lineNumber
   this._columnNumber = other.columnNumber


}

}

/** Traversal steps for MethodParameterOut */
class MethodParameterOutTraversal[NodeType <: MethodParameterOut](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to code property */
  def code: Traversal[String] =
    traversal.map(_.code)

    /**
    * Traverse to nodes where the code matches the regular expression `value`
    * */
  def code(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the code matches at least one of the regular expressions in `values`
    * */
  def code(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where code matches `value` exactly.
    * */
  def codeExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE, value)

  /**
    * Traverse to nodes where code matches one of the elements in `values` exactly.
    * */
  def codeExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where code does not match the regular expression `value`.
    * */
  def codeNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where code does not match any of the regular expressions in `values`.
    * */
  def codeNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.within(values.to(Set))))



  /** Traverse to order property */
  def order: Traversal[Integer] =
    traversal.map(_.order)

    /**
    * Traverse to nodes where the order equals the given `value`
    * */
  def order(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where the order equals at least one of the given `values`
    * */
  def order(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the order is greater than the given `value`
    * */
  def orderGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ > value))

  /**
    * Traverse to nodes where the order is greater than or equal the given `value`
    * */
  def orderGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ >= value))

  /**
    * Traverse to nodes where the order is less than the given `value`
    * */
  def orderLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ < value))

  /**
    * Traverse to nodes where the order is less than or equal the given `value`
    * */
  def orderLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ <= value))

  /**
    * Traverse to nodes where order is not equal to the given `value`.
    * */
  def orderNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where order is not equal to any of the given `values`.
    * */
  def orderNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER.where(P.within(values.toSet)))


  /** Traverse to name property */
  def name: Traversal[String] =
    traversal.map(_.name)

    /**
    * Traverse to nodes where the name matches the regular expression `value`
    * */
  def name(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the name matches at least one of the regular expressions in `values`
    * */
  def name(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where name matches `value` exactly.
    * */
  def nameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME, value)

  /**
    * Traverse to nodes where name matches one of the elements in `values` exactly.
    * */
  def nameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where name does not match the regular expression `value`.
    * */
  def nameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where name does not match any of the regular expressions in `values`.
    * */
  def nameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.within(values.to(Set))))



  /** Traverse to evaluationStrategy property */
  def evaluationStrategy: Traversal[String] =
    traversal.map(_.evaluationStrategy)

    /**
    * Traverse to nodes where the evaluationStrategy matches the regular expression `value`
    * */
  def evaluationStrategy(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.EVALUATION_STRATEGY.where(P.matches(regex)))

  /**
    * Traverse to nodes where the evaluationStrategy matches at least one of the regular expressions in `values`
    * */
  def evaluationStrategy(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.EVALUATION_STRATEGY.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where evaluationStrategy matches `value` exactly.
    * */
  def evaluationStrategyExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.EVALUATION_STRATEGY, value)

  /**
    * Traverse to nodes where evaluationStrategy matches one of the elements in `values` exactly.
    * */
  def evaluationStrategyExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.EVALUATION_STRATEGY.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where evaluationStrategy does not match the regular expression `value`.
    * */
  def evaluationStrategyNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.EVALUATION_STRATEGY.where(P.matches(regex)))

  /**
    * Traverse to nodes where evaluationStrategy does not match any of the regular expressions in `values`.
    * */
  def evaluationStrategyNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.EVALUATION_STRATEGY.where(P.within(values.to(Set))))



  /** Traverse to typeFullName property */
  def typeFullName: Traversal[String] =
    traversal.map(_.typeFullName)

    /**
    * Traverse to nodes where the typeFullName matches the regular expression `value`
    * */
  def typeFullName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.TYPE_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the typeFullName matches at least one of the regular expressions in `values`
    * */
  def typeFullName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.TYPE_FULL_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where typeFullName matches `value` exactly.
    * */
  def typeFullNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.TYPE_FULL_NAME, value)

  /**
    * Traverse to nodes where typeFullName matches one of the elements in `values` exactly.
    * */
  def typeFullNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.TYPE_FULL_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where typeFullName does not match the regular expression `value`.
    * */
  def typeFullNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.TYPE_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where typeFullName does not match any of the regular expressions in `values`.
    * */
  def typeFullNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.TYPE_FULL_NAME.where(P.within(values.to(Set))))



  /** Traverse to lineNumber property */
  def lineNumber: Traversal[Integer] =
    traversal.flatMap(_.lineNumber)

    /**
    * Traverse to nodes where the lineNumber equals the given `value`
    * */
  def lineNumber(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER, value)

  /**
    * Traverse to nodes where the lineNumber equals at least one of the given `values`
    * */
  def lineNumber(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the lineNumber is greater than the given `value`
    * */
  def lineNumberGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ > value))

  /**
    * Traverse to nodes where the lineNumber is greater than or equal the given `value`
    * */
  def lineNumberGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ >= value))

  /**
    * Traverse to nodes where the lineNumber is less than the given `value`
    * */
  def lineNumberLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ < value))

  /**
    * Traverse to nodes where the lineNumber is less than or equal the given `value`
    * */
  def lineNumberLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ <= value))

  /**
    * Traverse to nodes where lineNumber is not equal to the given `value`.
    * */
  def lineNumberNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LINE_NUMBER, value)

  /**
    * Traverse to nodes where lineNumber is not equal to any of the given `values`.
    * */
  def lineNumberNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LINE_NUMBER.where(P.within(values.toSet)))


  /** Traverse to columnNumber property */
  def columnNumber: Traversal[Integer] =
    traversal.flatMap(_.columnNumber)

    /**
    * Traverse to nodes where the columnNumber equals the given `value`
    * */
  def columnNumber(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER, value)

  /**
    * Traverse to nodes where the columnNumber equals at least one of the given `values`
    * */
  def columnNumber(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the columnNumber is greater than the given `value`
    * */
  def columnNumberGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ > value))

  /**
    * Traverse to nodes where the columnNumber is greater than or equal the given `value`
    * */
  def columnNumberGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ >= value))

  /**
    * Traverse to nodes where the columnNumber is less than the given `value`
    * */
  def columnNumberLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ < value))

  /**
    * Traverse to nodes where the columnNumber is less than or equal the given `value`
    * */
  def columnNumberLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ <= value))

  /**
    * Traverse to nodes where columnNumber is not equal to the given `value`.
    * */
  def columnNumberNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.COLUMN_NUMBER, value)

  /**
    * Traverse to nodes where columnNumber is not equal to any of the given `values`.
    * */
  def columnNumberNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.COLUMN_NUMBER.where(P.within(values.toSet)))



}
