package io.shiftleft.codepropertygraph.generated.nodes

import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Map => JMap, Set => JSet}

/** base type for all nodes that can be added to a graph, e.g. the diffgraph */
trait NewNode extends CpgNode {
  def properties: Map[String, Any]
}

object NewLocal{
  def apply(code: String = "", name: String = "", closureBindingId: Option[String] = None, typeFullName: String = "", dynamicTypeHintFullName: List[String] = List(), lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None, order: Integer = -1): NewLocal = new NewLocal(code = code, name = name, closureBindingId = closureBindingId, typeFullName = typeFullName, dynamicTypeHintFullName = dynamicTypeHintFullName, lineNumber = lineNumber, columnNumber = columnNumber, order = order)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewLocal(var code: String = "", var name: String = "", var closureBindingId: Option[String] = None, var typeFullName: String = "", var dynamicTypeHintFullName: List[String] = List(), var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None, var order: Integer = -1) extends NewNode with LocalBase {
  override def label:String = "LOCAL"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (name != null) { res += "NAME" -> name }
  if (closureBindingId != null && closureBindingId.isDefined) { res += "CLOSURE_BINDING_ID" -> closureBindingId.get }
  if (typeFullName != null) { res += "TYPE_FULL_NAME" -> typeFullName }
  if (dynamicTypeHintFullName != null && dynamicTypeHintFullName.nonEmpty) { res += "DYNAMIC_TYPE_HINT_FULL_NAME" -> dynamicTypeHintFullName }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (order != null) { res += "ORDER" -> order }

  res
}
}

object NewComment{
  def apply(lineNumber: Option[Integer] = None, code: String = ""): NewComment = new NewComment(lineNumber = lineNumber, code = code)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewComment(var lineNumber: Option[Integer] = None, var code: String = "") extends NewNode with CommentBase {
  override def label:String = "COMMENT"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (code != null) { res += "CODE" -> code }

  res
}
}

object NewMethod{
  def apply(code: String = "", name: String = "", fullName: String = "", isExternal: JBoolean = false, signature: String = "", astParentType: String = "", astParentFullName: String = "", lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None, lineNumberEnd: Option[Integer] = None, columnNumberEnd: Option[Integer] = None, order: Integer = -1, filename: String = "", hasMapping: Option[JBoolean] = None, depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None, binarySignature: Option[String] = None): NewMethod = new NewMethod(code = code, name = name, fullName = fullName, isExternal = isExternal, signature = signature, astParentType = astParentType, astParentFullName = astParentFullName, lineNumber = lineNumber, columnNumber = columnNumber, lineNumberEnd = lineNumberEnd, columnNumberEnd = columnNumberEnd, order = order, filename = filename, hasMapping = hasMapping, depthFirstOrder = depthFirstOrder, internalFlags = internalFlags, binarySignature = binarySignature)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewMethod(var code: String = "", var name: String = "", var fullName: String = "", var isExternal: JBoolean = false, var signature: String = "", var astParentType: String = "", var astParentFullName: String = "", var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None, var lineNumberEnd: Option[Integer] = None, var columnNumberEnd: Option[Integer] = None, var order: Integer = -1, var filename: String = "", var hasMapping: Option[JBoolean] = None, var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None, var binarySignature: Option[String] = None) extends NewNode with MethodBase {
  override def label:String = "METHOD"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (name != null) { res += "NAME" -> name }
  if (fullName != null) { res += "FULL_NAME" -> fullName }
  if (isExternal != null) { res += "IS_EXTERNAL" -> isExternal }
  if (signature != null) { res += "SIGNATURE" -> signature }
  if (astParentType != null) { res += "AST_PARENT_TYPE" -> astParentType }
  if (astParentFullName != null) { res += "AST_PARENT_FULL_NAME" -> astParentFullName }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (lineNumberEnd != null && lineNumberEnd.isDefined) { res += "LINE_NUMBER_END" -> lineNumberEnd.get }
  if (columnNumberEnd != null && columnNumberEnd.isDefined) { res += "COLUMN_NUMBER_END" -> columnNumberEnd.get }
  if (order != null) { res += "ORDER" -> order }
  if (filename != null) { res += "FILENAME" -> filename }
  if (hasMapping != null && hasMapping.isDefined) { res += "HAS_MAPPING" -> hasMapping.get }
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }
  if (binarySignature != null && binarySignature.isDefined) { res += "BINARY_SIGNATURE" -> binarySignature.get }

  res
}
}

object NewTag{
  def apply(name: String = "", value: String = ""): NewTag = new NewTag(name = name, value = value)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewTag(var name: String = "", var value: String = "") extends NewNode with TagBase {
  override def label:String = "TAG"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (value != null) { res += "VALUE" -> value }

  res
}
}

object NewTypeRef{
  def apply(code: String = "", order: Integer = -1, argumentIndex: Integer = -1, typeFullName: String = "", dynamicTypeHintFullName: List[String] = List(), lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None, depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None): NewTypeRef = new NewTypeRef(code = code, order = order, argumentIndex = argumentIndex, typeFullName = typeFullName, dynamicTypeHintFullName = dynamicTypeHintFullName, lineNumber = lineNumber, columnNumber = columnNumber, depthFirstOrder = depthFirstOrder, internalFlags = internalFlags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewTypeRef(var code: String = "", var order: Integer = -1, var argumentIndex: Integer = -1, var typeFullName: String = "", var dynamicTypeHintFullName: List[String] = List(), var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None, var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None) extends NewNode with TypeRefBase {
  override def label:String = "TYPE_REF"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (order != null) { res += "ORDER" -> order }
  if (argumentIndex != null) { res += "ARGUMENT_INDEX" -> argumentIndex }
  if (typeFullName != null) { res += "TYPE_FULL_NAME" -> typeFullName }
  if (dynamicTypeHintFullName != null && dynamicTypeHintFullName.nonEmpty) { res += "DYNAMIC_TYPE_HINT_FULL_NAME" -> dynamicTypeHintFullName }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }

  res
}
}

object NewAnnotationLiteral{
  def apply(depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None, code: String = "", name: String = "", order: Integer = -1, argumentIndex: Integer = -1, columnNumber: Option[Integer] = None, lineNumber: Option[Integer] = None): NewAnnotationLiteral = new NewAnnotationLiteral(depthFirstOrder = depthFirstOrder, internalFlags = internalFlags, code = code, name = name, order = order, argumentIndex = argumentIndex, columnNumber = columnNumber, lineNumber = lineNumber)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewAnnotationLiteral(var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None, var code: String = "", var name: String = "", var order: Integer = -1, var argumentIndex: Integer = -1, var columnNumber: Option[Integer] = None, var lineNumber: Option[Integer] = None) extends NewNode with AnnotationLiteralBase {
  override def label:String = "ANNOTATION_LITERAL"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }
  if (code != null) { res += "CODE" -> code }
  if (name != null) { res += "NAME" -> name }
  if (order != null) { res += "ORDER" -> order }
  if (argumentIndex != null) { res += "ARGUMENT_INDEX" -> argumentIndex }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }

  res
}
}

object NewIoflow{
  def apply(fingerprint: String = "", literalsToSink: List[String] = List(), dataTags: List[TagBase] = List(), sourceDescriptorTags: List[TagBase] = List(), sinkDescriptorTags: List[TagBase] = List(), sourceTags: List[TagBase] = List(), dstTags: List[TagBase] = List(), source: SourceBase, sink: SinkBase, transforms: List[TransformBase] = List(), sourceDescriptorFlows: List[FlowBase] = List(), sinkDescriptorFlows: List[FlowBase] = List(), primaryFlow: FlowBase, triggerMethods: List[MethodBase] = List()): NewIoflow = new NewIoflow(fingerprint = fingerprint, literalsToSink = literalsToSink, dataTags = dataTags, sourceDescriptorTags = sourceDescriptorTags, sinkDescriptorTags = sinkDescriptorTags, sourceTags = sourceTags, dstTags = dstTags, source = source, sink = sink, transforms = transforms, sourceDescriptorFlows = sourceDescriptorFlows, sinkDescriptorFlows = sinkDescriptorFlows, primaryFlow = primaryFlow, triggerMethods = triggerMethods)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewIoflow(var fingerprint: String = "", var literalsToSink: List[String] = List(), var dataTags: List[TagBase] = List(), var sourceDescriptorTags: List[TagBase] = List(), var sinkDescriptorTags: List[TagBase] = List(), var sourceTags: List[TagBase] = List(), var dstTags: List[TagBase] = List(), var source: SourceBase, var sink: SinkBase, var transforms: List[TransformBase] = List(), var sourceDescriptorFlows: List[FlowBase] = List(), var sinkDescriptorFlows: List[FlowBase] = List(), var primaryFlow: FlowBase, var triggerMethods: List[MethodBase] = List()) extends NewNode with IoflowBase {
  override def label:String = "IOFLOW"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (fingerprint != null) { res += "FINGERPRINT" -> fingerprint }
  if (literalsToSink != null && literalsToSink.nonEmpty) { res += "LITERALS_TO_SINK" -> literalsToSink }
  if (dataTags != null && dataTags.nonEmpty) { res += "dataTags" -> dataTags }
  if (sourceDescriptorTags != null && sourceDescriptorTags.nonEmpty) { res += "sourceDescriptorTags" -> sourceDescriptorTags }
  if (sinkDescriptorTags != null && sinkDescriptorTags.nonEmpty) { res += "sinkDescriptorTags" -> sinkDescriptorTags }
  if (sourceTags != null && sourceTags.nonEmpty) { res += "sourceTags" -> sourceTags }
  if (dstTags != null && dstTags.nonEmpty) { res += "dstTags" -> dstTags }
  if (source != null) { res += "source" -> source }
  if (sink != null) { res += "sink" -> sink }
  if (transforms != null && transforms.nonEmpty) { res += "transforms" -> transforms }
  if (sourceDescriptorFlows != null && sourceDescriptorFlows.nonEmpty) { res += "sourceDescriptorFlows" -> sourceDescriptorFlows }
  if (sinkDescriptorFlows != null && sinkDescriptorFlows.nonEmpty) { res += "sinkDescriptorFlows" -> sinkDescriptorFlows }
  if (primaryFlow != null) { res += "primaryFlow" -> primaryFlow }
  if (triggerMethods != null && triggerMethods.nonEmpty) { res += "triggerMethods" -> triggerMethods }
  res
}
}

object NewTransform{
  def apply(triggerCallChains: List[CallChainBase] = List(), descriptorFlows: List[FlowBase] = List(), call: CallBase, sink: SinkBase): NewTransform = new NewTransform(triggerCallChains = triggerCallChains, descriptorFlows = descriptorFlows, call = call, sink = sink)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewTransform(var triggerCallChains: List[CallChainBase] = List(), var descriptorFlows: List[FlowBase] = List(), var call: CallBase, var sink: SinkBase) extends NewNode with TransformBase {
  override def label:String = "TRANSFORM"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (triggerCallChains != null && triggerCallChains.nonEmpty) { res += "triggerCallChains" -> triggerCallChains }
  if (descriptorFlows != null && descriptorFlows.nonEmpty) { res += "descriptorFlows" -> descriptorFlows }
  if (call != null) { res += "call" -> call }
  if (sink != null) { res += "sink" -> sink }
  res
}
}

object NewRead{
  def apply(triggerCallChains: List[CallChainBase] = List(), descriptorFlows: List[FlowBase] = List(), source: SourceBase): NewRead = new NewRead(triggerCallChains = triggerCallChains, descriptorFlows = descriptorFlows, source = source)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewRead(var triggerCallChains: List[CallChainBase] = List(), var descriptorFlows: List[FlowBase] = List(), var source: SourceBase) extends NewNode with ReadBase {
  override def label:String = "READ"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (triggerCallChains != null && triggerCallChains.nonEmpty) { res += "triggerCallChains" -> triggerCallChains }
  if (descriptorFlows != null && descriptorFlows.nonEmpty) { res += "descriptorFlows" -> descriptorFlows }
  if (source != null) { res += "source" -> source }
  res
}
}

object NewMethodParameterIn{
  def apply(code: String = "", order: Integer = -1, name: String = "", evaluationStrategy: String = "", typeFullName: String = "", dynamicTypeHintFullName: List[String] = List(), lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None): NewMethodParameterIn = new NewMethodParameterIn(code = code, order = order, name = name, evaluationStrategy = evaluationStrategy, typeFullName = typeFullName, dynamicTypeHintFullName = dynamicTypeHintFullName, lineNumber = lineNumber, columnNumber = columnNumber)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewMethodParameterIn(var code: String = "", var order: Integer = -1, var name: String = "", var evaluationStrategy: String = "", var typeFullName: String = "", var dynamicTypeHintFullName: List[String] = List(), var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None) extends NewNode with MethodParameterInBase {
  override def label:String = "METHOD_PARAMETER_IN"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (order != null) { res += "ORDER" -> order }
  if (name != null) { res += "NAME" -> name }
  if (evaluationStrategy != null) { res += "EVALUATION_STRATEGY" -> evaluationStrategy }
  if (typeFullName != null) { res += "TYPE_FULL_NAME" -> typeFullName }
  if (dynamicTypeHintFullName != null && dynamicTypeHintFullName.nonEmpty) { res += "DYNAMIC_TYPE_HINT_FULL_NAME" -> dynamicTypeHintFullName }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }

  res
}
}

object NewNamespace{
  def apply(name: String = "", order: Integer = -1): NewNamespace = new NewNamespace(name = name, order = order)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewNamespace(var name: String = "", var order: Integer = -1) extends NewNode with NamespaceBase {
  override def label:String = "NAMESPACE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (order != null) { res += "ORDER" -> order }

  res
}
}

object NewVariableInfo{
  def apply(varType: String = "", evaluationType: String = "", parameterIndex: Option[Integer] = None): NewVariableInfo = new NewVariableInfo(varType = varType, evaluationType = evaluationType, parameterIndex = parameterIndex)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewVariableInfo(var varType: String = "", var evaluationType: String = "", var parameterIndex: Option[Integer] = None) extends NewNode with VariableInfoBase {
  override def label:String = "VARIABLE_INFO"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (varType != null) { res += "VAR_TYPE" -> varType }
  if (evaluationType != null) { res += "EVALUATION_TYPE" -> evaluationType }
  if (parameterIndex != null && parameterIndex.isDefined) { res += "PARAMETER_INDEX" -> parameterIndex.get }

  res
}
}

object NewFlow{
  def apply(points: List[ProgramPointBase] = List(), source: SourceBase, sink: SinkBase, transformations: List[TransformationBase] = List(), branchPoints: List[TrackingPointBase] = List(), cfgNodes: List[CfgNodeBase] = List()): NewFlow = new NewFlow(points = points, source = source, sink = sink, transformations = transformations, branchPoints = branchPoints, cfgNodes = cfgNodes)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewFlow(var points: List[ProgramPointBase] = List(), var source: SourceBase, var sink: SinkBase, var transformations: List[TransformationBase] = List(), var branchPoints: List[TrackingPointBase] = List(), var cfgNodes: List[CfgNodeBase] = List()) extends NewNode with FlowBase {
  override def label:String = "FLOW"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (points != null && points.nonEmpty) { res += "points" -> points }
  if (source != null) { res += "source" -> source }
  if (sink != null) { res += "sink" -> sink }
  if (transformations != null && transformations.nonEmpty) { res += "transformations" -> transformations }
  if (branchPoints != null && branchPoints.nonEmpty) { res += "branchPoints" -> branchPoints }
  if (cfgNodes != null && cfgNodes.nonEmpty) { res += "cfgNodes" -> cfgNodes }
  res
}
}

object NewClosureBinding{
  def apply(closureBindingId: Option[String] = None, evaluationStrategy: String = "", closureOriginalName: Option[String] = None): NewClosureBinding = new NewClosureBinding(closureBindingId = closureBindingId, evaluationStrategy = evaluationStrategy, closureOriginalName = closureOriginalName)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewClosureBinding(var closureBindingId: Option[String] = None, var evaluationStrategy: String = "", var closureOriginalName: Option[String] = None) extends NewNode with ClosureBindingBase {
  override def label:String = "CLOSURE_BINDING"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (closureBindingId != null && closureBindingId.isDefined) { res += "CLOSURE_BINDING_ID" -> closureBindingId.get }
  if (evaluationStrategy != null) { res += "EVALUATION_STRATEGY" -> evaluationStrategy }
  if (closureOriginalName != null && closureOriginalName.isDefined) { res += "CLOSURE_ORIGINAL_NAME" -> closureOriginalName.get }

  res
}
}

object NewUnknown{
  def apply(code: String = "", parserTypeName: String = "", order: Integer = -1, argumentIndex: Integer = -1, typeFullName: String = "", dynamicTypeHintFullName: List[String] = List(), lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None, depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None): NewUnknown = new NewUnknown(code = code, parserTypeName = parserTypeName, order = order, argumentIndex = argumentIndex, typeFullName = typeFullName, dynamicTypeHintFullName = dynamicTypeHintFullName, lineNumber = lineNumber, columnNumber = columnNumber, depthFirstOrder = depthFirstOrder, internalFlags = internalFlags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewUnknown(var code: String = "", var parserTypeName: String = "", var order: Integer = -1, var argumentIndex: Integer = -1, var typeFullName: String = "", var dynamicTypeHintFullName: List[String] = List(), var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None, var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None) extends NewNode with UnknownBase {
  override def label:String = "UNKNOWN"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (parserTypeName != null) { res += "PARSER_TYPE_NAME" -> parserTypeName }
  if (order != null) { res += "ORDER" -> order }
  if (argumentIndex != null) { res += "ARGUMENT_INDEX" -> argumentIndex }
  if (typeFullName != null) { res += "TYPE_FULL_NAME" -> typeFullName }
  if (dynamicTypeHintFullName != null && dynamicTypeHintFullName.nonEmpty) { res += "DYNAMIC_TYPE_HINT_FULL_NAME" -> dynamicTypeHintFullName }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }

  res
}
}

object NewAnnotationParameter{
  def apply(code: String = "", order: Integer = -1): NewAnnotationParameter = new NewAnnotationParameter(code = code, order = order)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewAnnotationParameter(var code: String = "", var order: Integer = -1) extends NewNode with AnnotationParameterBase {
  override def label:String = "ANNOTATION_PARAMETER"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (order != null) { res += "ORDER" -> order }

  res
}
}

object NewDetachedTrackingPoint{
  def apply(cfgNode: CfgNodeBase): NewDetachedTrackingPoint = new NewDetachedTrackingPoint(cfgNode = cfgNode)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewDetachedTrackingPoint(var cfgNode: CfgNodeBase) extends NewNode with DetachedTrackingPointBase {
  override def label:String = "DETACHED_TRACKING_POINT"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (cfgNode != null) { res += "cfgNode" -> cfgNode }
  res
}
}

object NewSensitiveDataType{
  def apply(fullName: String = "", names: List[MatchInfoBase] = List(), members: List[SensitiveMemberBase] = List()): NewSensitiveDataType = new NewSensitiveDataType(fullName = fullName, names = names, members = members)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewSensitiveDataType(var fullName: String = "", var names: List[MatchInfoBase] = List(), var members: List[SensitiveMemberBase] = List()) extends NewNode with SensitiveDataTypeBase {
  override def label:String = "SENSITIVE_DATA_TYPE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (fullName != null) { res += "FULL_NAME" -> fullName }
  if (names != null && names.nonEmpty) { res += "names" -> names }
  if (members != null && members.nonEmpty) { res += "members" -> members }
  res
}
}

object NewMember{
  def apply(code: String = "", name: String = "", typeFullName: String = "", dynamicTypeHintFullName: List[String] = List(), order: Integer = -1): NewMember = new NewMember(code = code, name = name, typeFullName = typeFullName, dynamicTypeHintFullName = dynamicTypeHintFullName, order = order)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewMember(var code: String = "", var name: String = "", var typeFullName: String = "", var dynamicTypeHintFullName: List[String] = List(), var order: Integer = -1) extends NewNode with MemberBase {
  override def label:String = "MEMBER"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (name != null) { res += "NAME" -> name }
  if (typeFullName != null) { res += "TYPE_FULL_NAME" -> typeFullName }
  if (dynamicTypeHintFullName != null && dynamicTypeHintFullName.nonEmpty) { res += "DYNAMIC_TYPE_HINT_FULL_NAME" -> dynamicTypeHintFullName }
  if (order != null) { res += "ORDER" -> order }

  res
}
}

object NewCallSite{
  def apply(method: MethodBase, call: CallBase, callerMethod: MethodBase): NewCallSite = new NewCallSite(method = method, call = call, callerMethod = callerMethod)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewCallSite(var method: MethodBase, var call: CallBase, var callerMethod: MethodBase) extends NewNode with CallSiteBase {
  override def label:String = "CALL_SITE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (method != null) { res += "method" -> method }
  if (call != null) { res += "call" -> call }
  if (callerMethod != null) { res += "callerMethod" -> callerMethod }
  res
}
}

object NewMethodInst{
  def apply(name: String = "", signature: String = "", fullName: String = "", methodFullName: String = "", order: Integer = -1): NewMethodInst = new NewMethodInst(name = name, signature = signature, fullName = fullName, methodFullName = methodFullName, order = order)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewMethodInst(var name: String = "", var signature: String = "", var fullName: String = "", var methodFullName: String = "", var order: Integer = -1) extends NewNode with MethodInstBase {
  override def label:String = "METHOD_INST"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (signature != null) { res += "SIGNATURE" -> signature }
  if (fullName != null) { res += "FULL_NAME" -> fullName }
  if (methodFullName != null) { res += "METHOD_FULL_NAME" -> methodFullName }
  if (order != null) { res += "ORDER" -> order }

  res
}
}

object NewConfigFile{
  def apply(name: String = "", content: String = ""): NewConfigFile = new NewConfigFile(name = name, content = content)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewConfigFile(var name: String = "", var content: String = "") extends NewNode with ConfigFileBase {
  override def label:String = "CONFIG_FILE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (content != null) { res += "CONTENT" -> content }

  res
}
}

object NewSensitiveReference{
  def apply(ioflows: List[IoflowBase] = List()): NewSensitiveReference = new NewSensitiveReference(ioflows = ioflows)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewSensitiveReference(var ioflows: List[IoflowBase] = List()) extends NewNode with SensitiveReferenceBase {
  override def label:String = "SENSITIVE_REFERENCE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (ioflows != null && ioflows.nonEmpty) { res += "ioflows" -> ioflows }
  res
}
}

object NewLocation{
  def apply(symbol: String = "", methodFullName: String = "", methodShortName: String = "", packageName: String = "", lineNumber: Option[Integer] = None, className: String = "", classShortName: String = "", nodeLabel: String = "", filename: String = "", node: Option[CpgNode] = None): NewLocation = new NewLocation(symbol = symbol, methodFullName = methodFullName, methodShortName = methodShortName, packageName = packageName, lineNumber = lineNumber, className = className, classShortName = classShortName, nodeLabel = nodeLabel, filename = filename, node = node)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewLocation(var symbol: String = "", var methodFullName: String = "", var methodShortName: String = "", var packageName: String = "", var lineNumber: Option[Integer] = None, var className: String = "", var classShortName: String = "", var nodeLabel: String = "", var filename: String = "", var node: Option[CpgNode] = None) extends NewNode with LocationBase {
  override def label:String = "LOCATION"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (symbol != null) { res += "SYMBOL" -> symbol }
  if (methodFullName != null) { res += "METHOD_FULL_NAME" -> methodFullName }
  if (methodShortName != null) { res += "METHOD_SHORT_NAME" -> methodShortName }
  if (packageName != null) { res += "PACKAGE_NAME" -> packageName }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (className != null) { res += "CLASS_NAME" -> className }
  if (classShortName != null) { res += "CLASS_SHORT_NAME" -> classShortName }
  if (nodeLabel != null) { res += "NODE_LABEL" -> nodeLabel }
  if (filename != null) { res += "FILENAME" -> filename }
  if (node != null && node.isDefined) { res += "node" -> node.get }
  res
}
}

object NewMetaData{
  def apply(language: String = "", version: String = "", overlays: List[String] = List(), policyDirectories: List[String] = List(), spid: Option[String] = None): NewMetaData = new NewMetaData(language = language, version = version, overlays = overlays, policyDirectories = policyDirectories, spid = spid)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewMetaData(var language: String = "", var version: String = "", var overlays: List[String] = List(), var policyDirectories: List[String] = List(), var spid: Option[String] = None) extends NewNode with MetaDataBase {
  override def label:String = "META_DATA"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (language != null) { res += "LANGUAGE" -> language }
  if (version != null) { res += "VERSION" -> version }
  if (overlays != null && overlays.nonEmpty) { res += "OVERLAYS" -> overlays }
  if (policyDirectories != null && policyDirectories.nonEmpty) { res += "POLICY_DIRECTORIES" -> policyDirectories }
  if (spid != null && spid.isDefined) { res += "SPID" -> spid.get }

  res
}
}

object NewReturn{
  def apply(lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None, order: Integer = -1, argumentIndex: Integer = -1, code: String = "", depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None): NewReturn = new NewReturn(lineNumber = lineNumber, columnNumber = columnNumber, order = order, argumentIndex = argumentIndex, code = code, depthFirstOrder = depthFirstOrder, internalFlags = internalFlags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewReturn(var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None, var order: Integer = -1, var argumentIndex: Integer = -1, var code: String = "", var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None) extends NewNode with ReturnBase {
  override def label:String = "RETURN"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (order != null) { res += "ORDER" -> order }
  if (argumentIndex != null) { res += "ARGUMENT_INDEX" -> argumentIndex }
  if (code != null) { res += "CODE" -> code }
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }

  res
}
}

object NewTagNodePair{
  def apply(tag: TagBase, node: CpgNode): NewTagNodePair = new NewTagNodePair(tag = tag, node = node)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewTagNodePair(var tag: TagBase, var node: CpgNode) extends NewNode with TagNodePairBase {
  override def label:String = "TAG_NODE_PAIR"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (tag != null) { res += "tag" -> tag }
  if (node != null) { res += "node" -> node }
  res
}
}

object NewDomAttribute{
  def apply(name: String = "", value: String = ""): NewDomAttribute = new NewDomAttribute(name = name, value = value)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewDomAttribute(var name: String = "", var value: String = "") extends NewNode with DomAttributeBase {
  override def label:String = "DOM_ATTRIBUTE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (value != null) { res += "VALUE" -> value }

  res
}
}

object NewTypeArgument{
  def apply(order: Integer = -1): NewTypeArgument = new NewTypeArgument(order = order)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewTypeArgument(var order: Integer = -1) extends NewNode with TypeArgumentBase {
  override def label:String = "TYPE_ARGUMENT"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (order != null) { res += "ORDER" -> order }

  res
}
}

object NewSource{
  def apply(sourceType: String = "", node: TrackingPointBase, method: MethodBase, methodTags: List[TagBase] = List(), callingMethod: Option[MethodBase] = None, callsite: Option[CallBase] = None, tags: List[TagBase] = List(), nodeType: TypeBase): NewSource = new NewSource(sourceType = sourceType, node = node, method = method, methodTags = methodTags, callingMethod = callingMethod, callsite = callsite, tags = tags, nodeType = nodeType)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewSource(var sourceType: String = "", var node: TrackingPointBase, var method: MethodBase, var methodTags: List[TagBase] = List(), var callingMethod: Option[MethodBase] = None, var callsite: Option[CallBase] = None, var tags: List[TagBase] = List(), var nodeType: TypeBase) extends NewNode with SourceBase {
  override def label:String = "SOURCE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (sourceType != null) { res += "SOURCE_TYPE" -> sourceType }
  if (node != null) { res += "node" -> node }
  if (method != null) { res += "method" -> method }
  if (methodTags != null && methodTags.nonEmpty) { res += "methodTags" -> methodTags }
  if (callingMethod != null && callingMethod.isDefined) { res += "callingMethod" -> callingMethod.get }
  if (callsite != null && callsite.isDefined) { res += "callsite" -> callsite.get }
  if (tags != null && tags.nonEmpty) { res += "tags" -> tags }
  if (nodeType != null) { res += "nodeType" -> nodeType }
  res
}
}

object NewSensitiveVariable{
  def apply(name: String = "", evalType: String = "", categories: List[String] = List(), node: LocalLikeBase): NewSensitiveVariable = new NewSensitiveVariable(name = name, evalType = evalType, categories = categories, node = node)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewSensitiveVariable(var name: String = "", var evalType: String = "", var categories: List[String] = List(), var node: LocalLikeBase) extends NewNode with SensitiveVariableBase {
  override def label:String = "SENSITIVE_VARIABLE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (evalType != null) { res += "EVAL_TYPE" -> evalType }
  if (categories != null && categories.nonEmpty) { res += "CATEGORIES" -> categories }
  if (node != null) { res += "node" -> node }
  res
}
}

object NewFieldIdentifier{
  def apply(code: String = "", canonicalName: String = "", order: Integer = -1, argumentIndex: Integer = -1, lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None, depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None): NewFieldIdentifier = new NewFieldIdentifier(code = code, canonicalName = canonicalName, order = order, argumentIndex = argumentIndex, lineNumber = lineNumber, columnNumber = columnNumber, depthFirstOrder = depthFirstOrder, internalFlags = internalFlags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewFieldIdentifier(var code: String = "", var canonicalName: String = "", var order: Integer = -1, var argumentIndex: Integer = -1, var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None, var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None) extends NewNode with FieldIdentifierBase {
  override def label:String = "FIELD_IDENTIFIER"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (canonicalName != null) { res += "CANONICAL_NAME" -> canonicalName }
  if (order != null) { res += "ORDER" -> order }
  if (argumentIndex != null) { res += "ARGUMENT_INDEX" -> argumentIndex }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }

  res
}
}

object NewWrite{
  def apply(triggerCallChains: List[CallChainBase] = List(), descriptorFlows: List[FlowBase] = List(), sink: SinkBase, flows: List[FlowBase] = List()): NewWrite = new NewWrite(triggerCallChains = triggerCallChains, descriptorFlows = descriptorFlows, sink = sink, flows = flows)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewWrite(var triggerCallChains: List[CallChainBase] = List(), var descriptorFlows: List[FlowBase] = List(), var sink: SinkBase, var flows: List[FlowBase] = List()) extends NewNode with WriteBase {
  override def label:String = "WRITE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (triggerCallChains != null && triggerCallChains.nonEmpty) { res += "triggerCallChains" -> triggerCallChains }
  if (descriptorFlows != null && descriptorFlows.nonEmpty) { res += "descriptorFlows" -> descriptorFlows }
  if (sink != null) { res += "sink" -> sink }
  if (flows != null && flows.nonEmpty) { res += "flows" -> flows }
  res
}
}

object NewKeyValuePair{
  def apply(key: String = "", value: String = ""): NewKeyValuePair = new NewKeyValuePair(key = key, value = value)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewKeyValuePair(var key: String = "", var value: String = "") extends NewNode with KeyValuePairBase {
  override def label:String = "KEY_VALUE_PAIR"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (key != null) { res += "KEY" -> key }
  if (value != null) { res += "VALUE" -> value }

  res
}
}

object NewDomNode{
  def apply(name: String = "", attributes: List[DomAttributeBase] = List()): NewDomNode = new NewDomNode(name = name, attributes = attributes)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewDomNode(var name: String = "", var attributes: List[DomAttributeBase] = List()) extends NewNode with DomNodeBase {
  override def label:String = "DOM_NODE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (attributes != null && attributes.nonEmpty) { res += "attributes" -> attributes }
  res
}
}

object NewMethodSummary{
  def apply(isStatic: JBoolean = false, isExternal: JBoolean = false, binarySignature: Option[String] = None, method: MethodBase, parameters: List[MethodParameterInBase] = List(), outParameters: List[MethodParameterOutBase] = List(), returnParameter: MethodReturnBase, paramTypes: List[TypeBase] = List(), returnParameterType: TypeBase, tags: List[TagBase] = List(), paramTags: List[TagsBase] = List(), outParamTags: List[TagsBase] = List(), returnParamTags: List[TagBase] = List(), annotationParameters: List[SpAnnotationParameterBase] = List(), modifiers: List[ModifierBase] = List(), routes: List[RouteBase] = List()): NewMethodSummary = new NewMethodSummary(isStatic = isStatic, isExternal = isExternal, binarySignature = binarySignature, method = method, parameters = parameters, outParameters = outParameters, returnParameter = returnParameter, paramTypes = paramTypes, returnParameterType = returnParameterType, tags = tags, paramTags = paramTags, outParamTags = outParamTags, returnParamTags = returnParamTags, annotationParameters = annotationParameters, modifiers = modifiers, routes = routes)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewMethodSummary(var isStatic: JBoolean = false, var isExternal: JBoolean = false, var binarySignature: Option[String] = None, var method: MethodBase, var parameters: List[MethodParameterInBase] = List(), var outParameters: List[MethodParameterOutBase] = List(), var returnParameter: MethodReturnBase, var paramTypes: List[TypeBase] = List(), var returnParameterType: TypeBase, var tags: List[TagBase] = List(), var paramTags: List[TagsBase] = List(), var outParamTags: List[TagsBase] = List(), var returnParamTags: List[TagBase] = List(), var annotationParameters: List[SpAnnotationParameterBase] = List(), var modifiers: List[ModifierBase] = List(), var routes: List[RouteBase] = List()) extends NewNode with MethodSummaryBase {
  override def label:String = "METHOD_SUMMARY"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (isStatic != null) { res += "IS_STATIC" -> isStatic }
  if (isExternal != null) { res += "IS_EXTERNAL" -> isExternal }
  if (binarySignature != null && binarySignature.isDefined) { res += "BINARY_SIGNATURE" -> binarySignature.get }
  if (method != null) { res += "method" -> method }
  if (parameters != null && parameters.nonEmpty) { res += "parameters" -> parameters }
  if (outParameters != null && outParameters.nonEmpty) { res += "outParameters" -> outParameters }
  if (returnParameter != null) { res += "returnParameter" -> returnParameter }
  if (paramTypes != null && paramTypes.nonEmpty) { res += "paramTypes" -> paramTypes }
  if (returnParameterType != null) { res += "returnParameterType" -> returnParameterType }
  if (tags != null && tags.nonEmpty) { res += "tags" -> tags }
  if (paramTags != null && paramTags.nonEmpty) { res += "paramTags" -> paramTags }
  if (outParamTags != null && outParamTags.nonEmpty) { res += "outParamTags" -> outParamTags }
  if (returnParamTags != null && returnParamTags.nonEmpty) { res += "returnParamTags" -> returnParamTags }
  if (annotationParameters != null && annotationParameters.nonEmpty) { res += "annotationParameters" -> annotationParameters }
  if (modifiers != null && modifiers.nonEmpty) { res += "modifiers" -> modifiers }
  if (routes != null && routes.nonEmpty) { res += "routes" -> routes }
  res
}
}

object NewNamespaceBlock{
  def apply(name: String = "", fullName: String = "", order: Integer = -1, filename: String = ""): NewNamespaceBlock = new NewNamespaceBlock(name = name, fullName = fullName, order = order, filename = filename)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewNamespaceBlock(var name: String = "", var fullName: String = "", var order: Integer = -1, var filename: String = "") extends NewNode with NamespaceBlockBase {
  override def label:String = "NAMESPACE_BLOCK"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (fullName != null) { res += "FULL_NAME" -> fullName }
  if (order != null) { res += "ORDER" -> order }
  if (filename != null) { res += "FILENAME" -> filename }

  res
}
}

object NewArrayInitializer{
  def apply(depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None, code: String = "", order: Integer = -1, argumentIndex: Integer = -1, columnNumber: Option[Integer] = None, lineNumber: Option[Integer] = None): NewArrayInitializer = new NewArrayInitializer(depthFirstOrder = depthFirstOrder, internalFlags = internalFlags, code = code, order = order, argumentIndex = argumentIndex, columnNumber = columnNumber, lineNumber = lineNumber)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewArrayInitializer(var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None, var code: String = "", var order: Integer = -1, var argumentIndex: Integer = -1, var columnNumber: Option[Integer] = None, var lineNumber: Option[Integer] = None) extends NewNode with ArrayInitializerBase {
  override def label:String = "ARRAY_INITIALIZER"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }
  if (code != null) { res += "CODE" -> code }
  if (order != null) { res += "ORDER" -> order }
  if (argumentIndex != null) { res += "ARGUMENT_INDEX" -> argumentIndex }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }

  res
}
}

object NewProgramPoint{
  def apply(elem: TrackingPointBase, method: Option[MethodBase] = None, methodTags: List[TagBase] = List(), paramTags: List[TagBase] = List()): NewProgramPoint = new NewProgramPoint(elem = elem, method = method, methodTags = methodTags, paramTags = paramTags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewProgramPoint(var elem: TrackingPointBase, var method: Option[MethodBase] = None, var methodTags: List[TagBase] = List(), var paramTags: List[TagBase] = List()) extends NewNode with ProgramPointBase {
  override def label:String = "PROGRAM_POINT"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (elem != null) { res += "elem" -> elem }
  if (method != null && method.isDefined) { res += "method" -> method.get }
  if (methodTags != null && methodTags.nonEmpty) { res += "methodTags" -> methodTags }
  if (paramTags != null && paramTags.nonEmpty) { res += "paramTags" -> paramTags }
  res
}
}

object NewAnnotation{
  def apply(code: String = "", name: String = "", fullName: String = "", order: Integer = -1): NewAnnotation = new NewAnnotation(code = code, name = name, fullName = fullName, order = order)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewAnnotation(var code: String = "", var name: String = "", var fullName: String = "", var order: Integer = -1) extends NewNode with AnnotationBase {
  override def label:String = "ANNOTATION"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (name != null) { res += "NAME" -> name }
  if (fullName != null) { res += "FULL_NAME" -> fullName }
  if (order != null) { res += "ORDER" -> order }

  res
}
}

object NewSensitiveMember{
  def apply(name: String = "", names: List[MatchInfoBase] = List()): NewSensitiveMember = new NewSensitiveMember(name = name, names = names)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewSensitiveMember(var name: String = "", var names: List[MatchInfoBase] = List()) extends NewNode with SensitiveMemberBase {
  override def label:String = "SENSITIVE_MEMBER"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (names != null && names.nonEmpty) { res += "names" -> names }
  res
}
}

object NewIdentifier{
  def apply(code: String = "", name: String = "", order: Integer = -1, argumentIndex: Integer = -1, typeFullName: String = "", dynamicTypeHintFullName: List[String] = List(), lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None, depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None): NewIdentifier = new NewIdentifier(code = code, name = name, order = order, argumentIndex = argumentIndex, typeFullName = typeFullName, dynamicTypeHintFullName = dynamicTypeHintFullName, lineNumber = lineNumber, columnNumber = columnNumber, depthFirstOrder = depthFirstOrder, internalFlags = internalFlags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewIdentifier(var code: String = "", var name: String = "", var order: Integer = -1, var argumentIndex: Integer = -1, var typeFullName: String = "", var dynamicTypeHintFullName: List[String] = List(), var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None, var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None) extends NewNode with IdentifierBase {
  override def label:String = "IDENTIFIER"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (name != null) { res += "NAME" -> name }
  if (order != null) { res += "ORDER" -> order }
  if (argumentIndex != null) { res += "ARGUMENT_INDEX" -> argumentIndex }
  if (typeFullName != null) { res += "TYPE_FULL_NAME" -> typeFullName }
  if (dynamicTypeHintFullName != null && dynamicTypeHintFullName.nonEmpty) { res += "DYNAMIC_TYPE_HINT_FULL_NAME" -> dynamicTypeHintFullName }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }

  res
}
}

object NewTransformation{
  def apply(node: TrackingPointBase): NewTransformation = new NewTransformation(node = node)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewTransformation(var node: TrackingPointBase) extends NewNode with TransformationBase {
  override def label:String = "TRANSFORMATION"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (node != null) { res += "node" -> node }
  res
}
}

object NewFile{
  def apply(name: String = "", order: Integer = -1): NewFile = new NewFile(name = name, order = order)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewFile(var name: String = "", var order: Integer = -1) extends NewNode with FileBase {
  override def label:String = "FILE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (order != null) { res += "ORDER" -> order }

  res
}
}

object NewDependency{
  def apply(version: String = "", name: String = "", dependencyGroupId: Option[String] = None): NewDependency = new NewDependency(version = version, name = name, dependencyGroupId = dependencyGroupId)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewDependency(var version: String = "", var name: String = "", var dependencyGroupId: Option[String] = None) extends NewNode with DependencyBase {
  override def label:String = "DEPENDENCY"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (version != null) { res += "VERSION" -> version }
  if (name != null) { res += "NAME" -> name }
  if (dependencyGroupId != null && dependencyGroupId.isDefined) { res += "DEPENDENCY_GROUP_ID" -> dependencyGroupId.get }

  res
}
}

object NewPackagePrefix{
  def apply(value: String = ""): NewPackagePrefix = new NewPackagePrefix(value = value)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewPackagePrefix(var value: String = "") extends NewNode with PackagePrefixBase {
  override def label:String = "PACKAGE_PREFIX"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (value != null) { res += "VALUE" -> value }

  res
}
}

object NewImplicitCall{
  def apply(depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None, code: String = "", name: String = "", signature: String = "", lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None, order: Integer = -1): NewImplicitCall = new NewImplicitCall(depthFirstOrder = depthFirstOrder, internalFlags = internalFlags, code = code, name = name, signature = signature, lineNumber = lineNumber, columnNumber = columnNumber, order = order)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewImplicitCall(var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None, var code: String = "", var name: String = "", var signature: String = "", var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None, var order: Integer = -1) extends NewNode with ImplicitCallBase {
  override def label:String = "IMPLICIT_CALL"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }
  if (code != null) { res += "CODE" -> code }
  if (name != null) { res += "NAME" -> name }
  if (signature != null) { res += "SIGNATURE" -> signature }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (order != null) { res += "ORDER" -> order }

  res
}
}

object NewMatchInfo{
  def apply(pattern: String = "", category: String = ""): NewMatchInfo = new NewMatchInfo(pattern = pattern, category = category)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewMatchInfo(var pattern: String = "", var category: String = "") extends NewNode with MatchInfoBase {
  override def label:String = "MATCH_INFO"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (pattern != null) { res += "PATTERN" -> pattern }
  if (category != null) { res += "CATEGORY" -> category }

  res
}
}

object NewJumpTarget{
  def apply(code: String = "", name: String = "", columnNumber: Option[Integer] = None, lineNumber: Option[Integer] = None, order: Integer = -1, parserTypeName: String = "", argumentIndex: Integer = -1, internalFlags: Option[Integer] = None): NewJumpTarget = new NewJumpTarget(code = code, name = name, columnNumber = columnNumber, lineNumber = lineNumber, order = order, parserTypeName = parserTypeName, argumentIndex = argumentIndex, internalFlags = internalFlags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewJumpTarget(var code: String = "", var name: String = "", var columnNumber: Option[Integer] = None, var lineNumber: Option[Integer] = None, var order: Integer = -1, var parserTypeName: String = "", var argumentIndex: Integer = -1, var internalFlags: Option[Integer] = None) extends NewNode with JumpTargetBase {
  override def label:String = "JUMP_TARGET"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (name != null) { res += "NAME" -> name }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (order != null) { res += "ORDER" -> order }
  if (parserTypeName != null) { res += "PARSER_TYPE_NAME" -> parserTypeName }
  if (argumentIndex != null) { res += "ARGUMENT_INDEX" -> argumentIndex }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }

  res
}
}

object NewFramework{
  def apply(name: String = ""): NewFramework = new NewFramework(name = name)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewFramework(var name: String = "") extends NewNode with FrameworkBase {
  override def label:String = "FRAMEWORK"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }

  res
}
}

object NewModifier{
  def apply(modifierType: String = "", order: Integer = -1): NewModifier = new NewModifier(modifierType = modifierType, order = order)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewModifier(var modifierType: String = "", var order: Integer = -1) extends NewNode with ModifierBase {
  override def label:String = "MODIFIER"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (modifierType != null) { res += "MODIFIER_TYPE" -> modifierType }
  if (order != null) { res += "ORDER" -> order }

  res
}
}

object NewControlStructure{
  def apply(code: String = "", columnNumber: Option[Integer] = None, lineNumber: Option[Integer] = None, order: Integer = -1, parserTypeName: String = "", argumentIndex: Integer = -1, depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None): NewControlStructure = new NewControlStructure(code = code, columnNumber = columnNumber, lineNumber = lineNumber, order = order, parserTypeName = parserTypeName, argumentIndex = argumentIndex, depthFirstOrder = depthFirstOrder, internalFlags = internalFlags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewControlStructure(var code: String = "", var columnNumber: Option[Integer] = None, var lineNumber: Option[Integer] = None, var order: Integer = -1, var parserTypeName: String = "", var argumentIndex: Integer = -1, var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None) extends NewNode with ControlStructureBase {
  override def label:String = "CONTROL_STRUCTURE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (order != null) { res += "ORDER" -> order }
  if (parserTypeName != null) { res += "PARSER_TYPE_NAME" -> parserTypeName }
  if (argumentIndex != null) { res += "ARGUMENT_INDEX" -> argumentIndex }
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }

  res
}
}

object NewBlock{
  def apply(code: String = "", order: Integer = -1, argumentIndex: Integer = -1, typeFullName: String = "", dynamicTypeHintFullName: List[String] = List(), lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None, depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None): NewBlock = new NewBlock(code = code, order = order, argumentIndex = argumentIndex, typeFullName = typeFullName, dynamicTypeHintFullName = dynamicTypeHintFullName, lineNumber = lineNumber, columnNumber = columnNumber, depthFirstOrder = depthFirstOrder, internalFlags = internalFlags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewBlock(var code: String = "", var order: Integer = -1, var argumentIndex: Integer = -1, var typeFullName: String = "", var dynamicTypeHintFullName: List[String] = List(), var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None, var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None) extends NewNode with BlockBase {
  override def label:String = "BLOCK"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (order != null) { res += "ORDER" -> order }
  if (argumentIndex != null) { res += "ARGUMENT_INDEX" -> argumentIndex }
  if (typeFullName != null) { res += "TYPE_FULL_NAME" -> typeFullName }
  if (dynamicTypeHintFullName != null && dynamicTypeHintFullName.nonEmpty) { res += "DYNAMIC_TYPE_HINT_FULL_NAME" -> dynamicTypeHintFullName }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }

  res
}
}

object NewSpBlacklist{
  def apply(tags: List[TagBase] = List()): NewSpBlacklist = new NewSpBlacklist(tags = tags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewSpBlacklist(var tags: List[TagBase] = List()) extends NewNode with SpBlacklistBase {
  override def label:String = "SP_BLACKLIST"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (tags != null && tags.nonEmpty) { res += "tags" -> tags }
  res
}
}

object NewFrameworkData{
  def apply(name: String = "", content: String = ""): NewFrameworkData = new NewFrameworkData(name = name, content = content)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewFrameworkData(var name: String = "", var content: String = "") extends NewNode with FrameworkDataBase {
  override def label:String = "FRAMEWORK_DATA"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (content != null) { res += "CONTENT" -> content }

  res
}
}

object NewLiteral{
  def apply(code: String = "", order: Integer = -1, argumentIndex: Integer = -1, typeFullName: String = "", dynamicTypeHintFullName: List[String] = List(), lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None, depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None): NewLiteral = new NewLiteral(code = code, order = order, argumentIndex = argumentIndex, typeFullName = typeFullName, dynamicTypeHintFullName = dynamicTypeHintFullName, lineNumber = lineNumber, columnNumber = columnNumber, depthFirstOrder = depthFirstOrder, internalFlags = internalFlags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewLiteral(var code: String = "", var order: Integer = -1, var argumentIndex: Integer = -1, var typeFullName: String = "", var dynamicTypeHintFullName: List[String] = List(), var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None, var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None) extends NewNode with LiteralBase {
  override def label:String = "LITERAL"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (order != null) { res += "ORDER" -> order }
  if (argumentIndex != null) { res += "ARGUMENT_INDEX" -> argumentIndex }
  if (typeFullName != null) { res += "TYPE_FULL_NAME" -> typeFullName }
  if (dynamicTypeHintFullName != null && dynamicTypeHintFullName.nonEmpty) { res += "DYNAMIC_TYPE_HINT_FULL_NAME" -> dynamicTypeHintFullName }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }

  res
}
}

object NewRoute{
  def apply(path: String = ""): NewRoute = new NewRoute(path = path)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewRoute(var path: String = "") extends NewNode with RouteBase {
  override def label:String = "ROUTE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (path != null) { res += "PATH" -> path }

  res
}
}

object NewMethodReturn{
  def apply(code: String = "", evaluationStrategy: String = "", typeFullName: String = "", dynamicTypeHintFullName: List[String] = List(), lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None, order: Integer = -1, depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None): NewMethodReturn = new NewMethodReturn(code = code, evaluationStrategy = evaluationStrategy, typeFullName = typeFullName, dynamicTypeHintFullName = dynamicTypeHintFullName, lineNumber = lineNumber, columnNumber = columnNumber, order = order, depthFirstOrder = depthFirstOrder, internalFlags = internalFlags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewMethodReturn(var code: String = "", var evaluationStrategy: String = "", var typeFullName: String = "", var dynamicTypeHintFullName: List[String] = List(), var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None, var order: Integer = -1, var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None) extends NewNode with MethodReturnBase {
  override def label:String = "METHOD_RETURN"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (evaluationStrategy != null) { res += "EVALUATION_STRATEGY" -> evaluationStrategy }
  if (typeFullName != null) { res += "TYPE_FULL_NAME" -> typeFullName }
  if (dynamicTypeHintFullName != null && dynamicTypeHintFullName.nonEmpty) { res += "DYNAMIC_TYPE_HINT_FULL_NAME" -> dynamicTypeHintFullName }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (order != null) { res += "ORDER" -> order }
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }

  res
}
}

object NewMethodParameterOut{
  def apply(code: String = "", order: Integer = -1, name: String = "", evaluationStrategy: String = "", typeFullName: String = "", lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None): NewMethodParameterOut = new NewMethodParameterOut(code = code, order = order, name = name, evaluationStrategy = evaluationStrategy, typeFullName = typeFullName, lineNumber = lineNumber, columnNumber = columnNumber)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewMethodParameterOut(var code: String = "", var order: Integer = -1, var name: String = "", var evaluationStrategy: String = "", var typeFullName: String = "", var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None) extends NewNode with MethodParameterOutBase {
  override def label:String = "METHOD_PARAMETER_OUT"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (order != null) { res += "ORDER" -> order }
  if (name != null) { res += "NAME" -> name }
  if (evaluationStrategy != null) { res += "EVALUATION_STRATEGY" -> evaluationStrategy }
  if (typeFullName != null) { res += "TYPE_FULL_NAME" -> typeFullName }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }

  res
}
}

object NewCallChain{
  def apply(methods: List[MethodBase] = List(), calls: List[CallBase] = List()): NewCallChain = new NewCallChain(methods = methods, calls = calls)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewCallChain(var methods: List[MethodBase] = List(), var calls: List[CallBase] = List()) extends NewNode with CallChainBase {
  override def label:String = "CALL_CHAIN"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (methods != null && methods.nonEmpty) { res += "methods" -> methods }
  if (calls != null && calls.nonEmpty) { res += "calls" -> calls }
  res
}
}

object NewType{
  def apply(name: String = "", fullName: String = "", typeDeclFullName: String = ""): NewType = new NewType(name = name, fullName = fullName, typeDeclFullName = typeDeclFullName)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewType(var name: String = "", var fullName: String = "", var typeDeclFullName: String = "") extends NewNode with TypeBase {
  override def label:String = "TYPE"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (fullName != null) { res += "FULL_NAME" -> fullName }
  if (typeDeclFullName != null) { res += "TYPE_DECL_FULL_NAME" -> typeDeclFullName }

  res
}
}

object NewMethodRef{
  def apply(code: String = "", order: Integer = -1, argumentIndex: Integer = -1, typeFullName: String = "", dynamicTypeHintFullName: List[String] = List(), methodInstFullName: Option[String] = None, methodFullName: String = "", lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None, depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None): NewMethodRef = new NewMethodRef(code = code, order = order, argumentIndex = argumentIndex, typeFullName = typeFullName, dynamicTypeHintFullName = dynamicTypeHintFullName, methodInstFullName = methodInstFullName, methodFullName = methodFullName, lineNumber = lineNumber, columnNumber = columnNumber, depthFirstOrder = depthFirstOrder, internalFlags = internalFlags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewMethodRef(var code: String = "", var order: Integer = -1, var argumentIndex: Integer = -1, var typeFullName: String = "", var dynamicTypeHintFullName: List[String] = List(), var methodInstFullName: Option[String] = None, var methodFullName: String = "", var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None, var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None) extends NewNode with MethodRefBase {
  override def label:String = "METHOD_REF"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (order != null) { res += "ORDER" -> order }
  if (argumentIndex != null) { res += "ARGUMENT_INDEX" -> argumentIndex }
  if (typeFullName != null) { res += "TYPE_FULL_NAME" -> typeFullName }
  if (dynamicTypeHintFullName != null && dynamicTypeHintFullName.nonEmpty) { res += "DYNAMIC_TYPE_HINT_FULL_NAME" -> dynamicTypeHintFullName }
  if (methodInstFullName != null && methodInstFullName.isDefined) { res += "METHOD_INST_FULL_NAME" -> methodInstFullName.get }
  if (methodFullName != null) { res += "METHOD_FULL_NAME" -> methodFullName }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }

  res
}
}

object NewTypeDecl{
  def apply(name: String = "", fullName: String = "", isExternal: JBoolean = false, inheritsFromTypeFullName: List[String] = List(), astParentType: String = "", astParentFullName: String = "", aliasTypeFullName: Option[String] = None, order: Integer = -1, filename: String = ""): NewTypeDecl = new NewTypeDecl(name = name, fullName = fullName, isExternal = isExternal, inheritsFromTypeFullName = inheritsFromTypeFullName, astParentType = astParentType, astParentFullName = astParentFullName, aliasTypeFullName = aliasTypeFullName, order = order, filename = filename)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewTypeDecl(var name: String = "", var fullName: String = "", var isExternal: JBoolean = false, var inheritsFromTypeFullName: List[String] = List(), var astParentType: String = "", var astParentFullName: String = "", var aliasTypeFullName: Option[String] = None, var order: Integer = -1, var filename: String = "") extends NewNode with TypeDeclBase {
  override def label:String = "TYPE_DECL"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (fullName != null) { res += "FULL_NAME" -> fullName }
  if (isExternal != null) { res += "IS_EXTERNAL" -> isExternal }
  if (inheritsFromTypeFullName != null && inheritsFromTypeFullName.nonEmpty) { res += "INHERITS_FROM_TYPE_FULL_NAME" -> inheritsFromTypeFullName }
  if (astParentType != null) { res += "AST_PARENT_TYPE" -> astParentType }
  if (astParentFullName != null) { res += "AST_PARENT_FULL_NAME" -> astParentFullName }
  if (aliasTypeFullName != null && aliasTypeFullName.isDefined) { res += "ALIAS_TYPE_FULL_NAME" -> aliasTypeFullName.get }
  if (order != null) { res += "ORDER" -> order }
  if (filename != null) { res += "FILENAME" -> filename }

  res
}
}

object NewSink{
  def apply(sinkType: String = "", node: TrackingPointBase, nodeType: TypeBase, method: MethodBase, methodTags: List[TagBase] = List(), callingMethod: Option[MethodBase] = None, callsite: Option[CallBase] = None, parameterIn: Option[MethodParameterInBase] = None, parameterInTags: List[TagBase] = List()): NewSink = new NewSink(sinkType = sinkType, node = node, nodeType = nodeType, method = method, methodTags = methodTags, callingMethod = callingMethod, callsite = callsite, parameterIn = parameterIn, parameterInTags = parameterInTags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewSink(var sinkType: String = "", var node: TrackingPointBase, var nodeType: TypeBase, var method: MethodBase, var methodTags: List[TagBase] = List(), var callingMethod: Option[MethodBase] = None, var callsite: Option[CallBase] = None, var parameterIn: Option[MethodParameterInBase] = None, var parameterInTags: List[TagBase] = List()) extends NewNode with SinkBase {
  override def label:String = "SINK"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (sinkType != null) { res += "SINK_TYPE" -> sinkType }
  if (node != null) { res += "node" -> node }
  if (nodeType != null) { res += "nodeType" -> nodeType }
  if (method != null) { res += "method" -> method }
  if (methodTags != null && methodTags.nonEmpty) { res += "methodTags" -> methodTags }
  if (callingMethod != null && callingMethod.isDefined) { res += "callingMethod" -> callingMethod.get }
  if (callsite != null && callsite.isDefined) { res += "callsite" -> callsite.get }
  if (parameterIn != null && parameterIn.isDefined) { res += "parameterIn" -> parameterIn.get }
  if (parameterInTags != null && parameterInTags.nonEmpty) { res += "parameterInTags" -> parameterInTags }
  res
}
}

object NewSpAnnotationParameter{
  def apply(annotationName: String = "", annotationFullName: String = "", name: String = "", value: String = ""): NewSpAnnotationParameter = new NewSpAnnotationParameter(annotationName = annotationName, annotationFullName = annotationFullName, name = name, value = value)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewSpAnnotationParameter(var annotationName: String = "", var annotationFullName: String = "", var name: String = "", var value: String = "") extends NewNode with SpAnnotationParameterBase {
  override def label:String = "SP_ANNOTATION_PARAMETER"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (annotationName != null) { res += "ANNOTATION_NAME" -> annotationName }
  if (annotationFullName != null) { res += "ANNOTATION_FULL_NAME" -> annotationFullName }
  if (name != null) { res += "NAME" -> name }
  if (value != null) { res += "VALUE" -> value }

  res
}
}

object NewFinding{
  def apply(evidence: List[CpgNode] = List(), keyValuePairs: List[KeyValuePairBase] = List()): NewFinding = new NewFinding(evidence = evidence, keyValuePairs = keyValuePairs)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewFinding(var evidence: List[CpgNode] = List(), var keyValuePairs: List[KeyValuePairBase] = List()) extends NewNode with FindingBase {
  override def label:String = "FINDING"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (evidence != null && evidence.nonEmpty) { res += "evidence" -> evidence }
  if (keyValuePairs != null && keyValuePairs.nonEmpty) { res += "keyValuePairs" -> keyValuePairs }
  res
}
}

object NewCall{
  def apply(code: String = "", name: String = "", order: Integer = -1, methodInstFullName: Option[String] = None, methodFullName: String = "", argumentIndex: Integer = -1, dispatchType: String = "", signature: String = "", typeFullName: String = "", dynamicTypeHintFullName: List[String] = List(), lineNumber: Option[Integer] = None, columnNumber: Option[Integer] = None, resolved: Option[JBoolean] = None, depthFirstOrder: Option[Integer] = None, internalFlags: Option[Integer] = None): NewCall = new NewCall(code = code, name = name, order = order, methodInstFullName = methodInstFullName, methodFullName = methodFullName, argumentIndex = argumentIndex, dispatchType = dispatchType, signature = signature, typeFullName = typeFullName, dynamicTypeHintFullName = dynamicTypeHintFullName, lineNumber = lineNumber, columnNumber = columnNumber, resolved = resolved, depthFirstOrder = depthFirstOrder, internalFlags = internalFlags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewCall(var code: String = "", var name: String = "", var order: Integer = -1, var methodInstFullName: Option[String] = None, var methodFullName: String = "", var argumentIndex: Integer = -1, var dispatchType: String = "", var signature: String = "", var typeFullName: String = "", var dynamicTypeHintFullName: List[String] = List(), var lineNumber: Option[Integer] = None, var columnNumber: Option[Integer] = None, var resolved: Option[JBoolean] = None, var depthFirstOrder: Option[Integer] = None, var internalFlags: Option[Integer] = None) extends NewNode with CallBase {
  override def label:String = "CALL"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (name != null) { res += "NAME" -> name }
  if (order != null) { res += "ORDER" -> order }
  if (methodInstFullName != null && methodInstFullName.isDefined) { res += "METHOD_INST_FULL_NAME" -> methodInstFullName.get }
  if (methodFullName != null) { res += "METHOD_FULL_NAME" -> methodFullName }
  if (argumentIndex != null) { res += "ARGUMENT_INDEX" -> argumentIndex }
  if (dispatchType != null) { res += "DISPATCH_TYPE" -> dispatchType }
  if (signature != null) { res += "SIGNATURE" -> signature }
  if (typeFullName != null) { res += "TYPE_FULL_NAME" -> typeFullName }
  if (dynamicTypeHintFullName != null && dynamicTypeHintFullName.nonEmpty) { res += "DYNAMIC_TYPE_HINT_FULL_NAME" -> dynamicTypeHintFullName }
  if (lineNumber != null && lineNumber.isDefined) { res += "LINE_NUMBER" -> lineNumber.get }
  if (columnNumber != null && columnNumber.isDefined) { res += "COLUMN_NUMBER" -> columnNumber.get }
  if (resolved != null && resolved.isDefined) { res += "RESOLVED" -> resolved.get }
  if (depthFirstOrder != null && depthFirstOrder.isDefined) { res += "DEPTH_FIRST_ORDER" -> depthFirstOrder.get }
  if (internalFlags != null && internalFlags.isDefined) { res += "INTERNAL_FLAGS" -> internalFlags.get }

  res
}
}

object NewTypeParameter{
  def apply(name: String = "", order: Integer = -1): NewTypeParameter = new NewTypeParameter(name = name, order = order)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewTypeParameter(var name: String = "", var order: Integer = -1) extends NewNode with TypeParameterBase {
  override def label:String = "TYPE_PARAMETER"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (order != null) { res += "ORDER" -> order }

  res
}
}

object NewTags{
  def apply(tags: List[TagBase] = List()): NewTags = new NewTags(tags = tags)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewTags(var tags: List[TagBase] = List()) extends NewNode with TagsBase {
  override def label:String = "TAGS"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()

  if (tags != null && tags.nonEmpty) { res += "tags" -> tags }
  res
}
}

object NewAnnotationParameterAssign{
  def apply(code: String = "", order: Integer = -1): NewAnnotationParameterAssign = new NewAnnotationParameterAssign(code = code, order = order)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewAnnotationParameterAssign(var code: String = "", var order: Integer = -1) extends NewNode with AnnotationParameterAssignBase {
  override def label:String = "ANNOTATION_PARAMETER_ASSIGN"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (code != null) { res += "CODE" -> code }
  if (order != null) { res += "ORDER" -> order }

  res
}
}

object NewBinding{
  def apply(name: String = "", signature: String = "", isMethodNeverOverridden: Option[JBoolean] = None): NewBinding = new NewBinding(name = name, signature = signature, isMethodNeverOverridden = isMethodNeverOverridden)

}

// fixme: This should never have been a case class. Softly deprecate that.
case class NewBinding(var name: String = "", var signature: String = "", var isMethodNeverOverridden: Option[JBoolean] = None) extends NewNode with BindingBase {
  override def label:String = "BINDING"

  override def properties: Map[String, Any] = {
  var res = Map[String, Any]()
  if (name != null) { res += "NAME" -> name }
  if (signature != null) { res += "SIGNATURE" -> signature }
  if (isMethodNeverOverridden != null && isMethodNeverOverridden.isDefined) { res += "IS_METHOD_NEVER_OVERRIDDEN" -> isMethodNeverOverridden.get }

  res
}
}

