package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object Return {
  def apply(graph: Graph, id: Long) = new Return(graph, id)

  val Label = "RETURN"
  val LabelId: Int = 30

  object PropertyNames {
    val LineNumber = "LINE_NUMBER" 
    val ColumnNumber = "COLUMN_NUMBER" 
    val Order = "ORDER" 
    val ArgumentIndex = "ARGUMENT_INDEX" 
    val Code = "CODE" 
    val DepthFirstOrder = "DEPTH_FIRST_ORDER" 
    val InternalFlags = "INTERNAL_FLAGS" 
    val all: Set[String] = Set(LineNumber, ColumnNumber, Order, ArgumentIndex, Code, DepthFirstOrder, InternalFlags)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val LineNumber = new PropertyKey[Integer]("LINE_NUMBER") 
    val ColumnNumber = new PropertyKey[Integer]("COLUMN_NUMBER") 
    val Order = new PropertyKey[Integer]("ORDER") 
    val ArgumentIndex = new PropertyKey[Integer]("ARGUMENT_INDEX") 
    val Code = new PropertyKey[String]("CODE") 
    val DepthFirstOrder = new PropertyKey[Integer]("DEPTH_FIRST_ORDER") 
    val InternalFlags = new PropertyKey[Integer]("INTERNAL_FLAGS") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Argument.layoutInformation, edges.ReachingDef.layoutInformation, edges.Cfg.layoutInformation, edges.PostDominate.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.Cdg.layoutInformation, edges.Argument.layoutInformation, edges.Contains.layoutInformation, edges.ReachingDef.layoutInformation, edges.Condition.layoutInformation, edges.Cfg.layoutInformation, edges.PostDominate.layoutInformation, edges.Ast.layoutInformation, edges.Dominate.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("CDG","ARGUMENT","CONTAINS","REACHING_DEF","CONDITION","CFG","POST_DOMINATE","AST","DOMINATE","CONTAINS_NODE")
    val Out: Array[String] = Array("ARGUMENT","REACHING_DEF","CFG","POST_DOMINATE","AST","DOMINATE","CONTAINS_NODE")
  }

  val factory = new NodeFactory[ReturnDb] {
    override val forLabel = Return.Label
    override val forLabelId = Return.LabelId

    override def createNode(ref: NodeRef[ReturnDb]) =
      new ReturnDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Return(graph, id)
  }
}

trait ReturnBase extends CpgNode with ExpressionBase with HasLineNumber with HasColumnNumber with HasOrder with HasArgumentIndex with HasCode with HasDepthFirstOrder with HasInternalFlags {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class Return(graph: Graph, id: Long) extends NodeRef[ReturnDb](graph, id)
  with ReturnBase
  with StoredNode
  with Expression {
    override def lineNumber: Option[Integer] = get().lineNumber
  override def columnNumber: Option[Integer] = get().columnNumber
  override def order: Integer = get().order
  override def argumentIndex: Integer = get().argumentIndex
  override def code: String = get().code
  override def depthFirstOrder: Option[Integer] = get().depthFirstOrder
  override def internalFlags: Option[Integer] = get().internalFlags
  
  def _literalViaArgumentOut: Option[Literal] = get()._literalViaArgumentOut
def _typeRefViaArgumentOut: Iterator[TypeRef] = get()._typeRefViaArgumentOut
def _unknownViaArgumentOut: Iterator[Unknown] = get()._unknownViaArgumentOut
def _identifierViaArgumentOut: Option[Identifier] = get()._identifierViaArgumentOut
def _jumpTargetViaArgumentOut: Iterator[JumpTarget] = get()._jumpTargetViaArgumentOut
def _callViaArgumentOut: Option[Call] = get()._callViaArgumentOut
override def _argumentOut(): JIterator[StoredNode] = get()._argumentOut
def _blockViaArgumentOut: Option[Block] = get()._blockViaArgumentOut
def _returnViaArgumentOut: Option[Return] = get()._returnViaArgumentOut
def _methodRefViaArgumentOut: Option[MethodRef] = get()._methodRefViaArgumentOut
def _controlStructureViaArgumentOut: Iterator[ControlStructure] = get()._controlStructureViaArgumentOut
def _identifierViaReachingDefOut: Iterator[Identifier] = get()._identifierViaReachingDefOut
def _methodReturnViaReachingDefOut: Iterator[MethodReturn] = get()._methodReturnViaReachingDefOut
override def _reachingDefOut(): JIterator[StoredNode] = get()._reachingDefOut
def _methodReturnViaCfgOut: MethodReturn = get()._methodReturnViaCfgOut
override def _cfgOut(): JIterator[StoredNode] = get()._cfgOut
def _identifierViaPostDominateOut: Iterator[Identifier] = get()._identifierViaPostDominateOut
def _literalViaPostDominateOut: Iterator[Literal] = get()._literalViaPostDominateOut
override def _postDominateOut(): JIterator[StoredNode] = get()._postDominateOut
def _jumpTargetViaPostDominateOut: Iterator[JumpTarget] = get()._jumpTargetViaPostDominateOut
def _callViaPostDominateOut: Iterator[Call] = get()._callViaPostDominateOut
def _fieldIdentifierViaPostDominateOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaPostDominateOut
def _controlStructureViaPostDominateOut: Iterator[ControlStructure] = get()._controlStructureViaPostDominateOut
def _returnViaPostDominateOut: Iterator[Return] = get()._returnViaPostDominateOut
def _methodViaPostDominateOut: Iterator[Method] = get()._methodViaPostDominateOut
def _unknownViaPostDominateOut: Iterator[Unknown] = get()._unknownViaPostDominateOut
def _methodRefViaPostDominateOut: Iterator[MethodRef] = get()._methodRefViaPostDominateOut
def _blockViaPostDominateOut: Iterator[Block] = get()._blockViaPostDominateOut
def _typeRefViaPostDominateOut: Iterator[TypeRef] = get()._typeRefViaPostDominateOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
def _identifierViaAstOut: Iterator[Identifier] = get()._identifierViaAstOut
def _methodRefViaAstOut: Iterator[MethodRef] = get()._methodRefViaAstOut
def _blockViaAstOut: Iterator[Block] = get()._blockViaAstOut
def _literalViaAstOut: Iterator[Literal] = get()._literalViaAstOut
def _typeRefViaAstOut: Iterator[TypeRef] = get()._typeRefViaAstOut
def _controlStructureViaAstOut: Iterator[ControlStructure] = get()._controlStructureViaAstOut
def _jumpTargetViaAstOut: Iterator[JumpTarget] = get()._jumpTargetViaAstOut
def _unknownViaAstOut: Iterator[Unknown] = get()._unknownViaAstOut
def _returnViaAstOut: Iterator[Return] = get()._returnViaAstOut
def _callViaAstOut: Iterator[Call] = get()._callViaAstOut
def _unknownViaDominateOut: Iterator[Unknown] = get()._unknownViaDominateOut
def _jumpTargetViaDominateOut: Iterator[JumpTarget] = get()._jumpTargetViaDominateOut
def _identifierViaDominateOut: Iterator[Identifier] = get()._identifierViaDominateOut
override def _dominateOut(): JIterator[StoredNode] = get()._dominateOut
def _controlStructureViaDominateOut: Iterator[ControlStructure] = get()._controlStructureViaDominateOut
def _fieldIdentifierViaDominateOut: Iterator[FieldIdentifier] = get()._fieldIdentifierViaDominateOut
def _typeRefViaDominateOut: Iterator[TypeRef] = get()._typeRefViaDominateOut
def _methodRefViaDominateOut: Iterator[MethodRef] = get()._methodRefViaDominateOut
def _methodReturnViaDominateOut: Iterator[MethodReturn] = get()._methodReturnViaDominateOut
def _literalViaDominateOut: Iterator[Literal] = get()._literalViaDominateOut
def _returnViaDominateOut: Iterator[Return] = get()._returnViaDominateOut
def _blockViaDominateOut: Iterator[Block] = get()._blockViaDominateOut
def _callViaDominateOut: Iterator[Call] = get()._callViaDominateOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodRefViaCdgIn: Iterator[MethodRef] = get()._methodRefViaCdgIn
def _callViaCdgIn: Iterator[Call] = get()._callViaCdgIn
def _jumpTargetViaCdgIn: Iterator[JumpTarget] = get()._jumpTargetViaCdgIn
def _unknownViaCdgIn: Iterator[Unknown] = get()._unknownViaCdgIn
def _controlStructureViaCdgIn: Iterator[ControlStructure] = get()._controlStructureViaCdgIn
def _literalViaCdgIn: Iterator[Literal] = get()._literalViaCdgIn
def _typeRefViaCdgIn: Iterator[TypeRef] = get()._typeRefViaCdgIn
def _identifierViaCdgIn: Iterator[Identifier] = get()._identifierViaCdgIn
def _fieldIdentifierViaCdgIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaCdgIn
override def _cdgIn(): JIterator[StoredNode] = get()._cdgIn
def _blockViaCdgIn: Iterator[Block] = get()._blockViaCdgIn
def _returnViaArgumentIn: Option[Return] = get()._returnViaArgumentIn
override def _argumentIn(): JIterator[StoredNode] = get()._argumentIn
def _methodViaContainsIn: Iterator[Method] = get()._methodViaContainsIn
override def _containsIn(): JIterator[StoredNode] = get()._containsIn
def _identifierViaReachingDefIn: Iterator[Identifier] = get()._identifierViaReachingDefIn
def _controlStructureViaReachingDefIn: Iterator[ControlStructure] = get()._controlStructureViaReachingDefIn
def _blockViaReachingDefIn: Iterator[Block] = get()._blockViaReachingDefIn
def _unknownViaReachingDefIn: Iterator[Unknown] = get()._unknownViaReachingDefIn
def _callViaReachingDefIn: Iterator[Call] = get()._callViaReachingDefIn
def _literalViaReachingDefIn: Iterator[Literal] = get()._literalViaReachingDefIn
def _methodParameterInViaReachingDefIn: Iterator[MethodParameterIn] = get()._methodParameterInViaReachingDefIn
override def _reachingDefIn(): JIterator[StoredNode] = get()._reachingDefIn
def _methodViaReachingDefIn: Iterator[Method] = get()._methodViaReachingDefIn
def _controlStructureViaConditionIn: Iterator[ControlStructure] = get()._controlStructureViaConditionIn
override def _conditionIn(): JIterator[StoredNode] = get()._conditionIn
def _callViaCfgIn: Iterator[Call] = get()._callViaCfgIn
def _methodViaCfgIn: Iterator[Method] = get()._methodViaCfgIn
override def _cfgIn(): JIterator[StoredNode] = get()._cfgIn
def _methodRefViaCfgIn: Iterator[MethodRef] = get()._methodRefViaCfgIn
def _typeRefViaCfgIn: Iterator[TypeRef] = get()._typeRefViaCfgIn
def _unknownViaCfgIn: Iterator[Unknown] = get()._unknownViaCfgIn
def _jumpTargetViaCfgIn: Iterator[JumpTarget] = get()._jumpTargetViaCfgIn
def _blockViaCfgIn: Iterator[Block] = get()._blockViaCfgIn
def _controlStructureViaCfgIn: Iterator[ControlStructure] = get()._controlStructureViaCfgIn
def _identifierViaCfgIn: Iterator[Identifier] = get()._identifierViaCfgIn
def _fieldIdentifierViaCfgIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaCfgIn
def _literalViaCfgIn: Iterator[Literal] = get()._literalViaCfgIn
def _typeRefViaPostDominateIn: Iterator[TypeRef] = get()._typeRefViaPostDominateIn
override def _postDominateIn(): JIterator[StoredNode] = get()._postDominateIn
def _fieldIdentifierViaPostDominateIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaPostDominateIn
def _identifierViaPostDominateIn: Iterator[Identifier] = get()._identifierViaPostDominateIn
def _blockViaPostDominateIn: Iterator[Block] = get()._blockViaPostDominateIn
def _returnViaPostDominateIn: Iterator[Return] = get()._returnViaPostDominateIn
def _callViaPostDominateIn: Iterator[Call] = get()._callViaPostDominateIn
def _literalViaPostDominateIn: Iterator[Literal] = get()._literalViaPostDominateIn
def _unknownViaPostDominateIn: Iterator[Unknown] = get()._unknownViaPostDominateIn
def _methodReturnViaPostDominateIn: Iterator[MethodReturn] = get()._methodReturnViaPostDominateIn
def _jumpTargetViaPostDominateIn: Iterator[JumpTarget] = get()._jumpTargetViaPostDominateIn
def _controlStructureViaPostDominateIn: Iterator[ControlStructure] = get()._controlStructureViaPostDominateIn
def _methodRefViaPostDominateIn: Iterator[MethodRef] = get()._methodRefViaPostDominateIn
def _unknownViaAstIn: Iterator[Unknown] = get()._unknownViaAstIn
def _controlStructureViaAstIn: Option[ControlStructure] = get()._controlStructureViaAstIn
def _blockViaAstIn: Iterator[Block] = get()._blockViaAstIn
def _returnViaAstIn: Iterator[Return] = get()._returnViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _callViaAstIn: Iterator[Call] = get()._callViaAstIn
def _literalViaDominateIn: Iterator[Literal] = get()._literalViaDominateIn
def _fieldIdentifierViaDominateIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaDominateIn
def _blockViaDominateIn: Iterator[Block] = get()._blockViaDominateIn
def _identifierViaDominateIn: Iterator[Identifier] = get()._identifierViaDominateIn
override def _dominateIn(): JIterator[StoredNode] = get()._dominateIn
def _controlStructureViaDominateIn: Iterator[ControlStructure] = get()._controlStructureViaDominateIn
def _methodRefViaDominateIn: Iterator[MethodRef] = get()._methodRefViaDominateIn
def _unknownViaDominateIn: Iterator[Unknown] = get()._unknownViaDominateIn
def _callViaDominateIn: Iterator[Call] = get()._callViaDominateIn
def _methodViaDominateIn: Iterator[Method] = get()._methodViaDominateIn
def _typeRefViaDominateIn: Iterator[TypeRef] = get()._typeRefViaDominateIn
def _returnViaDominateIn: Iterator[Return] = get()._returnViaDominateIn
def _jumpTargetViaDominateIn: Iterator[JumpTarget] = get()._jumpTargetViaDominateIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Return.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "lineNumber" 
case 2 => "columnNumber" 
case 3 => "order" 
case 4 => "argumentIndex" 
case 5 => "code" 
case 6 => "depthFirstOrder" 
case 7 => "internalFlags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => lineNumber
case 2 => columnNumber
case 3 => order
case 4 => argumentIndex
case 5 => code
case 6 => depthFirstOrder
case 7 => internalFlags
    }

  override def productPrefix = "Return"
  override def productArity = 8
}

class ReturnDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
  with Expression with ReturnBase {

  override def layoutInformation: NodeLayoutInformation = Return.layoutInformation

private var _lineNumber: Option[Integer] = None
def lineNumber(): Option[Integer] = _lineNumber

private var _columnNumber: Option[Integer] = None
def columnNumber(): Option[Integer] = _columnNumber

private var _order: Integer = null
def order(): Integer = _order

private var _argumentIndex: Integer = null
def argumentIndex(): Integer = _argumentIndex

private var _code: String = null
def code(): String = _code

private var _depthFirstOrder: Option[Integer] = None
def depthFirstOrder(): Option[Integer] = _depthFirstOrder

private var _internalFlags: Option[Integer] = None
def internalFlags(): Option[Integer] = _internalFlags


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
lineNumber.map { value => properties.put("LINE_NUMBER", value) }
columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
if (order != null) { properties.put("ORDER", order) }
if (argumentIndex != null) { properties.put("ARGUMENT_INDEX", argumentIndex) }
if (code != null) { properties.put("CODE", code) }
depthFirstOrder.map { value => properties.put("DEPTH_FIRST_ORDER", value) }
internalFlags.map { value => properties.put("INTERNAL_FLAGS", value) }

  properties
}

  def _jumpTargetViaArgumentOut: Iterator[JumpTarget] = _argumentOut.asScala.collect { case node: JumpTarget => node }
def _blockViaArgumentOut: Option[Block] = _argumentOut.asScala.collect { case node: Block => node }.nextOption
def _controlStructureViaArgumentOut: Iterator[ControlStructure] = _argumentOut.asScala.collect { case node: ControlStructure => node }
def _literalViaArgumentOut: Option[Literal] = _argumentOut.asScala.collect { case node: Literal => node }.nextOption
def _callViaArgumentOut: Option[Call] = _argumentOut.asScala.collect { case node: Call => node }.nextOption
def _identifierViaArgumentOut: Option[Identifier] = _argumentOut.asScala.collect { case node: Identifier => node }.nextOption
def _methodRefViaArgumentOut: Option[MethodRef] = _argumentOut.asScala.collect { case node: MethodRef => node }.nextOption
def _unknownViaArgumentOut: Iterator[Unknown] = _argumentOut.asScala.collect { case node: Unknown => node }
override def _argumentOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _returnViaArgumentOut: Option[Return] = _argumentOut.asScala.collect { case node: Return => node }.nextOption
def _typeRefViaArgumentOut: Iterator[TypeRef] = _argumentOut.asScala.collect { case node: TypeRef => node }
def _identifierViaReachingDefOut: Iterator[Identifier] = _reachingDefOut.asScala.collect { case node: Identifier => node }
def _methodReturnViaReachingDefOut: Iterator[MethodReturn] = _reachingDefOut.asScala.collect { case node: MethodReturn => node }
override def _reachingDefOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _methodReturnViaCfgOut: MethodReturn = _cfgOut.asScala.collect { case node: MethodReturn => node }.next
override def _cfgOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _jumpTargetViaPostDominateOut: Iterator[JumpTarget] = _postDominateOut.asScala.collect { case node: JumpTarget => node }
def _identifierViaPostDominateOut: Iterator[Identifier] = _postDominateOut.asScala.collect { case node: Identifier => node }
def _callViaPostDominateOut: Iterator[Call] = _postDominateOut.asScala.collect { case node: Call => node }
def _methodRefViaPostDominateOut: Iterator[MethodRef] = _postDominateOut.asScala.collect { case node: MethodRef => node }
def _controlStructureViaPostDominateOut: Iterator[ControlStructure] = _postDominateOut.asScala.collect { case node: ControlStructure => node }
def _returnViaPostDominateOut: Iterator[Return] = _postDominateOut.asScala.collect { case node: Return => node }
def _typeRefViaPostDominateOut: Iterator[TypeRef] = _postDominateOut.asScala.collect { case node: TypeRef => node }
override def _postDominateOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _literalViaPostDominateOut: Iterator[Literal] = _postDominateOut.asScala.collect { case node: Literal => node }
def _unknownViaPostDominateOut: Iterator[Unknown] = _postDominateOut.asScala.collect { case node: Unknown => node }
def _fieldIdentifierViaPostDominateOut: Iterator[FieldIdentifier] = _postDominateOut.asScala.collect { case node: FieldIdentifier => node }
def _methodViaPostDominateOut: Iterator[Method] = _postDominateOut.asScala.collect { case node: Method => node }
def _blockViaPostDominateOut: Iterator[Block] = _postDominateOut.asScala.collect { case node: Block => node }
def _methodRefViaAstOut: Iterator[MethodRef] = _astOut.asScala.collect { case node: MethodRef => node }
def _literalViaAstOut: Iterator[Literal] = _astOut.asScala.collect { case node: Literal => node }
def _typeRefViaAstOut: Iterator[TypeRef] = _astOut.asScala.collect { case node: TypeRef => node }
def _blockViaAstOut: Iterator[Block] = _astOut.asScala.collect { case node: Block => node }
def _identifierViaAstOut: Iterator[Identifier] = _astOut.asScala.collect { case node: Identifier => node }
def _controlStructureViaAstOut: Iterator[ControlStructure] = _astOut.asScala.collect { case node: ControlStructure => node }
def _callViaAstOut: Iterator[Call] = _astOut.asScala.collect { case node: Call => node }
def _returnViaAstOut: Iterator[Return] = _astOut.asScala.collect { case node: Return => node }
def _jumpTargetViaAstOut: Iterator[JumpTarget] = _astOut.asScala.collect { case node: JumpTarget => node }
def _unknownViaAstOut: Iterator[Unknown] = _astOut.asScala.collect { case node: Unknown => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
def _literalViaDominateOut: Iterator[Literal] = _dominateOut.asScala.collect { case node: Literal => node }
def _methodReturnViaDominateOut: Iterator[MethodReturn] = _dominateOut.asScala.collect { case node: MethodReturn => node }
def _unknownViaDominateOut: Iterator[Unknown] = _dominateOut.asScala.collect { case node: Unknown => node }
def _controlStructureViaDominateOut: Iterator[ControlStructure] = _dominateOut.asScala.collect { case node: ControlStructure => node }
def _jumpTargetViaDominateOut: Iterator[JumpTarget] = _dominateOut.asScala.collect { case node: JumpTarget => node }
def _methodRefViaDominateOut: Iterator[MethodRef] = _dominateOut.asScala.collect { case node: MethodRef => node }
override def _dominateOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _returnViaDominateOut: Iterator[Return] = _dominateOut.asScala.collect { case node: Return => node }
def _fieldIdentifierViaDominateOut: Iterator[FieldIdentifier] = _dominateOut.asScala.collect { case node: FieldIdentifier => node }
def _typeRefViaDominateOut: Iterator[TypeRef] = _dominateOut.asScala.collect { case node: TypeRef => node }
def _identifierViaDominateOut: Iterator[Identifier] = _dominateOut.asScala.collect { case node: Identifier => node }
def _callViaDominateOut: Iterator[Call] = _dominateOut.asScala.collect { case node: Call => node }
def _blockViaDominateOut: Iterator[Block] = _dominateOut.asScala.collect { case node: Block => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _identifierViaCdgIn: Iterator[Identifier] = _cdgIn.asScala.collect { case node: Identifier => node }
def _literalViaCdgIn: Iterator[Literal] = _cdgIn.asScala.collect { case node: Literal => node }
def _callViaCdgIn: Iterator[Call] = _cdgIn.asScala.collect { case node: Call => node }
def _jumpTargetViaCdgIn: Iterator[JumpTarget] = _cdgIn.asScala.collect { case node: JumpTarget => node }
def _typeRefViaCdgIn: Iterator[TypeRef] = _cdgIn.asScala.collect { case node: TypeRef => node }
def _controlStructureViaCdgIn: Iterator[ControlStructure] = _cdgIn.asScala.collect { case node: ControlStructure => node }
def _blockViaCdgIn: Iterator[Block] = _cdgIn.asScala.collect { case node: Block => node }
override def _cdgIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
def _unknownViaCdgIn: Iterator[Unknown] = _cdgIn.asScala.collect { case node: Unknown => node }
def _methodRefViaCdgIn: Iterator[MethodRef] = _cdgIn.asScala.collect { case node: MethodRef => node }
def _fieldIdentifierViaCdgIn: Iterator[FieldIdentifier] = _cdgIn.asScala.collect { case node: FieldIdentifier => node }
def _returnViaArgumentIn: Option[Return] = _argumentIn.asScala.collect { case node: Return => node }.nextOption
override def _argumentIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
def _methodViaContainsIn: Iterator[Method] = _containsIn.asScala.collect { case node: Method => node }
override def _containsIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
def _unknownViaReachingDefIn: Iterator[Unknown] = _reachingDefIn.asScala.collect { case node: Unknown => node }
override def _reachingDefIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
def _identifierViaReachingDefIn: Iterator[Identifier] = _reachingDefIn.asScala.collect { case node: Identifier => node }
def _methodViaReachingDefIn: Iterator[Method] = _reachingDefIn.asScala.collect { case node: Method => node }
def _controlStructureViaReachingDefIn: Iterator[ControlStructure] = _reachingDefIn.asScala.collect { case node: ControlStructure => node }
def _methodParameterInViaReachingDefIn: Iterator[MethodParameterIn] = _reachingDefIn.asScala.collect { case node: MethodParameterIn => node }
def _callViaReachingDefIn: Iterator[Call] = _reachingDefIn.asScala.collect { case node: Call => node }
def _literalViaReachingDefIn: Iterator[Literal] = _reachingDefIn.asScala.collect { case node: Literal => node }
def _blockViaReachingDefIn: Iterator[Block] = _reachingDefIn.asScala.collect { case node: Block => node }
def _controlStructureViaConditionIn: Iterator[ControlStructure] = _conditionIn.asScala.collect { case node: ControlStructure => node }
override def _conditionIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
override def _cfgIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
def _methodViaCfgIn: Iterator[Method] = _cfgIn.asScala.collect { case node: Method => node }
def _controlStructureViaCfgIn: Iterator[ControlStructure] = _cfgIn.asScala.collect { case node: ControlStructure => node }
def _fieldIdentifierViaCfgIn: Iterator[FieldIdentifier] = _cfgIn.asScala.collect { case node: FieldIdentifier => node }
def _callViaCfgIn: Iterator[Call] = _cfgIn.asScala.collect { case node: Call => node }
def _unknownViaCfgIn: Iterator[Unknown] = _cfgIn.asScala.collect { case node: Unknown => node }
def _methodRefViaCfgIn: Iterator[MethodRef] = _cfgIn.asScala.collect { case node: MethodRef => node }
def _typeRefViaCfgIn: Iterator[TypeRef] = _cfgIn.asScala.collect { case node: TypeRef => node }
def _literalViaCfgIn: Iterator[Literal] = _cfgIn.asScala.collect { case node: Literal => node }
def _jumpTargetViaCfgIn: Iterator[JumpTarget] = _cfgIn.asScala.collect { case node: JumpTarget => node }
def _identifierViaCfgIn: Iterator[Identifier] = _cfgIn.asScala.collect { case node: Identifier => node }
def _blockViaCfgIn: Iterator[Block] = _cfgIn.asScala.collect { case node: Block => node }
def _blockViaPostDominateIn: Iterator[Block] = _postDominateIn.asScala.collect { case node: Block => node }
def _controlStructureViaPostDominateIn: Iterator[ControlStructure] = _postDominateIn.asScala.collect { case node: ControlStructure => node }
def _callViaPostDominateIn: Iterator[Call] = _postDominateIn.asScala.collect { case node: Call => node }
def _unknownViaPostDominateIn: Iterator[Unknown] = _postDominateIn.asScala.collect { case node: Unknown => node }
def _fieldIdentifierViaPostDominateIn: Iterator[FieldIdentifier] = _postDominateIn.asScala.collect { case node: FieldIdentifier => node }
def _identifierViaPostDominateIn: Iterator[Identifier] = _postDominateIn.asScala.collect { case node: Identifier => node }
def _literalViaPostDominateIn: Iterator[Literal] = _postDominateIn.asScala.collect { case node: Literal => node }
override def _postDominateIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
def _returnViaPostDominateIn: Iterator[Return] = _postDominateIn.asScala.collect { case node: Return => node }
def _methodRefViaPostDominateIn: Iterator[MethodRef] = _postDominateIn.asScala.collect { case node: MethodRef => node }
def _methodReturnViaPostDominateIn: Iterator[MethodReturn] = _postDominateIn.asScala.collect { case node: MethodReturn => node }
def _typeRefViaPostDominateIn: Iterator[TypeRef] = _postDominateIn.asScala.collect { case node: TypeRef => node }
def _jumpTargetViaPostDominateIn: Iterator[JumpTarget] = _postDominateIn.asScala.collect { case node: JumpTarget => node }
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]
def _returnViaAstIn: Iterator[Return] = _astIn.asScala.collect { case node: Return => node }
def _blockViaAstIn: Iterator[Block] = _astIn.asScala.collect { case node: Block => node }
def _callViaAstIn: Iterator[Call] = _astIn.asScala.collect { case node: Call => node }
def _unknownViaAstIn: Iterator[Unknown] = _astIn.asScala.collect { case node: Unknown => node }
def _controlStructureViaAstIn: Option[ControlStructure] = _astIn.asScala.collect { case node: ControlStructure => node }.nextOption
def _typeRefViaDominateIn: Iterator[TypeRef] = _dominateIn.asScala.collect { case node: TypeRef => node }
def _unknownViaDominateIn: Iterator[Unknown] = _dominateIn.asScala.collect { case node: Unknown => node }
def _jumpTargetViaDominateIn: Iterator[JumpTarget] = _dominateIn.asScala.collect { case node: JumpTarget => node }
def _methodRefViaDominateIn: Iterator[MethodRef] = _dominateIn.asScala.collect { case node: MethodRef => node }
def _fieldIdentifierViaDominateIn: Iterator[FieldIdentifier] = _dominateIn.asScala.collect { case node: FieldIdentifier => node }
def _methodViaDominateIn: Iterator[Method] = _dominateIn.asScala.collect { case node: Method => node }
override def _dominateIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(15).asInstanceOf[JIterator[StoredNode]]
def _returnViaDominateIn: Iterator[Return] = _dominateIn.asScala.collect { case node: Return => node }
def _identifierViaDominateIn: Iterator[Identifier] = _dominateIn.asScala.collect { case node: Identifier => node }
def _blockViaDominateIn: Iterator[Block] = _dominateIn.asScala.collect { case node: Block => node }
def _callViaDominateIn: Iterator[Call] = _dominateIn.asScala.collect { case node: Call => node }
def _controlStructureViaDominateIn: Iterator[ControlStructure] = _dominateIn.asScala.collect { case node: ControlStructure => node }
def _literalViaDominateIn: Iterator[Literal] = _dominateIn.asScala.collect { case node: Literal => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(16).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Return.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "lineNumber" 
case 2 => "columnNumber" 
case 3 => "order" 
case 4 => "argumentIndex" 
case 5 => "code" 
case 6 => "depthFirstOrder" 
case 7 => "internalFlags" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => lineNumber
case 2 => columnNumber
case 3 => order
case 4 => argumentIndex
case 5 => code
case 6 => depthFirstOrder
case 7 => internalFlags
    }

  override def productPrefix = "Return"
  override def productArity = 8

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ReturnDb]

  override def property(key:String): AnyRef = {
    key match {
      case "LINE_NUMBER" => this._lineNumber.orNull
      case "COLUMN_NUMBER" => this._columnNumber.orNull
      case "ORDER" => this._order
      case "ARGUMENT_INDEX" => this._argumentIndex
      case "CODE" => this._code
      case "DEPTH_FIRST_ORDER" => this._depthFirstOrder.orNull
      case "INTERNAL_FLAGS" => this._internalFlags.orNull
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "LINE_NUMBER" => this._lineNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "COLUMN_NUMBER" => this._columnNumber = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "ORDER" => this._order = value.asInstanceOf[Integer]
      case "ARGUMENT_INDEX" => this._argumentIndex = value.asInstanceOf[Integer]
      case "CODE" => this._code = value.asInstanceOf[String]
      case "DEPTH_FIRST_ORDER" => this._depthFirstOrder = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
      case "INTERNAL_FLAGS" => this._internalFlags = value match {
        case null | None => None
        case someVal: Integer => Some(someVal)
      }
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewReturn]
   this._lineNumber = other.lineNumber
   this._columnNumber = other.columnNumber
   this._order = other.order
   this._argumentIndex = other.argumentIndex
   this._code = other.code
   this._depthFirstOrder = other.depthFirstOrder
   this._internalFlags = other.internalFlags


}

}

/** Traversal steps for Return */
class ReturnTraversal[NodeType <: Return](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to lineNumber property */
  def lineNumber: Traversal[Integer] =
    traversal.flatMap(_.lineNumber)

    /**
    * Traverse to nodes where the lineNumber equals the given `value`
    * */
  def lineNumber(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER, value)

  /**
    * Traverse to nodes where the lineNumber equals at least one of the given `values`
    * */
  def lineNumber(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the lineNumber is greater than the given `value`
    * */
  def lineNumberGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ > value))

  /**
    * Traverse to nodes where the lineNumber is greater than or equal the given `value`
    * */
  def lineNumberGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ >= value))

  /**
    * Traverse to nodes where the lineNumber is less than the given `value`
    * */
  def lineNumberLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ < value))

  /**
    * Traverse to nodes where the lineNumber is less than or equal the given `value`
    * */
  def lineNumberLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.LINE_NUMBER.where(_ <= value))

  /**
    * Traverse to nodes where lineNumber is not equal to the given `value`.
    * */
  def lineNumberNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LINE_NUMBER, value)

  /**
    * Traverse to nodes where lineNumber is not equal to any of the given `values`.
    * */
  def lineNumberNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.LINE_NUMBER.where(P.within(values.toSet)))


  /** Traverse to columnNumber property */
  def columnNumber: Traversal[Integer] =
    traversal.flatMap(_.columnNumber)

    /**
    * Traverse to nodes where the columnNumber equals the given `value`
    * */
  def columnNumber(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER, value)

  /**
    * Traverse to nodes where the columnNumber equals at least one of the given `values`
    * */
  def columnNumber(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the columnNumber is greater than the given `value`
    * */
  def columnNumberGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ > value))

  /**
    * Traverse to nodes where the columnNumber is greater than or equal the given `value`
    * */
  def columnNumberGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ >= value))

  /**
    * Traverse to nodes where the columnNumber is less than the given `value`
    * */
  def columnNumberLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ < value))

  /**
    * Traverse to nodes where the columnNumber is less than or equal the given `value`
    * */
  def columnNumberLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.COLUMN_NUMBER.where(_ <= value))

  /**
    * Traverse to nodes where columnNumber is not equal to the given `value`.
    * */
  def columnNumberNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.COLUMN_NUMBER, value)

  /**
    * Traverse to nodes where columnNumber is not equal to any of the given `values`.
    * */
  def columnNumberNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.COLUMN_NUMBER.where(P.within(values.toSet)))


  /** Traverse to order property */
  def order: Traversal[Integer] =
    traversal.map(_.order)

    /**
    * Traverse to nodes where the order equals the given `value`
    * */
  def order(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where the order equals at least one of the given `values`
    * */
  def order(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the order is greater than the given `value`
    * */
  def orderGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ > value))

  /**
    * Traverse to nodes where the order is greater than or equal the given `value`
    * */
  def orderGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ >= value))

  /**
    * Traverse to nodes where the order is less than the given `value`
    * */
  def orderLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ < value))

  /**
    * Traverse to nodes where the order is less than or equal the given `value`
    * */
  def orderLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ <= value))

  /**
    * Traverse to nodes where order is not equal to the given `value`.
    * */
  def orderNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where order is not equal to any of the given `values`.
    * */
  def orderNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER.where(P.within(values.toSet)))


  /** Traverse to argumentIndex property */
  def argumentIndex: Traversal[Integer] =
    traversal.map(_.argumentIndex)

    /**
    * Traverse to nodes where the argumentIndex equals the given `value`
    * */
  def argumentIndex(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX, value)

  /**
    * Traverse to nodes where the argumentIndex equals at least one of the given `values`
    * */
  def argumentIndex(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the argumentIndex is greater than the given `value`
    * */
  def argumentIndexGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(_ > value))

  /**
    * Traverse to nodes where the argumentIndex is greater than or equal the given `value`
    * */
  def argumentIndexGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(_ >= value))

  /**
    * Traverse to nodes where the argumentIndex is less than the given `value`
    * */
  def argumentIndexLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(_ < value))

  /**
    * Traverse to nodes where the argumentIndex is less than or equal the given `value`
    * */
  def argumentIndexLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ARGUMENT_INDEX.where(_ <= value))

  /**
    * Traverse to nodes where argumentIndex is not equal to the given `value`.
    * */
  def argumentIndexNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ARGUMENT_INDEX, value)

  /**
    * Traverse to nodes where argumentIndex is not equal to any of the given `values`.
    * */
  def argumentIndexNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ARGUMENT_INDEX.where(P.within(values.toSet)))


  /** Traverse to code property */
  def code: Traversal[String] =
    traversal.map(_.code)

    /**
    * Traverse to nodes where the code matches the regular expression `value`
    * */
  def code(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the code matches at least one of the regular expressions in `values`
    * */
  def code(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where code matches `value` exactly.
    * */
  def codeExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE, value)

  /**
    * Traverse to nodes where code matches one of the elements in `values` exactly.
    * */
  def codeExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.CODE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where code does not match the regular expression `value`.
    * */
  def codeNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.matches(regex)))

  /**
    * Traverse to nodes where code does not match any of the regular expressions in `values`.
    * */
  def codeNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.CODE.where(P.within(values.to(Set))))



  /** Traverse to depthFirstOrder property */
  def depthFirstOrder: Traversal[Integer] =
    traversal.flatMap(_.depthFirstOrder)

    /**
    * Traverse to nodes where the depthFirstOrder equals the given `value`
    * */
  def depthFirstOrder(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.DEPTH_FIRST_ORDER, value)

  /**
    * Traverse to nodes where the depthFirstOrder equals at least one of the given `values`
    * */
  def depthFirstOrder(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.DEPTH_FIRST_ORDER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the depthFirstOrder is greater than the given `value`
    * */
  def depthFirstOrderGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.DEPTH_FIRST_ORDER.where(_ > value))

  /**
    * Traverse to nodes where the depthFirstOrder is greater than or equal the given `value`
    * */
  def depthFirstOrderGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.DEPTH_FIRST_ORDER.where(_ >= value))

  /**
    * Traverse to nodes where the depthFirstOrder is less than the given `value`
    * */
  def depthFirstOrderLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.DEPTH_FIRST_ORDER.where(_ < value))

  /**
    * Traverse to nodes where the depthFirstOrder is less than or equal the given `value`
    * */
  def depthFirstOrderLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.DEPTH_FIRST_ORDER.where(_ <= value))

  /**
    * Traverse to nodes where depthFirstOrder is not equal to the given `value`.
    * */
  def depthFirstOrderNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.DEPTH_FIRST_ORDER, value)

  /**
    * Traverse to nodes where depthFirstOrder is not equal to any of the given `values`.
    * */
  def depthFirstOrderNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.DEPTH_FIRST_ORDER.where(P.within(values.toSet)))


  /** Traverse to internalFlags property */
  def internalFlags: Traversal[Integer] =
    traversal.flatMap(_.internalFlags)

    /**
    * Traverse to nodes where the internalFlags equals the given `value`
    * */
  def internalFlags(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS, value)

  /**
    * Traverse to nodes where the internalFlags equals at least one of the given `values`
    * */
  def internalFlags(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the internalFlags is greater than the given `value`
    * */
  def internalFlagsGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(_ > value))

  /**
    * Traverse to nodes where the internalFlags is greater than or equal the given `value`
    * */
  def internalFlagsGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(_ >= value))

  /**
    * Traverse to nodes where the internalFlags is less than the given `value`
    * */
  def internalFlagsLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(_ < value))

  /**
    * Traverse to nodes where the internalFlags is less than or equal the given `value`
    * */
  def internalFlagsLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.INTERNAL_FLAGS.where(_ <= value))

  /**
    * Traverse to nodes where internalFlags is not equal to the given `value`.
    * */
  def internalFlagsNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.INTERNAL_FLAGS, value)

  /**
    * Traverse to nodes where internalFlags is not equal to any of the given `values`.
    * */
  def internalFlagsNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.INTERNAL_FLAGS.where(P.within(values.toSet)))



}
