package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object SensitiveReference {
  def apply(graph: Graph, id: Long) = new SensitiveReference(graph, id)

  val Label = "SENSITIVE_REFERENCE"
  val LabelId: Int = 55

  object PropertyNames {
    val Ioflows = "ioflows" 
    val all: Set[String] = Set(Ioflows)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    
    val Ioflows = new PropertyKey[Seq[Ioflow]]("ioflows") 
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF_REF","CONTAINS_NODE")
    val Out: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF_REF","CONTAINS_NODE")
  }

  val factory = new NodeFactory[SensitiveReferenceDb] {
    override val forLabel = SensitiveReference.Label
    override val forLabelId = SensitiveReference.LabelId

    override def createNode(ref: NodeRef[SensitiveReferenceDb]) =
      new SensitiveReferenceDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = SensitiveReference(graph, id)
  }
}

trait SensitiveReferenceBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def ioflows: List[IoflowBase]
}

class SensitiveReference(graph: Graph, id: Long) extends NodeRef[SensitiveReferenceDb](graph, id)
  with SensitiveReferenceBase
  with StoredNode
   {
  
    def ioflows = get().ioflows
  def _localViaIsSensitiveDataDescrOfRefOut: Iterator[Local] = get()._localViaIsSensitiveDataDescrOfRefOut
def _identifierViaIsSensitiveDataDescrOfRefOut: Iterator[Identifier] = get()._identifierViaIsSensitiveDataDescrOfRefOut
def _methodParameterInViaIsSensitiveDataDescrOfRefOut: Iterator[MethodParameterIn] = get()._methodParameterInViaIsSensitiveDataDescrOfRefOut
override def _isSensitiveDataDescrOfRefOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefOut
def _ioflowViaContainsNodeOut: Iterator[Ioflow] = get()._ioflowViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sensitiveVariableViaIsSensitiveDataDescrOfRefIn: Iterator[SensitiveVariable] = get()._sensitiveVariableViaIsSensitiveDataDescrOfRefIn
override def _isSensitiveDataDescrOfRefIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SensitiveReference.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "ioflows" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => ioflows
    }

  override def productPrefix = "SensitiveReference"
  override def productArity = 2
}

class SensitiveReferenceDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with SensitiveReferenceBase {

  override def layoutInformation: NodeLayoutInformation = SensitiveReference.layoutInformation



private var _ioflows: List[Ioflow] = Nil
def ioflows: List[Ioflow] = this._ioflows


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

  if (this._ioflows.nonEmpty) { properties.put("ioflows", this._ioflows.asJava) }
  properties
}

  def _localViaIsSensitiveDataDescrOfRefOut: Iterator[Local] = _isSensitiveDataDescrOfRefOut.asScala.collect { case node: Local => node }
def _identifierViaIsSensitiveDataDescrOfRefOut: Iterator[Identifier] = _isSensitiveDataDescrOfRefOut.asScala.collect { case node: Identifier => node }
def _methodParameterInViaIsSensitiveDataDescrOfRefOut: Iterator[MethodParameterIn] = _isSensitiveDataDescrOfRefOut.asScala.collect { case node: MethodParameterIn => node }
override def _isSensitiveDataDescrOfRefOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _ioflowViaContainsNodeOut: Iterator[Ioflow] = _containsNodeOut.asScala.collect { case node: Ioflow => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _sensitiveVariableViaIsSensitiveDataDescrOfRefIn: Iterator[SensitiveVariable] = _isSensitiveDataDescrOfRefIn.asScala.collect { case node: SensitiveVariable => node }
override def _isSensitiveDataDescrOfRefIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    SensitiveReference.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "ioflows" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => ioflows
    }

  override def productPrefix = "SensitiveReference"
  override def productArity = 2

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SensitiveReferenceDb]

  override def property(key:String): AnyRef = {
    key match {
      
      case "ioflows" => this._ioflows
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
    
      case "ioflows" => this._ioflows = value match {
        case singleValue: Ioflow => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[Ioflow]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[Ioflow]]
      }
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewSensitiveReference]

  this._ioflows = if(other.ioflows == null) Nil else other.ioflows.map { nodeRef => nodeRef match {
    case null => throw new NullPointerException("Nullpointers forbidden in contained nodes")
    case newNode:NewNode => mapping(newNode).asInstanceOf[Ioflow]
    case oldNode:StoredNode => oldNode.asInstanceOf[Ioflow]
    case _ => throw new MatchError("unreachable")
  }}

}

}

/** Traversal steps for SensitiveReference */
class SensitiveReferenceTraversal[NodeType <: SensitiveReference](val traversal: Traversal[NodeType]) extends AnyVal {



}
