package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object SensitiveVariable {
  def apply(graph: Graph, id: Long) = new SensitiveVariable(graph, id)

  val Label = "SENSITIVE_VARIABLE"
  val LabelId: Int = 54

  object PropertyNames {
    val Name = "NAME" 
    val EvalType = "EVAL_TYPE" 
    val Categories = "CATEGORIES" 
    val Node = "node" 
    val all: Set[String] = Set(Name, EvalType, Categories, Node)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Name = new PropertyKey[String]("NAME") 
    val EvalType = new PropertyKey[String]("EVAL_TYPE") 
    val Categories = new PropertyKey[Seq[String]]("CATEGORIES") 
    val Node = new PropertyKey[LocalLike]("node") 
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.IsSensitiveDataDescrOfRef.layoutInformation, edges.IsSensitiveDataDescrOf.layoutInformation, edges.IsSensitiveDataOfType.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List().asJava)

  object Edges {
    val In: Array[String] = Array()
    val Out: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF_REF","IS_SENSITIVE_DATA_DESCR_OF","IS_SENSITIVE_DATA_OF_TYPE","CONTAINS_NODE")
  }

  val factory = new NodeFactory[SensitiveVariableDb] {
    override val forLabel = SensitiveVariable.Label
    override val forLabelId = SensitiveVariable.LabelId

    override def createNode(ref: NodeRef[SensitiveVariableDb]) =
      new SensitiveVariableDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = SensitiveVariable(graph, id)
  }
}

trait SensitiveVariableBase extends CpgNode  with HasName with HasEvalType with HasCategories {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def node: LocalLikeBase
}

class SensitiveVariable(graph: Graph, id: Long) extends NodeRef[SensitiveVariableDb](graph, id)
  with SensitiveVariableBase
  with StoredNode
   {
    override def name: String = get().name
  override def evalType: String = get().evalType
  override def categories: List[String] = get().categories
    def node = get().node
  def _sensitiveReferenceViaIsSensitiveDataDescrOfRefOut: Iterator[SensitiveReference] = get()._sensitiveReferenceViaIsSensitiveDataDescrOfRefOut
override def _isSensitiveDataDescrOfRefOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfRefOut
def _localViaIsSensitiveDataDescrOfOut: Iterator[Local] = get()._localViaIsSensitiveDataDescrOfOut
def _identifierViaIsSensitiveDataDescrOfOut: Iterator[Identifier] = get()._identifierViaIsSensitiveDataDescrOfOut
def _methodParameterInViaIsSensitiveDataDescrOfOut: Iterator[MethodParameterIn] = get()._methodParameterInViaIsSensitiveDataDescrOfOut
override def _isSensitiveDataDescrOfOut(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfOut
def _sensitiveDataTypeViaIsSensitiveDataOfTypeOut: Iterator[SensitiveDataType] = get()._sensitiveDataTypeViaIsSensitiveDataOfTypeOut
override def _isSensitiveDataOfTypeOut(): JIterator[StoredNode] = get()._isSensitiveDataOfTypeOut
def _localLikeViaContainsNodeOut: Iterator[LocalLike] = get()._localLikeViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SensitiveVariable.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "evalType" 
case 3 => "categories" 
case 4 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => evalType
case 3 => categories
case 4 => node
    }

  override def productPrefix = "SensitiveVariable"
  override def productArity = 5
}

class SensitiveVariableDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with SensitiveVariableBase {

  override def layoutInformation: NodeLayoutInformation = SensitiveVariable.layoutInformation

private var _name: String = null
def name(): String = _name

private var _evalType: String = null
def evalType(): String = _evalType

private var _categories: List[String] = Nil
def categories(): List[String] = _categories

private var _node: LocalLike = null
def node: LocalLike = this._node


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (name != null) { properties.put("NAME", name) }
if (evalType != null) { properties.put("EVAL_TYPE", evalType) }
if (categories.nonEmpty) { properties.put("CATEGORIES", categories.asJava) }
   if (this._node != null) { properties.put("node", this._node) }
  properties
}

  def _sensitiveReferenceViaIsSensitiveDataDescrOfRefOut: Iterator[SensitiveReference] = _isSensitiveDataDescrOfRefOut.asScala.collect { case node: SensitiveReference => node }
override def _isSensitiveDataDescrOfRefOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _localViaIsSensitiveDataDescrOfOut: Iterator[Local] = _isSensitiveDataDescrOfOut.asScala.collect { case node: Local => node }
def _identifierViaIsSensitiveDataDescrOfOut: Iterator[Identifier] = _isSensitiveDataDescrOfOut.asScala.collect { case node: Identifier => node }
def _methodParameterInViaIsSensitiveDataDescrOfOut: Iterator[MethodParameterIn] = _isSensitiveDataDescrOfOut.asScala.collect { case node: MethodParameterIn => node }
override def _isSensitiveDataDescrOfOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _sensitiveDataTypeViaIsSensitiveDataOfTypeOut: Iterator[SensitiveDataType] = _isSensitiveDataOfTypeOut.asScala.collect { case node: SensitiveDataType => node }
override def _isSensitiveDataOfTypeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _localLikeViaContainsNodeOut: Iterator[LocalLike] = _containsNodeOut.asScala.collect { case node: LocalLike => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    SensitiveVariable.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "evalType" 
case 3 => "categories" 
case 4 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => evalType
case 3 => categories
case 4 => node
    }

  override def productPrefix = "SensitiveVariable"
  override def productArity = 5

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SensitiveVariableDb]

  override def property(key:String): AnyRef = {
    key match {
      case "NAME" => this._name
      case "EVAL_TYPE" => this._evalType
      case "CATEGORIES" => this._categories
      case "node" => this._node
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "NAME" => this._name = value.asInstanceOf[String]
      case "EVAL_TYPE" => this._evalType = value.asInstanceOf[String]
      case "CATEGORIES" => this._categories = value match {
        case singleValue: String => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[String]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[String]]
      }
      case "node" => this._node = value.asInstanceOf[LocalLike]
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewSensitiveVariable]
   this._name = other.name
   this._evalType = other.evalType
   this._categories = other.categories
  this._node = other.node match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[LocalLike]
    case oldNode: StoredNode => oldNode.asInstanceOf[LocalLike]
    case _ => throw new MatchError("unreachable")
  }

}

}

/** Traversal steps for SensitiveVariable */
class SensitiveVariableTraversal[NodeType <: SensitiveVariable](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to name property */
  def name: Traversal[String] =
    traversal.map(_.name)

    /**
    * Traverse to nodes where the name matches the regular expression `value`
    * */
  def name(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the name matches at least one of the regular expressions in `values`
    * */
  def name(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where name matches `value` exactly.
    * */
  def nameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME, value)

  /**
    * Traverse to nodes where name matches one of the elements in `values` exactly.
    * */
  def nameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where name does not match the regular expression `value`.
    * */
  def nameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where name does not match any of the regular expressions in `values`.
    * */
  def nameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.within(values.to(Set))))



  /** Traverse to evalType property */
  def evalType: Traversal[String] =
    traversal.map(_.evalType)

    /**
    * Traverse to nodes where the evalType matches the regular expression `value`
    * */
  def evalType(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.EVAL_TYPE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the evalType matches at least one of the regular expressions in `values`
    * */
  def evalType(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.EVAL_TYPE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where evalType matches `value` exactly.
    * */
  def evalTypeExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.EVAL_TYPE, value)

  /**
    * Traverse to nodes where evalType matches one of the elements in `values` exactly.
    * */
  def evalTypeExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.EVAL_TYPE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where evalType does not match the regular expression `value`.
    * */
  def evalTypeNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.EVAL_TYPE.where(P.matches(regex)))

  /**
    * Traverse to nodes where evalType does not match any of the regular expressions in `values`.
    * */
  def evalTypeNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.EVAL_TYPE.where(P.within(values.to(Set))))



  /** Traverse to categories property */
  def categories: Traversal[String] =
    traversal.flatMap(_.categories)

  


}
