package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object SpAnnotationParameter {
  def apply(graph: Graph, id: Long) = new SpAnnotationParameter(graph, id)

  val Label = "SP_ANNOTATION_PARAMETER"
  val LabelId: Int = 200

  object PropertyNames {
    val AnnotationName = "ANNOTATION_NAME" 
    val AnnotationFullName = "ANNOTATION_FULL_NAME" 
    val Name = "NAME" 
    val Value = "VALUE" 
    val all: Set[String] = Set(AnnotationName, AnnotationFullName, Name, Value)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val AnnotationName = new PropertyKey[String]("ANNOTATION_NAME") 
    val AnnotationFullName = new PropertyKey[String]("ANNOTATION_FULL_NAME") 
    val Name = new PropertyKey[String]("NAME") 
    val Value = new PropertyKey[String]("VALUE") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[SpAnnotationParameterDb] {
    override val forLabel = SpAnnotationParameter.Label
    override val forLabelId = SpAnnotationParameter.LabelId

    override def createNode(ref: NodeRef[SpAnnotationParameterDb]) =
      new SpAnnotationParameterDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = SpAnnotationParameter(graph, id)
  }
}

trait SpAnnotationParameterBase extends CpgNode  with HasAnnotationName with HasAnnotationFullName with HasName with HasValue {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class SpAnnotationParameter(graph: Graph, id: Long) extends NodeRef[SpAnnotationParameterDb](graph, id)
  with SpAnnotationParameterBase
  with StoredNode
   {
    override def annotationName: String = get().annotationName
  override def annotationFullName: String = get().annotationFullName
  override def name: String = get().name
  override def value: String = get().value
  
  override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = get()._methodSummaryViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    SpAnnotationParameter.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "annotationName" 
case 2 => "annotationFullName" 
case 3 => "name" 
case 4 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => annotationName
case 2 => annotationFullName
case 3 => name
case 4 => value
    }

  override def productPrefix = "SpAnnotationParameter"
  override def productArity = 5
}

class SpAnnotationParameterDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with SpAnnotationParameterBase {

  override def layoutInformation: NodeLayoutInformation = SpAnnotationParameter.layoutInformation

private var _annotationName: String = null
def annotationName(): String = _annotationName

private var _annotationFullName: String = null
def annotationFullName(): String = _annotationFullName

private var _name: String = null
def name(): String = _name

private var _value: String = null
def value(): String = _value


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (annotationName != null) { properties.put("ANNOTATION_NAME", annotationName) }
if (annotationFullName != null) { properties.put("ANNOTATION_FULL_NAME", annotationFullName) }
if (name != null) { properties.put("NAME", name) }
if (value != null) { properties.put("VALUE", value) }

  properties
}

  override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _methodSummaryViaContainsNodeIn: Iterator[MethodSummary] = _containsNodeIn.asScala.collect { case node: MethodSummary => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    SpAnnotationParameter.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "annotationName" 
case 2 => "annotationFullName" 
case 3 => "name" 
case 4 => "value" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => annotationName
case 2 => annotationFullName
case 3 => name
case 4 => value
    }

  override def productPrefix = "SpAnnotationParameter"
  override def productArity = 5

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[SpAnnotationParameterDb]

  override def property(key:String): AnyRef = {
    key match {
      case "ANNOTATION_NAME" => this._annotationName
      case "ANNOTATION_FULL_NAME" => this._annotationFullName
      case "NAME" => this._name
      case "VALUE" => this._value
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "ANNOTATION_NAME" => this._annotationName = value.asInstanceOf[String]
      case "ANNOTATION_FULL_NAME" => this._annotationFullName = value.asInstanceOf[String]
      case "NAME" => this._name = value.asInstanceOf[String]
      case "VALUE" => this._value = value.asInstanceOf[String]
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewSpAnnotationParameter]
   this._annotationName = other.annotationName
   this._annotationFullName = other.annotationFullName
   this._name = other.name
   this._value = other.value


}

}

/** Traversal steps for SpAnnotationParameter */
class SpAnnotationParameterTraversal[NodeType <: SpAnnotationParameter](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to annotationName property */
  def annotationName: Traversal[String] =
    traversal.map(_.annotationName)

    /**
    * Traverse to nodes where the annotationName matches the regular expression `value`
    * */
  def annotationName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.ANNOTATION_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the annotationName matches at least one of the regular expressions in `values`
    * */
  def annotationName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.ANNOTATION_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where annotationName matches `value` exactly.
    * */
  def annotationNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.ANNOTATION_NAME, value)

  /**
    * Traverse to nodes where annotationName matches one of the elements in `values` exactly.
    * */
  def annotationNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.ANNOTATION_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where annotationName does not match the regular expression `value`.
    * */
  def annotationNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ANNOTATION_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where annotationName does not match any of the regular expressions in `values`.
    * */
  def annotationNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ANNOTATION_NAME.where(P.within(values.to(Set))))



  /** Traverse to annotationFullName property */
  def annotationFullName: Traversal[String] =
    traversal.map(_.annotationFullName)

    /**
    * Traverse to nodes where the annotationFullName matches the regular expression `value`
    * */
  def annotationFullName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.ANNOTATION_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the annotationFullName matches at least one of the regular expressions in `values`
    * */
  def annotationFullName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.ANNOTATION_FULL_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where annotationFullName matches `value` exactly.
    * */
  def annotationFullNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.ANNOTATION_FULL_NAME, value)

  /**
    * Traverse to nodes where annotationFullName matches one of the elements in `values` exactly.
    * */
  def annotationFullNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.ANNOTATION_FULL_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where annotationFullName does not match the regular expression `value`.
    * */
  def annotationFullNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ANNOTATION_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where annotationFullName does not match any of the regular expressions in `values`.
    * */
  def annotationFullNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ANNOTATION_FULL_NAME.where(P.within(values.to(Set))))



  /** Traverse to name property */
  def name: Traversal[String] =
    traversal.map(_.name)

    /**
    * Traverse to nodes where the name matches the regular expression `value`
    * */
  def name(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the name matches at least one of the regular expressions in `values`
    * */
  def name(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where name matches `value` exactly.
    * */
  def nameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME, value)

  /**
    * Traverse to nodes where name matches one of the elements in `values` exactly.
    * */
  def nameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where name does not match the regular expression `value`.
    * */
  def nameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where name does not match any of the regular expressions in `values`.
    * */
  def nameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.within(values.to(Set))))



  /** Traverse to value property */
  def value: Traversal[String] =
    traversal.map(_.value)

    /**
    * Traverse to nodes where the value matches the regular expression `value`
    * */
  def value(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.VALUE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the value matches at least one of the regular expressions in `values`
    * */
  def value(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.VALUE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where value matches `value` exactly.
    * */
  def valueExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.VALUE, value)

  /**
    * Traverse to nodes where value matches one of the elements in `values` exactly.
    * */
  def valueExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.VALUE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where value does not match the regular expression `value`.
    * */
  def valueNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.VALUE.where(P.matches(regex)))

  /**
    * Traverse to nodes where value does not match any of the regular expressions in `values`.
    * */
  def valueNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.VALUE.where(P.within(values.to(Set))))




}
