package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object Transformation {
  def apply(graph: Graph, id: Long) = new Transformation(graph, id)

  val Label = "TRANSFORMATION"
  val LabelId: Int = 213

  object PropertyNames {
    val Node = "node" 
    val all: Set[String] = Set(Node)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    
    val Node = new PropertyKey[TrackingPoint]("node") 
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.ContainsNode.layoutInformation).asJava,
    List(edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("CONTAINS_NODE")
    val Out: Array[String] = Array("CONTAINS_NODE")
  }

  val factory = new NodeFactory[TransformationDb] {
    override val forLabel = Transformation.Label
    override val forLabelId = Transformation.LabelId

    override def createNode(ref: NodeRef[TransformationDb]) =
      new TransformationDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Transformation(graph, id)
  }
}

trait TransformationBase extends CpgNode   {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  def node: TrackingPointBase
}

class Transformation(graph: Graph, id: Long) extends NodeRef[TransformationDb](graph, id)
  with TransformationBase
  with StoredNode
   {
  
    def node = get().node
  def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = get()._trackingPointViaContainsNodeOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _flowViaContainsNodeIn: Iterator[Flow] = get()._flowViaContainsNodeIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    Transformation.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => node
    }

  override def productPrefix = "Transformation"
  override def productArity = 2
}

class TransformationDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
   with TransformationBase {

  override def layoutInformation: NodeLayoutInformation = Transformation.layoutInformation



private var _node: TrackingPoint = null
def node: TrackingPoint = this._node


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]

   if (this._node != null) { properties.put("node", this._node) }
  properties
}

  def _trackingPointViaContainsNodeOut: Iterator[TrackingPoint] = _containsNodeOut.asScala.collect { case node: TrackingPoint => node }
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _flowViaContainsNodeIn: Iterator[Flow] = _containsNodeIn.asScala.collect { case node: Flow => node }
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    Transformation.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "node" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => node
    }

  override def productPrefix = "Transformation"
  override def productArity = 2

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TransformationDb]

  override def property(key:String): AnyRef = {
    key match {
      
      case "node" => this._node
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
    
      case "node" => this._node = value.asInstanceOf[TrackingPoint]
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewTransformation]

  this._node = other.node match {
    case null => null
    case newNode: NewNode => mapping(newNode).asInstanceOf[TrackingPoint]
    case oldNode: StoredNode => oldNode.asInstanceOf[TrackingPoint]
    case _ => throw new MatchError("unreachable")
  }

}

}

/** Traversal steps for Transformation */
class TransformationTraversal[NodeType <: Transformation](val traversal: Traversal[NodeType]) extends AnyVal {



}
