package io.shiftleft.codepropertygraph.generated.nodes

import io.shiftleft.codepropertygraph.generated.{EdgeKeys, NodeKeys}
import io.shiftleft.codepropertygraph.generated.edges
import java.lang.{Boolean => JBoolean, Long => JLong}
import java.util.{Collections => JCollections, HashMap => JHashMap, Iterator => JIterator, Map => JMap, Set => JSet}
import overflowdb._
import overflowdb.traversal.filter.P
import overflowdb.traversal.Traversal
import scala.jdk.CollectionConverters._

object TypeDecl {
  def apply(graph: Graph, id: Long) = new TypeDecl(graph, id)

  val Label = "TYPE_DECL"
  val LabelId: Int = 46

  object PropertyNames {
    val Name = "NAME" 
    val FullName = "FULL_NAME" 
    val IsExternal = "IS_EXTERNAL" 
    val InheritsFromTypeFullName = "INHERITS_FROM_TYPE_FULL_NAME" 
    val AstParentType = "AST_PARENT_TYPE" 
    val AstParentFullName = "AST_PARENT_FULL_NAME" 
    val AliasTypeFullName = "ALIAS_TYPE_FULL_NAME" 
    val Order = "ORDER" 
    val Filename = "FILENAME" 
    val all: Set[String] = Set(Name, FullName, IsExternal, InheritsFromTypeFullName, AstParentType, AstParentFullName, AliasTypeFullName, Order, Filename)
    val allAsJava: JSet[String] = all.asJava
  }

  object Properties {
    val Name = new PropertyKey[String]("NAME") 
    val FullName = new PropertyKey[String]("FULL_NAME") 
    val IsExternal = new PropertyKey[Boolean]("IS_EXTERNAL") 
    val InheritsFromTypeFullName = new PropertyKey[Seq[String]]("INHERITS_FROM_TYPE_FULL_NAME") 
    val AstParentType = new PropertyKey[String]("AST_PARENT_TYPE") 
    val AstParentFullName = new PropertyKey[String]("AST_PARENT_FULL_NAME") 
    val AliasTypeFullName = new PropertyKey[String]("ALIAS_TYPE_FULL_NAME") 
    val Order = new PropertyKey[Integer]("ORDER") 
    val Filename = new PropertyKey[String]("FILENAME") 
    
  }

  val layoutInformation = new NodeLayoutInformation(
    LabelId,
    PropertyNames.allAsJava,
    List(edges.Vtable.layoutInformation, edges.SourceFile.layoutInformation, edges.Contains.layoutInformation, edges.Binds.layoutInformation, edges.AliasOf.layoutInformation, edges.InheritsFrom.layoutInformation, edges.Ast.layoutInformation, edges.TypeDeclAlias.layoutInformation, edges.ContainsNode.layoutInformation).asJava,
    List(edges.IsSensitiveDataDescrOf.layoutInformation, edges.Ref.layoutInformation, edges.Contains.layoutInformation, edges.DynamicType.layoutInformation, edges.Ast.layoutInformation, edges.TypeDeclAlias.layoutInformation, edges.ContainsNode.layoutInformation).asJava)

  object Edges {
    val In: Array[String] = Array("IS_SENSITIVE_DATA_DESCR_OF","REF","CONTAINS","DYNAMIC_TYPE","AST","TYPE_DECL_ALIAS","CONTAINS_NODE")
    val Out: Array[String] = Array("VTABLE","SOURCE_FILE","CONTAINS","BINDS","ALIAS_OF","INHERITS_FROM","AST","TYPE_DECL_ALIAS","CONTAINS_NODE")
  }

  val factory = new NodeFactory[TypeDeclDb] {
    override val forLabel = TypeDecl.Label
    override val forLabelId = TypeDecl.LabelId

    override def createNode(ref: NodeRef[TypeDeclDb]) =
      new TypeDeclDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = TypeDecl(graph, id)
  }
}

trait TypeDeclBase extends CpgNode with AstNodeBase with HasName with HasFullName with HasIsExternal with HasInheritsFromTypeFullName with HasAstParentType with HasAstParentFullName with HasAliasTypeFullName with HasOrder with HasFilename {
  def asStored : StoredNode = this.asInstanceOf[StoredNode]

  
}

class TypeDecl(graph: Graph, id: Long) extends NodeRef[TypeDeclDb](graph, id)
  with TypeDeclBase
  with StoredNode
  with AstNode {
    override def name: String = get().name
  override def fullName: String = get().fullName
  override def isExternal: JBoolean = get().isExternal
  override def inheritsFromTypeFullName: List[String] = get().inheritsFromTypeFullName
  override def astParentType: String = get().astParentType
  override def astParentFullName: String = get().astParentFullName
  override def aliasTypeFullName: Option[String] = get().aliasTypeFullName
  override def order: Integer = get().order
  override def filename: String = get().filename
  
  def _methodViaVtableOut: Iterator[Method] = get()._methodViaVtableOut
override def _vtableOut(): JIterator[StoredNode] = get()._vtableOut
def _fileViaSourceFileOut: Iterator[File] = get()._fileViaSourceFileOut
override def _sourceFileOut(): JIterator[StoredNode] = get()._sourceFileOut
def _methodViaContainsOut: Iterator[Method] = get()._methodViaContainsOut
override def _containsOut(): JIterator[StoredNode] = get()._containsOut
def _bindingViaBindsOut: Iterator[Binding] = get()._bindingViaBindsOut
override def _bindsOut(): JIterator[StoredNode] = get()._bindsOut
def _typeViaAliasOfOut: Iterator[Type] = get()._typeViaAliasOfOut
override def _aliasOfOut(): JIterator[StoredNode] = get()._aliasOfOut
def _typeViaInheritsFromOut: Iterator[Type] = get()._typeViaInheritsFromOut
override def _inheritsFromOut(): JIterator[StoredNode] = get()._inheritsFromOut
override def _astOut(): JIterator[StoredNode] = get()._astOut
def _typeDeclViaAstOut: Iterator[TypeDecl] = get()._typeDeclViaAstOut
def _annotationViaAstOut: Iterator[Annotation] = get()._annotationViaAstOut
def _memberViaAstOut: Iterator[Member] = get()._memberViaAstOut
def _methodViaAstOut: Iterator[Method] = get()._methodViaAstOut
def _typeParameterViaAstOut: Iterator[TypeParameter] = get()._typeParameterViaAstOut
def _modifierViaAstOut: Iterator[Modifier] = get()._modifierViaAstOut
def _typeDeclViaTypeDeclAliasOut: Iterator[TypeDecl] = get()._typeDeclViaTypeDeclAliasOut
override def _typeDeclAliasOut(): JIterator[StoredNode] = get()._typeDeclAliasOut
override def _containsNodeOut(): JIterator[StoredNode] = get()._containsNodeOut
def _sensitiveDataTypeViaIsSensitiveDataDescrOfIn: Iterator[SensitiveDataType] = get()._sensitiveDataTypeViaIsSensitiveDataDescrOfIn
override def _isSensitiveDataDescrOfIn(): JIterator[StoredNode] = get()._isSensitiveDataDescrOfIn
def _typeViaRefIn: Iterator[Type] = get()._typeViaRefIn
override def _refIn(): JIterator[StoredNode] = get()._refIn
def _fileViaContainsIn: Iterator[File] = get()._fileViaContainsIn
override def _containsIn(): JIterator[StoredNode] = get()._containsIn
def _methodParameterInViaDynamicTypeIn: Iterator[MethodParameterIn] = get()._methodParameterInViaDynamicTypeIn
def _localViaDynamicTypeIn: Iterator[Local] = get()._localViaDynamicTypeIn
override def _dynamicTypeIn(): JIterator[StoredNode] = get()._dynamicTypeIn
def _unknownViaDynamicTypeIn: Iterator[Unknown] = get()._unknownViaDynamicTypeIn
def _fieldIdentifierViaDynamicTypeIn: Iterator[FieldIdentifier] = get()._fieldIdentifierViaDynamicTypeIn
def _identifierViaDynamicTypeIn: Iterator[Identifier] = get()._identifierViaDynamicTypeIn
def _typeRefViaDynamicTypeIn: Iterator[TypeRef] = get()._typeRefViaDynamicTypeIn
def _literalViaDynamicTypeIn: Iterator[Literal] = get()._literalViaDynamicTypeIn
def _callViaDynamicTypeIn: Iterator[Call] = get()._callViaDynamicTypeIn
def _memberViaDynamicTypeIn: Iterator[Member] = get()._memberViaDynamicTypeIn
def _methodReturnViaDynamicTypeIn: Iterator[MethodReturn] = get()._methodReturnViaDynamicTypeIn
def _controlStructureViaDynamicTypeIn: Iterator[ControlStructure] = get()._controlStructureViaDynamicTypeIn
def _blockViaDynamicTypeIn: Iterator[Block] = get()._blockViaDynamicTypeIn
def _methodRefViaDynamicTypeIn: Iterator[MethodRef] = get()._methodRefViaDynamicTypeIn
def _methodViaAstIn: Option[Method] = get()._methodViaAstIn
def _namespaceBlockViaAstIn: Option[NamespaceBlock] = get()._namespaceBlockViaAstIn
def _typeDeclViaAstIn: Option[TypeDecl] = get()._typeDeclViaAstIn
override def _astIn(): JIterator[StoredNode] = get()._astIn
def _typeDeclViaTypeDeclAliasIn: Iterator[TypeDecl] = get()._typeDeclViaTypeDeclAliasIn
override def _typeDeclAliasIn(): JIterator[StoredNode] = get()._typeDeclAliasIn
override def _containsNodeIn(): JIterator[StoredNode] = get()._containsNodeIn
  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def valueMap: JMap[String, AnyRef] = get.valueMap
  override def canEqual(that: Any): Boolean = get.canEqual(that)
  override def label: String = {
    TypeDecl.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "fullName" 
case 3 => "isExternal" 
case 4 => "inheritsFromTypeFullName" 
case 5 => "astParentType" 
case 6 => "astParentFullName" 
case 7 => "aliasTypeFullName" 
case 8 => "order" 
case 9 => "filename" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => fullName
case 3 => isExternal
case 4 => inheritsFromTypeFullName
case 5 => astParentType
case 6 => astParentFullName
case 7 => aliasTypeFullName
case 8 => order
case 9 => filename
    }

  override def productPrefix = "TypeDecl"
  override def productArity = 10
}

class TypeDeclDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode
  with AstNode with TypeDeclBase {

  override def layoutInformation: NodeLayoutInformation = TypeDecl.layoutInformation

private var _name: String = null
def name(): String = _name

private var _fullName: String = null
def fullName(): String = _fullName

private var _isExternal: JBoolean = null
def isExternal(): JBoolean = _isExternal

private var _inheritsFromTypeFullName: List[String] = Nil
def inheritsFromTypeFullName(): List[String] = _inheritsFromTypeFullName

private var _astParentType: String = null
def astParentType(): String = _astParentType

private var _astParentFullName: String = null
def astParentFullName(): String = _astParentFullName

private var _aliasTypeFullName: Option[String] = None
def aliasTypeFullName(): Option[String] = _aliasTypeFullName

private var _order: Integer = null
def order(): Integer = _order

private var _filename: String = null
def filename(): String = _filename


  /* all properties */
  override def valueMap: JMap[String, AnyRef] =  {
  val properties = new JHashMap[String, AnyRef]
if (name != null) { properties.put("NAME", name) }
if (fullName != null) { properties.put("FULL_NAME", fullName) }
if (isExternal != null) { properties.put("IS_EXTERNAL", isExternal) }
if (inheritsFromTypeFullName.nonEmpty) { properties.put("INHERITS_FROM_TYPE_FULL_NAME", inheritsFromTypeFullName.asJava) }
if (astParentType != null) { properties.put("AST_PARENT_TYPE", astParentType) }
if (astParentFullName != null) { properties.put("AST_PARENT_FULL_NAME", astParentFullName) }
aliasTypeFullName.map { value => properties.put("ALIAS_TYPE_FULL_NAME", value) }
if (order != null) { properties.put("ORDER", order) }
if (filename != null) { properties.put("FILENAME", filename) }

  properties
}

  def _methodViaVtableOut: Iterator[Method] = _vtableOut.asScala.collect { case node: Method => node }
override def _vtableOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(0).asInstanceOf[JIterator[StoredNode]]
def _fileViaSourceFileOut: Iterator[File] = _sourceFileOut.asScala.collect { case node: File => node }
override def _sourceFileOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(1).asInstanceOf[JIterator[StoredNode]]
def _methodViaContainsOut: Iterator[Method] = _containsOut.asScala.collect { case node: Method => node }
override def _containsOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(2).asInstanceOf[JIterator[StoredNode]]
def _bindingViaBindsOut: Iterator[Binding] = _bindsOut.asScala.collect { case node: Binding => node }
override def _bindsOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(3).asInstanceOf[JIterator[StoredNode]]
def _typeViaAliasOfOut: Iterator[Type] = _aliasOfOut.asScala.collect { case node: Type => node }
override def _aliasOfOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(4).asInstanceOf[JIterator[StoredNode]]
def _typeViaInheritsFromOut: Iterator[Type] = _inheritsFromOut.asScala.collect { case node: Type => node }
override def _inheritsFromOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(5).asInstanceOf[JIterator[StoredNode]]
def _memberViaAstOut: Iterator[Member] = _astOut.asScala.collect { case node: Member => node }
def _typeDeclViaAstOut: Iterator[TypeDecl] = _astOut.asScala.collect { case node: TypeDecl => node }
override def _astOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(6).asInstanceOf[JIterator[StoredNode]]
def _methodViaAstOut: Iterator[Method] = _astOut.asScala.collect { case node: Method => node }
def _annotationViaAstOut: Iterator[Annotation] = _astOut.asScala.collect { case node: Annotation => node }
def _typeParameterViaAstOut: Iterator[TypeParameter] = _astOut.asScala.collect { case node: TypeParameter => node }
def _modifierViaAstOut: Iterator[Modifier] = _astOut.asScala.collect { case node: Modifier => node }
def _typeDeclViaTypeDeclAliasOut: Iterator[TypeDecl] = _typeDeclAliasOut.asScala.collect { case node: TypeDecl => node }
override def _typeDeclAliasOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(7).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeOut: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(8).asInstanceOf[JIterator[StoredNode]]
def _sensitiveDataTypeViaIsSensitiveDataDescrOfIn: Iterator[SensitiveDataType] = _isSensitiveDataDescrOfIn.asScala.collect { case node: SensitiveDataType => node }
override def _isSensitiveDataDescrOfIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(9).asInstanceOf[JIterator[StoredNode]]
def _typeViaRefIn: Iterator[Type] = _refIn.asScala.collect { case node: Type => node }
override def _refIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(10).asInstanceOf[JIterator[StoredNode]]
def _fileViaContainsIn: Iterator[File] = _containsIn.asScala.collect { case node: File => node }
override def _containsIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(11).asInstanceOf[JIterator[StoredNode]]
def _blockViaDynamicTypeIn: Iterator[Block] = _dynamicTypeIn.asScala.collect { case node: Block => node }
def _identifierViaDynamicTypeIn: Iterator[Identifier] = _dynamicTypeIn.asScala.collect { case node: Identifier => node }
def _controlStructureViaDynamicTypeIn: Iterator[ControlStructure] = _dynamicTypeIn.asScala.collect { case node: ControlStructure => node }
def _methodRefViaDynamicTypeIn: Iterator[MethodRef] = _dynamicTypeIn.asScala.collect { case node: MethodRef => node }
def _literalViaDynamicTypeIn: Iterator[Literal] = _dynamicTypeIn.asScala.collect { case node: Literal => node }
def _fieldIdentifierViaDynamicTypeIn: Iterator[FieldIdentifier] = _dynamicTypeIn.asScala.collect { case node: FieldIdentifier => node }
override def _dynamicTypeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(12).asInstanceOf[JIterator[StoredNode]]
def _methodReturnViaDynamicTypeIn: Iterator[MethodReturn] = _dynamicTypeIn.asScala.collect { case node: MethodReturn => node }
def _memberViaDynamicTypeIn: Iterator[Member] = _dynamicTypeIn.asScala.collect { case node: Member => node }
def _callViaDynamicTypeIn: Iterator[Call] = _dynamicTypeIn.asScala.collect { case node: Call => node }
def _typeRefViaDynamicTypeIn: Iterator[TypeRef] = _dynamicTypeIn.asScala.collect { case node: TypeRef => node }
def _methodParameterInViaDynamicTypeIn: Iterator[MethodParameterIn] = _dynamicTypeIn.asScala.collect { case node: MethodParameterIn => node }
def _localViaDynamicTypeIn: Iterator[Local] = _dynamicTypeIn.asScala.collect { case node: Local => node }
def _unknownViaDynamicTypeIn: Iterator[Unknown] = _dynamicTypeIn.asScala.collect { case node: Unknown => node }
def _methodViaAstIn: Option[Method] = _astIn.asScala.collect { case node: Method => node }.nextOption
def _namespaceBlockViaAstIn: Option[NamespaceBlock] = _astIn.asScala.collect { case node: NamespaceBlock => node }.nextOption
def _typeDeclViaAstIn: Option[TypeDecl] = _astIn.asScala.collect { case node: TypeDecl => node }.nextOption
override def _astIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(13).asInstanceOf[JIterator[StoredNode]]
def _typeDeclViaTypeDeclAliasIn: Iterator[TypeDecl] = _typeDeclAliasIn.asScala.collect { case node: TypeDecl => node }
override def _typeDeclAliasIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(14).asInstanceOf[JIterator[StoredNode]]
override def _containsNodeIn: JIterator[StoredNode] = createAdjacentNodeIteratorByOffSet(15).asInstanceOf[JIterator[StoredNode]]

  override def label: String = {
    TypeDecl.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id" 
case 1 => "name" 
case 2 => "fullName" 
case 3 => "isExternal" 
case 4 => "inheritsFromTypeFullName" 
case 5 => "astParentType" 
case 6 => "astParentFullName" 
case 7 => "aliasTypeFullName" 
case 8 => "order" 
case 9 => "filename" 
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
case 1 => name
case 2 => fullName
case 3 => isExternal
case 4 => inheritsFromTypeFullName
case 5 => astParentType
case 6 => astParentFullName
case 7 => aliasTypeFullName
case 8 => order
case 9 => filename
    }

  override def productPrefix = "TypeDecl"
  override def productArity = 10

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[TypeDeclDb]

  override def property(key:String): AnyRef = {
    key match {
      case "NAME" => this._name
      case "FULL_NAME" => this._fullName
      case "IS_EXTERNAL" => this._isExternal
      case "INHERITS_FROM_TYPE_FULL_NAME" => this._inheritsFromTypeFullName
      case "AST_PARENT_TYPE" => this._astParentType
      case "AST_PARENT_FULL_NAME" => this._astParentFullName
      case "ALIAS_TYPE_FULL_NAME" => this._aliasTypeFullName.orNull
      case "ORDER" => this._order
      case "FILENAME" => this._filename
      
      case _ => null
    }
  }

  override protected def updateSpecificProperty(key:String, value: Object): Unit = {
    key match {
      case "NAME" => this._name = value.asInstanceOf[String]
      case "FULL_NAME" => this._fullName = value.asInstanceOf[String]
      case "IS_EXTERNAL" => this._isExternal = value.asInstanceOf[JBoolean]
      case "INHERITS_FROM_TYPE_FULL_NAME" => this._inheritsFromTypeFullName = value match {
        case singleValue: String => List(singleValue)
        case null | None | Nil => Nil
        case jCollection: java.lang.Iterable[_] => jCollection.asInstanceOf[java.util.Collection[String]].iterator.asScala.toList
        case lst: List[_] => value.asInstanceOf[List[String]]
      }
      case "AST_PARENT_TYPE" => this._astParentType = value.asInstanceOf[String]
      case "AST_PARENT_FULL_NAME" => this._astParentFullName = value.asInstanceOf[String]
      case "ALIAS_TYPE_FULL_NAME" => this._aliasTypeFullName = value match {
        case null | None => None
        case someVal: String => Some(someVal)
      }
      case "ORDER" => this._order = value.asInstanceOf[Integer]
      case "FILENAME" => this._filename = value.asInstanceOf[String]
    
      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

override def removeSpecificProperty(key: String): Unit =
  this.updateSpecificProperty(key, null)

override def fromNewNode(someNewNode: NewNode, mapping: NewNode => StoredNode):Unit = {
  //this will throw for bad types -- no need to check by hand, we don't have a better error message
  val other = someNewNode.asInstanceOf[NewTypeDecl]
   this._name = other.name
   this._fullName = other.fullName
   this._isExternal = other.isExternal
   this._inheritsFromTypeFullName = other.inheritsFromTypeFullName
   this._astParentType = other.astParentType
   this._astParentFullName = other.astParentFullName
   this._aliasTypeFullName = other.aliasTypeFullName
   this._order = other.order
   this._filename = other.filename

  graph.indexManager.putIfIndexed("FULL_NAME", other.fullName, this.ref)
}

}

/** Traversal steps for TypeDecl */
class TypeDeclTraversal[NodeType <: TypeDecl](val traversal: Traversal[NodeType]) extends AnyVal {

  /** Traverse to name property */
  def name: Traversal[String] =
    traversal.map(_.name)

    /**
    * Traverse to nodes where the name matches the regular expression `value`
    * */
  def name(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the name matches at least one of the regular expressions in `values`
    * */
  def name(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where name matches `value` exactly.
    * */
  def nameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME, value)

  /**
    * Traverse to nodes where name matches one of the elements in `values` exactly.
    * */
  def nameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where name does not match the regular expression `value`.
    * */
  def nameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where name does not match any of the regular expressions in `values`.
    * */
  def nameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.NAME.where(P.within(values.to(Set))))



  /** Traverse to fullName property */
  def fullName: Traversal[String] =
    traversal.map(_.fullName)

    /**
    * Traverse to nodes where the fullName matches the regular expression `value`
    * */
  def fullName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the fullName matches at least one of the regular expressions in `values`
    * */
  def fullName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.FULL_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where fullName matches `value` exactly.
    * */
  def fullNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.FULL_NAME, value)

  /**
    * Traverse to nodes where fullName matches one of the elements in `values` exactly.
    * */
  def fullNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.FULL_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where fullName does not match the regular expression `value`.
    * */
  def fullNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where fullName does not match any of the regular expressions in `values`.
    * */
  def fullNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.FULL_NAME.where(P.within(values.to(Set))))



  /** Traverse to isExternal property */
  def isExternal: Traversal[JBoolean] =
    traversal.map(_.isExternal)

    /**
    * Traverse to nodes where the isExternal equals the given `value`
    * */
  def isExternal(value: JBoolean): Traversal[NodeType] =
    traversal.has(NodeKeys.IS_EXTERNAL, value)

  /**
    * Traverse to nodes where isExternal is not equal to the given `value`.
    * */
  def isExternalNot(value: JBoolean): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.IS_EXTERNAL, value)


  /** Traverse to inheritsFromTypeFullName property */
  def inheritsFromTypeFullName: Traversal[String] =
    traversal.flatMap(_.inheritsFromTypeFullName)

  

  /** Traverse to astParentType property */
  def astParentType: Traversal[String] =
    traversal.map(_.astParentType)

    /**
    * Traverse to nodes where the astParentType matches the regular expression `value`
    * */
  def astParentType(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.AST_PARENT_TYPE.where(P.matches(regex)))

  /**
    * Traverse to nodes where the astParentType matches at least one of the regular expressions in `values`
    * */
  def astParentType(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.AST_PARENT_TYPE.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where astParentType matches `value` exactly.
    * */
  def astParentTypeExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.AST_PARENT_TYPE, value)

  /**
    * Traverse to nodes where astParentType matches one of the elements in `values` exactly.
    * */
  def astParentTypeExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.AST_PARENT_TYPE.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where astParentType does not match the regular expression `value`.
    * */
  def astParentTypeNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.AST_PARENT_TYPE.where(P.matches(regex)))

  /**
    * Traverse to nodes where astParentType does not match any of the regular expressions in `values`.
    * */
  def astParentTypeNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.AST_PARENT_TYPE.where(P.within(values.to(Set))))



  /** Traverse to astParentFullName property */
  def astParentFullName: Traversal[String] =
    traversal.map(_.astParentFullName)

    /**
    * Traverse to nodes where the astParentFullName matches the regular expression `value`
    * */
  def astParentFullName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.AST_PARENT_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the astParentFullName matches at least one of the regular expressions in `values`
    * */
  def astParentFullName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.AST_PARENT_FULL_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where astParentFullName matches `value` exactly.
    * */
  def astParentFullNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.AST_PARENT_FULL_NAME, value)

  /**
    * Traverse to nodes where astParentFullName matches one of the elements in `values` exactly.
    * */
  def astParentFullNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.AST_PARENT_FULL_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where astParentFullName does not match the regular expression `value`.
    * */
  def astParentFullNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.AST_PARENT_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where astParentFullName does not match any of the regular expressions in `values`.
    * */
  def astParentFullNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.AST_PARENT_FULL_NAME.where(P.within(values.to(Set))))



  /** Traverse to aliasTypeFullName property */
  def aliasTypeFullName: Traversal[String] =
    traversal.flatMap(_.aliasTypeFullName)

    /**
    * Traverse to nodes where the aliasTypeFullName matches the regular expression `value`
    * */
  def aliasTypeFullName(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.ALIAS_TYPE_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the aliasTypeFullName matches at least one of the regular expressions in `values`
    * */
  def aliasTypeFullName(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.ALIAS_TYPE_FULL_NAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where aliasTypeFullName matches `value` exactly.
    * */
  def aliasTypeFullNameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.ALIAS_TYPE_FULL_NAME, value)

  /**
    * Traverse to nodes where aliasTypeFullName matches one of the elements in `values` exactly.
    * */
  def aliasTypeFullNameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.ALIAS_TYPE_FULL_NAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where aliasTypeFullName does not match the regular expression `value`.
    * */
  def aliasTypeFullNameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ALIAS_TYPE_FULL_NAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where aliasTypeFullName does not match any of the regular expressions in `values`.
    * */
  def aliasTypeFullNameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ALIAS_TYPE_FULL_NAME.where(P.within(values.to(Set))))



  /** Traverse to order property */
  def order: Traversal[Integer] =
    traversal.map(_.order)

    /**
    * Traverse to nodes where the order equals the given `value`
    * */
  def order(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where the order equals at least one of the given `values`
    * */
  def order(values: Integer*): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(P.within(values.toSet)))

  /**
    * Traverse to nodes where the order is greater than the given `value`
    * */
  def orderGt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ > value))

  /**
    * Traverse to nodes where the order is greater than or equal the given `value`
    * */
  def orderGte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ >= value))

  /**
    * Traverse to nodes where the order is less than the given `value`
    * */
  def orderLt(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ < value))

  /**
    * Traverse to nodes where the order is less than or equal the given `value`
    * */
  def orderLte(value: Integer): Traversal[NodeType] =
    traversal.has(NodeKeys.ORDER.where(_ <= value))

  /**
    * Traverse to nodes where order is not equal to the given `value`.
    * */
  def orderNot(value: Integer): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER, value)

  /**
    * Traverse to nodes where order is not equal to any of the given `values`.
    * */
  def orderNot(values: Integer*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.ORDER.where(P.within(values.toSet)))


  /** Traverse to filename property */
  def filename: Traversal[String] =
    traversal.map(_.filename)

    /**
    * Traverse to nodes where the filename matches the regular expression `value`
    * */
  def filename(regex: String): Traversal[NodeType] =
    traversal.has(NodeKeys.FILENAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where the filename matches at least one of the regular expressions in `values`
    * */
  def filename(regexes: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.FILENAME.where(P.matches(regexes: _*)))

  /**
    * Traverse to nodes where filename matches `value` exactly.
    * */
  def filenameExact(value: String): Traversal[NodeType] =
    traversal.has(NodeKeys.FILENAME, value)

  /**
    * Traverse to nodes where filename matches one of the elements in `values` exactly.
    * */
  def filenameExact(values: String*): Traversal[NodeType] =
    traversal.has(NodeKeys.FILENAME.where(P.within(values.to(Set))))

  /**
    * Traverse to nodes where filename does not match the regular expression `value`.
    * */
  def filenameNot(regex: String): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.FILENAME.where(P.matches(regex)))

  /**
    * Traverse to nodes where filename does not match any of the regular expressions in `values`.
    * */
  def filenameNot(values: String*): Traversal[NodeType] =
    traversal.hasNot(NodeKeys.FILENAME.where(P.within(values.to(Set))))




}
