/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.codepropertygraph.cpgloading;

import com.google.protobuf.GeneratedMessageV3;
import io.shiftleft.codepropertygraph.cpgloading.ProtoToCpg;
import io.shiftleft.codepropertygraph.cpgloading.TmpEdge;
import io.shiftleft.codepropertygraph.cpgloading.ZipArchive;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.proto.cpg.Cpg;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.Config;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayDeque;
import scala.collection.mutable.ArrayDeque$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

public final class ProtoCpgLoader$ {
    public static final ProtoCpgLoader$ MODULE$ = new ProtoCpgLoader$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());

    private Logger logger() {
        return logger;
    }

    public Cpg loadFromProtoZip(String fileName, Config overflowDbConfig) {
        return (Cpg)this.measureAndReport((Function0 & Serializable)() -> {
            ProtoToCpg builder = new ProtoToCpg(overflowDbConfig);
            Try try_ = Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
                ProtoCpgLoader$.$anonfun$loadFromProtoZip$2(fileName, builder, use);
                return BoxedUnit.UNIT;
            });
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw exception;
            }
            if (!(try_ instanceof Success)) {
                throw new MatchError((Object)try_);
            }
            Cpg cpg = builder.build();
            return cpg;
        });
    }

    public Config loadFromProtoZip$default$2() {
        return Config.withoutOverflow();
    }

    public Cpg loadFromListOfProtos(Seq<Cpg.CpgStruct> cpgs, Config overflowDbConfig) {
        ProtoToCpg builder = new ProtoToCpg(overflowDbConfig);
        cpgs.foreach((Function1 & Serializable)cpg -> {
            builder.addNodes(cpg.getNodeList());
            return BoxedUnit.UNIT;
        });
        cpgs.foreach((Function1 & Serializable)cpg -> {
            ProtoCpgLoader$.$anonfun$loadFromListOfProtos$2(builder, cpg);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public Cpg loadFromListOfProtos(List<Cpg.CpgStruct> cpgs, Config overflowDbConfig) {
        return this.loadFromListOfProtos((Seq<Cpg.CpgStruct>)CollectionConverters$.MODULE$.ListHasAsScala(cpgs).asScala().toSeq(), overflowDbConfig);
    }

    public Try<Iterator<Cpg.CpgOverlay>> loadOverlays(String fileName) {
        return this.loadOverlays(fileName, (Function1 & Serializable)x$1 -> Cpg.CpgOverlay.parseFrom((InputStream)x$1));
    }

    public Try<Iterator<Cpg.DiffGraph>> loadDiffGraphs(String fileName) {
        return this.loadOverlays(fileName, (Function1 & Serializable)x$1 -> Cpg.DiffGraph.parseFrom((InputStream)x$1));
    }

    private <T extends GeneratedMessageV3> Try<Iterator<T>> loadOverlays(String fileName, Function1<InputStream, T> f) {
        return Using$.MODULE$.apply((Function0 & Serializable)() -> new ZipArchive(fileName), (Function1 & Serializable)zip -> ((IterableOnce)((IterableOps)zip.entries().sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ProtoCpgLoader$.MODULE$.compareOverlayPath(a, b)))).map((Function1 & Serializable)path -> {
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            return (GeneratedMessageV3)f.apply((Object)is);
        })).iterator(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private boolean compareOverlayPath(Path a, Path b) {
        String[] file1Split = ((Object)a).toString().replace("/", "").split("_");
        String[] file2Split = ((Object)b).toString().replace("/", "").split("_");
        return file1Split.length < 2 || file2Split.length < 2 ? StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(((Object)a).toString()), ((Object)b).toString()) : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(file1Split[0])) < StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(file2Split[0]));
    }

    private Cpg.CpgStruct getNextProtoCpgFromStream(InputStream inputStream) {
        return Cpg.CpgStruct.parseFrom((InputStream)inputStream);
    }

    private <A> A measureAndReport(Function0<A> f) {
        long start = System.currentTimeMillis();
        Object result = f.apply();
        this.logger().info(new StringBuilder(32).append("CPG construction finished in ").append(System.currentTimeMillis() - start).append("ms.").toString());
        return (A)result;
    }

    public static final /* synthetic */ void $anonfun$loadFromProtoZip$3(Using.Manager use$1, ProtoToCpg builder$1, ArrayDeque edges$1, Path entry) {
        InputStream inputStream = (InputStream)use$1.apply((Object)Files.newInputStream(entry, new OpenOption[0]), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Cpg.CpgStruct cpgStruct = MODULE$.getNextProtoCpgFromStream(inputStream);
        builder$1.addNodes(cpgStruct.getNodeList());
        CollectionConverters$.MODULE$.ListHasAsScala(cpgStruct.getEdgeList()).asScala().foreach((Function1 & Serializable)edge -> (ArrayDeque)edges$1.append((Object)new TmpEdge((Cpg.CpgStruct.Edge)edge)));
    }

    public static final /* synthetic */ void $anonfun$loadFromProtoZip$2(String fileName$1, ProtoToCpg builder$1, Using.Manager use) {
        ArrayDeque edges2 = ArrayDeque$.MODULE$.empty();
        ((ZipArchive)use.apply((Object)new ZipArchive(fileName$1), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$)).entries().foreach((Function1 & Serializable)entry -> {
            ProtoCpgLoader$.$anonfun$loadFromProtoZip$3(use, builder$1, edges2, entry);
            return BoxedUnit.UNIT;
        });
        while (edges2.nonEmpty()) {
            TmpEdge edge = (TmpEdge)edges2.removeHead(edges2.removeHead$default$1());
            builder$1.addEdge(edge.dst(), edge.src(), Cpg.CpgStruct.Edge.EdgeType.forNumber((int)edge.typ()), (Iterable<Cpg.CpgStruct.Edge.Property>)edge.properties());
        }
    }

    public static final /* synthetic */ void $anonfun$loadFromListOfProtos$2(ProtoToCpg builder$2, Cpg.CpgStruct cpg) {
        CollectionConverters$.MODULE$.ListHasAsScala(cpg.getEdgeList()).asScala().foreach((Function1 & Serializable)edge -> {
            builder$2.addEdge(edge.getDst(), edge.getSrc(), edge.getType(), (Iterable<Cpg.CpgStruct.Edge.Property>)CollectionConverters$.MODULE$.ListHasAsScala(edge.getPropertyList()).asScala());
            return BoxedUnit.UNIT;
        });
    }

    private ProtoCpgLoader$() {
    }
}

