/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.console.cpgcreation;

import better.files.Dsl$;
import better.files.File;
import better.files.File$;
import io.shiftleft.codepropertygraph.cpgloading.CpgLoader$;
import io.shiftleft.codepropertygraph.cpgloading.CpgLoaderConfig;
import io.shiftleft.codepropertygraph.cpgloading.CpgLoaderConfig$;
import io.shiftleft.console.ConsoleConfig;
import io.shiftleft.console.LanguageHelper$;
import io.shiftleft.console.cpgcreation.LanguageFrontend;
import io.shiftleft.console.cpgcreation.LanguageGuesser$;
import java.io.Serializable;
import java.nio.file.Path;
import overflowdb.Config;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001\u0002\u0006\f\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\u0006A\u0001!\t!\t\u0005\u0006K\u0001!\tA\n\u0005\u0006u\u0001!\ta\u000f\u0005\u0006}\u0001!\ta\u0010\u0005\b7\u0002\t\n\u0011\"\u0001]\u0011\u00159\u0007\u0001\"\u0001i\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u0015q\b\u0001\"\u0003\u0000\u00051\u0019\u0005oZ$f]\u0016\u0014\u0018\r^8s\u0015\taQ\"A\u0006da\u001e\u001c'/Z1uS>t'B\u0001\b\u0010\u0003\u001d\u0019wN\\:pY\u0016T!\u0001E\t\u0002\u0013MD\u0017N\u001a;mK\u001a$(\"\u0001\n\u0002\u0005%|7\u0001A\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0017AB2p]\u001aLw\r\u0005\u0002\u001e=5\tQ\"\u0003\u0002 \u001b\ti1i\u001c8t_2,7i\u001c8gS\u001e\fa\u0001P5oSRtDC\u0001\u0012%!\t\u0019\u0003!D\u0001\f\u0011\u0015Y\"\u00011\u0001\u001d\u0003Q\u0019'/Z1uK\u001a\u0013xN\u001c;f]\u0012\u0014\u0015\u0010U1uQR\u0011q%\f\t\u0004-!R\u0013BA\u0015\u0018\u0005\u0019y\u0005\u000f^5p]B\u00111eK\u0005\u0003Y-\u0011\u0001\u0003T1oOV\fw-\u001a$s_:$XM\u001c3\t\u000b9\u001a\u0001\u0019A\u0018\u0002\u0013%t\u0007/\u001e;QCRD\u0007C\u0001\u00198\u001d\t\tT\u0007\u0005\u00023/5\t1G\u0003\u00025'\u00051AH]8pizJ!AN\f\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003m]\t\u0001d\u0019:fCR,gI]8oi\u0016tGMQ=MC:<W/Y4f)\t9C\bC\u0003>\t\u0001\u0007q&\u0001\u0005mC:<W/Y4f\u0003M\u0011XO\u001c'b]\u001e,\u0018mZ3Ge>tG/\u001a8e)\u0015\u00015*\u0014(Q!\r1\u0002&\u0011\t\u0003\u0005&k\u0011a\u0011\u0006\u0003\t\u0016\u000bAAZ5mK*\u0011aiR\u0001\u0004]&|'\"\u0001%\u0002\t)\fg/Y\u0005\u0003\u0015\u000e\u0013A\u0001U1uQ\")A*\u0002a\u0001U\u0005AaM]8oi\u0016tG\rC\u0003/\u000b\u0001\u0007q\u0006C\u0003P\u000b\u0001\u0007q&\u0001\u0006pkR\u0004X\u000f\u001e)bi\"Dq!U\u0003\u0011\u0002\u0003\u0007!+\u0001\u0006oC6,7\u000f]1dKN\u00042a\u0015-0\u001d\t!fK\u0004\u00023+&\t\u0001$\u0003\u0002X/\u00059\u0001/Y2lC\u001e,\u0017BA-[\u0005\u0011a\u0015n\u001d;\u000b\u0005];\u0012!\b:v]2\u000bgnZ;bO\u00164%o\u001c8uK:$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003uS#A\u00150,\u0003}\u0003\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\u0013Ut7\r[3dW\u0016$'B\u00013\u0018\u0003)\tgN\\8uCRLwN\\\u0005\u0003M\u0006\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m\u0019wN\u001c<feR\u0004&o\u001c;p\u0007B<Gk\\(wKJ4Gn\\<EER\u0019\u0011\u000e\u001c8\u0011\u0005YQ\u0017BA6\u0018\u0005\u0011)f.\u001b;\t\u000b5<\u0001\u0019A\u0018\u0002\u0017M\u00148MR5mK:\fW.\u001a\u0005\u0006_\u001e\u0001\raL\u0001\fIN$h)\u001b7f]\u0006lW-A\u0005jgjK\u0007OR5mKR\u0011!/\u001e\t\u0003-ML!\u0001^\f\u0003\u000f\t{w\u000e\\3b]\")A\t\u0003a\u0001mB\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\u0006M&dWm\u001d\u0006\u0002w\u00061!-\u001a;uKJL!! =\u0003\t\u0019KG.Z\u0001\u0007e\u0016\u0004xN\u001d;\u0015\u0007%\f\t\u0001\u0003\u0004\u0002\u0004%\u0001\raL\u0001\u0004gR\u0014\b")
public class CpgGenerator {
    private final ConsoleConfig config;

    public Option<LanguageFrontend> createFrontendByPath(String inputPath) {
        return LanguageGuesser$.MODULE$.guessLanguage(inputPath).flatMap((Function1 & Serializable)l -> LanguageHelper$.MODULE$.cpgGeneratorForLanguage((String)l, $this.config.frontend(), $this.config.install().rootPath().path()));
    }

    public Option<LanguageFrontend> createFrontendByLanguage(String language2) {
        return new Some((Object)language2).filter((Function1 & Serializable)language -> BoxesRunTime.boxToBoolean((boolean)LanguageHelper$.MODULE$.languageIsKnown(language))).flatMap((Function1 & Serializable)lang -> LanguageHelper$.MODULE$.cpgGeneratorForLanguage((String)lang, $this.config.frontend(), $this.config.install().rootPath().path()));
    }

    public Option<Path> runLanguageFrontend(LanguageFrontend frontend, String inputPath, String outputPath, List<String> namespaces) {
        Option outputFileOpt = frontend.generate(inputPath, outputPath, namespaces).map((Function1 & Serializable)x$1 -> File$.MODULE$.apply(x$1, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])));
        return outputFileOpt.map((Function1 & Serializable)outFile -> {
            void var2_2;
            Object object;
            Path parentPath = outFile.parent().path().toAbsolutePath();
            if (this.isZipFile((File)outFile)) {
                this.report("Creating database from bin.zip");
                String srcFilename = ((Object)outFile.path().toAbsolutePath()).toString();
                String dstFilename = ((Object)parentPath.resolve("cpg.bin").toAbsolutePath()).toString();
                this.convertProtoCpgToOverflowDb(srcFilename, dstFilename);
                object = BoxedUnit.UNIT;
            } else {
                this.report("moving cpg.bin.zip to cpg.bin because it is already a database file");
                Path srcPath = parentPath.resolve("cpg.bin.zip");
                object = srcPath.toFile().exists() ? Dsl$.MODULE$.mv(File$.MODULE$.apply(srcPath), File$.MODULE$.apply(parentPath.resolve("cpg.bin"))) : BoxedUnit.UNIT;
            }
            return var2_2;
        });
    }

    public List<String> runLanguageFrontend$default$4() {
        return Nil$.MODULE$;
    }

    public void convertProtoCpgToOverflowDb(String srcFilename, String dstFilename) {
        Config odbConfig = Config.withDefaults().withStorageLocation(dstFilename);
        CpgLoaderConfig config = CpgLoaderConfig$.MODULE$.withDefaults().doNotCreateIndexesOnLoad().withOverflowConfig(odbConfig);
        CpgLoader$.MODULE$.load(srcFilename, config).close();
        File qual$1 = File$.MODULE$.apply(srcFilename, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        boolean x$1 = qual$1.delete$default$1();
        Seq x$2 = qual$1.delete$default$2();
        qual$1.delete(x$1, x$2);
    }

    public boolean isZipFile(File file) {
        Iterator bytes = file.bytes();
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToByte((Object)bytes.next()) == 80 && BoxesRunTime.unboxToByte((Object)bytes.next()) == 75).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    private void report(String str) {
        System.err.println(str);
    }

    public CpgGenerator(ConsoleConfig config) {
        this.config = config;
    }
}

