/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.console.cpgcreation;

import better.files.Dsl$;
import better.files.File;
import better.files.File$;
import io.shiftleft.codepropertygraph.cpgloading.CpgLoader$;
import io.shiftleft.codepropertygraph.cpgloading.CpgLoaderConfig;
import io.shiftleft.codepropertygraph.cpgloading.CpgLoaderConfig$;
import io.shiftleft.console.ConsoleConfig;
import io.shiftleft.console.cpgcreation.CpgGenerator;
import io.shiftleft.console.cpgcreation.package$;
import java.io.Serializable;
import java.nio.file.Path;
import overflowdb.Config;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001B\u0006\r\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\u0006C\u0001!\tA\t\u0005\u0006M\u0001!\ta\n\u0005\u0006w\u0001!\t\u0001\u0010\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\u0006\u000b\u0002!\tA\u0012\u0005\bE\u0002\t\n\u0011\"\u0001d\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u00159\b\u0001\"\u0001y\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000f\u00111c\u00119h\u000f\u0016tWM]1u_J4\u0015m\u0019;pefT!!\u0004\b\u0002\u0017\r\u0004xm\u0019:fCRLwN\u001c\u0006\u0003\u001fA\tqaY8og>dWM\u0003\u0002\u0012%\u0005I1\u000f[5gi2,g\r\u001e\u0006\u0002'\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VMZ\u0001\u0007G>tg-[4\u0011\u0005yyR\"\u0001\b\n\u0005\u0001r!!D\"p]N|G.Z\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0003G\u0015\u0002\"\u0001\n\u0001\u000e\u00031AQ\u0001\b\u0002A\u0002u\t\u0011BZ8s\u0007>$W-\u0011;\u0015\u0005!r\u0003cA\f*W%\u0011!\u0006\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0011b\u0013BA\u0017\r\u00051\u0019\u0005oZ$f]\u0016\u0014\u0018\r^8s\u0011\u0015y3\u00011\u00011\u0003%Ig\u000e];u!\u0006$\b\u000e\u0005\u00022q9\u0011!G\u000e\t\u0003gai\u0011\u0001\u000e\u0006\u0003kQ\ta\u0001\u0010:p_Rt\u0014BA\u001c\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]B\u0012a\u00034pe2\u000bgnZ;bO\u0016$\"\u0001K\u001f\t\u000by\"\u0001\u0019\u0001\u0019\u0002\u00111\fgnZ;bO\u0016\fq\u0002\\1oOV\fw-Z%t\u0017:|wO\u001c\u000b\u0003\u0003\u0012\u0003\"a\u0006\"\n\u0005\rC\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006}\u0015\u0001\r\u0001M\u0001\reVtw)\u001a8fe\u0006$xN\u001d\u000b\u0006\u000fJ#Vk\u0016\t\u0004/%B\u0005CA%Q\u001b\u0005Q%BA&M\u0003\u00111\u0017\u000e\\3\u000b\u00055s\u0015a\u00018j_*\tq*\u0001\u0003kCZ\f\u0017BA)K\u0005\u0011\u0001\u0016\r\u001e5\t\u000bM3\u0001\u0019A\u0016\u0002\u0011\u0019\u0014xN\u001c;f]\u0012DQa\f\u0004A\u0002ABQA\u0016\u0004A\u0002A\n!b\\;uaV$\b+\u0019;i\u0011\u001dAf\u0001%AA\u0002e\u000b!B\\1nKN\u0004\u0018mY3t!\rQv\f\r\b\u00037vs!a\r/\n\u0003eI!A\u0018\r\u0002\u000fA\f7m[1hK&\u0011\u0001-\u0019\u0002\u0005\u0019&\u001cHO\u0003\u0002_1\u00051\"/\u001e8HK:,'/\u0019;pe\u0012\"WMZ1vYR$C'F\u0001eU\tIVmK\u0001g!\t9G.D\u0001i\u0015\tI'.A\u0005v]\u000eDWmY6fI*\u00111\u000eG\u0001\u000bC:tw\u000e^1uS>t\u0017BA7i\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cG>tg/\u001a:u!J|Go\\\"qOR{wJ^3sM2|w\u000f\u00122\u0015\u0007A\u001cX\u000f\u0005\u0002\u0018c&\u0011!\u000f\u0007\u0002\u0005+:LG\u000fC\u0003u\u0011\u0001\u0007\u0001'A\u0006te\u000e4\u0015\u000e\\3oC6,\u0007\"\u0002<\t\u0001\u0004\u0001\u0014a\u00033ti\u001aKG.\u001a8b[\u0016\f\u0011\"[:[SB4\u0015\u000e\\3\u0015\u0005\u0005K\b\"B&\n\u0001\u0004Q\bcA>\u0002\u00025\tAP\u0003\u0002~}\u0006)a-\u001b7fg*\tq0\u0001\u0004cKR$XM]\u0005\u0004\u0003\u0007a(\u0001\u0002$jY\u0016\faA]3q_J$Hc\u00019\u0002\n!1\u00111\u0002\u0006A\u0002A\n1a\u001d;s\u0001")
public class CpgGeneratorFactory {
    private final ConsoleConfig config;

    public Option<CpgGenerator> forCodeAt(String inputPath) {
        return package$.MODULE$.guessLanguage(inputPath).flatMap((Function1 & Serializable)l -> {
            this.report(new StringBuilder(30).append("Using generator for language: ").append((String)l).toString());
            return package$.MODULE$.cpgGeneratorForLanguage((String)l, $this.config.frontend(), $this.config.install().rootPath().path());
        });
    }

    public Option<CpgGenerator> forLanguage(String language2) {
        return new Some((Object)language2).filter((Function1 & Serializable)language -> BoxesRunTime.boxToBoolean((boolean)this.languageIsKnown(language))).flatMap((Function1 & Serializable)lang -> package$.MODULE$.cpgGeneratorForLanguage((String)lang, $this.config.frontend(), $this.config.install().rootPath().path()));
    }

    public boolean languageIsKnown(String language) {
        return ((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"C", "CSHARP", "GOLANG", "JAVA", "JAVASCRIPT", "PYTHON", "LLVM", "PHP"}))).contains((Object)language);
    }

    public Option<Path> runGenerator(CpgGenerator frontend, String inputPath, String outputPath, List<String> namespaces) {
        Option outputFileOpt = frontend.generate(inputPath, outputPath, namespaces).map((Function1 & Serializable)x$1 -> File$.MODULE$.apply(x$1, (Seq)Nil$.MODULE$));
        return outputFileOpt.map((Function1 & Serializable)outFile -> {
            void var2_2;
            Object object;
            Path parentPath = outFile.parent().path().toAbsolutePath();
            if (this.isZipFile((File)outFile)) {
                this.report("Creating database from bin.zip");
                String srcFilename = ((Object)outFile.path().toAbsolutePath()).toString();
                String dstFilename = ((Object)parentPath.resolve("cpg.bin").toAbsolutePath()).toString();
                this.convertProtoCpgToOverflowDb(srcFilename, dstFilename);
                object = BoxedUnit.UNIT;
            } else {
                this.report("moving cpg.bin.zip to cpg.bin because it is already a database file");
                Path srcPath = parentPath.resolve("cpg.bin.zip");
                object = srcPath.toFile().exists() ? Dsl$.MODULE$.mv(File$.MODULE$.apply(srcPath), File$.MODULE$.apply(parentPath.resolve("cpg.bin"))) : BoxedUnit.UNIT;
            }
            return var2_2;
        });
    }

    public List<String> runGenerator$default$4() {
        return (List)scala.package$.MODULE$.List().apply((Seq)Nil$.MODULE$);
    }

    public void convertProtoCpgToOverflowDb(String srcFilename, String dstFilename) {
        Config odbConfig = Config.withDefaults().withStorageLocation(dstFilename);
        CpgLoaderConfig config = CpgLoaderConfig$.MODULE$.withDefaults().doNotCreateIndexesOnLoad().withOverflowConfig(odbConfig);
        CpgLoader$.MODULE$.load(srcFilename, config).close();
        File qual$1 = File$.MODULE$.apply(srcFilename, (Seq)Nil$.MODULE$);
        boolean x$1 = qual$1.delete$default$1();
        Seq x$2 = qual$1.delete$default$2();
        qual$1.delete(x$1, x$2);
    }

    public boolean isZipFile(File file) {
        Iterator bytes = file.bytes();
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToByte((Object)bytes.next()) == 80 && BoxesRunTime.unboxToByte((Object)bytes.next()) == 75).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    private void report(String str) {
        System.err.println(str);
    }

    public CpgGeneratorFactory(ConsoleConfig config) {
        this.config = config;
    }
}

