/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.cpgloading.janusgraph;

import io.shiftleft.cpgloading.ProtoToCpgBase;
import io.shiftleft.proto.cpg.Cpg;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.schema.JanusGraphManagement;

public class ProtoToCpg
extends ProtoToCpgBase {
    public ProtoToCpg() {
        super((Graph)JanusGraphFactory.build().set("cache.db-cache", (Object)false).set("cache.tx-cache-size", (Object)4000000).set("storage.backend", (Object)"inmemory").open());
    }

    protected void configureGraph(Graph graph) {
        JanusGraphManagement mgmt = ((JanusGraph)graph).openManagement();
        mgmt.makePropertyKey("INHERITS_FROM_TYPE_FULL_NAME").dataType(String.class).cardinality(Cardinality.LIST).make();
        mgmt.makePropertyKey("UNRECOGNIZED").dataType(Object.class).make();
        mgmt.commit();
        this.logger.info("configured janus propertykeys");
    }

    public void addNodes(Cpg.CpgStruct protoCpg) {
        for (Cpg.CpgStruct.Node protoNode : protoCpg.getNodeList()) {
            Vertex node;
            if (this.elementImportCounter % 1000 == 0) {
                long millisSinceLastBatch = System.currentTimeMillis() - this.lastStart;
                this.lastStart = System.currentTimeMillis();
                System.out.println("importing node " + this.elementImportCounter + "; millis since last batch: " + millisSinceLastBatch);
            }
            if (this.elementImportCounter % 10000 == 0) {
                this.commit();
            }
            ++this.elementImportCounter;
            try {
                node = this.graph.addVertex(new Object[]{T.label, protoNode.getType().name()});
                this.keyToVertexId.put(protoNode.getKey(), node.id());
            }
            catch (IllegalArgumentException exception) {
                this.logger.warn("Failed to insert a vertex", (Throwable)exception);
                continue;
            }
            for (Cpg.CpgStruct.Node.Property property : protoNode.getPropertyList()) {
                this.addPropertyToElement((Element)node, property.getName().name(), property.getValue());
            }
        }
    }
}

