/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.io;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class TimeUtils$ {
    public static final TimeUtils$ MODULE$ = new TimeUtils$();

    public <R> Tuple2<R, Object> time(Function0<R> block) {
        long t0 = System.nanoTime();
        Object result = block.apply();
        long t1 = System.nanoTime();
        long elapsed = t1 - t0;
        return new Tuple2(result, (Object)BoxesRunTime.boxToLong((long)elapsed));
    }

    public String pretty(Duration duration) {
        String string;
        Duration duration2 = duration;
        if (duration2 instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration2;
            long nanos = finiteDuration.toNanos();
            TimeUnit unit = this.chooseUnit(nanos);
            double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
            string = StringOps$.MODULE$.formatLocal$extension(Predef$.MODULE$.augmentString("%.4g %s"), Locale.ROOT, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)value), this.abbreviate(unit)}));
        } else {
            Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
            Duration duration3 = duration2;
            if (!(infinite != null ? !infinite.equals(duration3) : duration3 != null)) {
                string = "-\u221e (minus infinity)";
            } else {
                Duration.Infinite infinite2 = Duration$.MODULE$.Inf();
                Duration duration4 = duration2;
                string = !(infinite2 != null ? !infinite2.equals(duration4) : duration4 != null) ? "\u221e (infinity)" : "undefined";
            }
        }
        return string;
    }

    private TimeUnit chooseUnit(long nanos) {
        FiniteDuration d = new package.DurationLong(package$.MODULE$.DurationLong(nanos)).nanos();
        return d.toDays() > 0L ? TimeUnit.DAYS : (d.toHours() > 0L ? TimeUnit.HOURS : (d.toMinutes() > 0L ? TimeUnit.MINUTES : (d.toSeconds() > 0L ? TimeUnit.SECONDS : (d.toMillis() > 0L ? TimeUnit.MILLISECONDS : (d.toMicros() > 0L ? TimeUnit.MICROSECONDS : TimeUnit.NANOSECONDS)))));
    }

    private String abbreviate(TimeUnit unit) {
        String string;
        TimeUnit timeUnit = unit;
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) {
            string = "ns";
        } else if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) {
            string = "\u03bcs";
        } else if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) {
            string = "ms";
        } else if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) {
            string = "s";
        } else if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) {
            string = "min";
        } else if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) {
            string = "h";
        } else if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) {
            string = "d";
        } else {
            throw new MatchError((Object)timeUnit);
        }
        return string;
    }

    private TimeUtils$() {
    }
}

