/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.core;

import better.files.File;
import better.files.File$;
import io.shiftleft.codepropertygraph.Cpg;
import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.core.Report;
import io.shiftleft.js2cpg.cpg.passes.AstCreationPass;
import io.shiftleft.js2cpg.cpg.passes.BuiltinTypesPass;
import io.shiftleft.js2cpg.cpg.passes.CallLinkerPass;
import io.shiftleft.js2cpg.cpg.passes.ConfigPass;
import io.shiftleft.js2cpg.cpg.passes.DependenciesPass;
import io.shiftleft.js2cpg.cpg.passes.JsMetaDataPass;
import io.shiftleft.js2cpg.cpg.passes.PrivateKeyFilePass;
import io.shiftleft.js2cpg.io.FileDefaults$;
import io.shiftleft.js2cpg.io.FileUtils$;
import io.shiftleft.js2cpg.parser.PackageJsonParser$;
import io.shiftleft.js2cpg.preprocessing.NuxtTranspiler$;
import io.shiftleft.js2cpg.preprocessing.TranspilationRunner;
import io.shiftleft.js2cpg.preprocessing.TranspilationRunner$;
import io.shiftleft.js2cpg.util.MemoryMetrics$;
import io.shiftleft.passes.IntervalKeyPool;
import io.shiftleft.passes.KeyPool;
import io.shiftleft.passes.KeyPoolCreator$;
import io.shiftleft.x2cpg.X2Cpg$;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001\u0002\t\u0012\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u00040\u0001\u0001\u0006Ia\n\u0005\ba\u0001\u0011\r\u0011\"\u00032\u0011\u0019)\u0004\u0001)A\u0005e!)a\u0007\u0001C\u0005o!)1\f\u0001C\u00059\")\u0011\u000e\u0001C\u0005U\")a\u000e\u0001C\u0005_\")A\u000f\u0001C\u0005k\")\u0011\u0010\u0001C\u0005u\"1q\u0010\u0001C\u0005\u0003\u0003Aq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u0010\u0001!I!!\u0005\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.\t1!j\u001d\u001aDa\u001eT!AE\n\u0002\t\r|'/\u001a\u0006\u0003)U\taA[:3GB<'B\u0001\f\u0018\u0003%\u0019\b.\u001b4uY\u00164GOC\u0001\u0019\u0003\tIwn\u0001\u0001\u0014\u0005\u0001Y\u0002C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011A\u0005A\u0007\u0002#\u00051An\\4hKJ,\u0012a\n\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\nQa\u001d7gi)T\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018*\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013A\u0002:fa>\u0014H/F\u00013!\t!3'\u0003\u00025#\t1!+\u001a9peR\fqA]3q_J$\b%A\u000bdQ\u0016\u001c7n\u00119h\u000f\u0016t\u0017J\u001c9vi\u001aKG.Z:\u0015\u0007aZd\u000b\u0005\u0002\u001ds%\u0011!(\b\u0002\u0005+:LG\u000fC\u0003=\r\u0001\u0007Q(A\u0004kg\u001aKG.Z:\u0011\u0007y2\u0015J\u0004\u0002@\t:\u0011\u0001iQ\u0007\u0002\u0003*\u0011!)G\u0001\u0007yI|w\u000e\u001e \n\u0003yI!!R\u000f\u0002\u000fA\f7m[1hK&\u0011q\t\u0013\u0002\u0005\u0019&\u001cHO\u0003\u0002F;A!AD\u0013'M\u0013\tYUD\u0001\u0004UkBdWM\r\t\u0003\u001bRk\u0011A\u0014\u0006\u0003\u001fB\u000bAAZ5mK*\u0011\u0011KU\u0001\u0004]&|'\"A*\u0002\t)\fg/Y\u0005\u0003+:\u0013A\u0001U1uQ\")qK\u0002a\u00011\u000611m\u001c8gS\u001e\u0004\"\u0001J-\n\u0005i\u000b\"AB\"p]\u001aLw-A\tiC:$G.\u001a,tSb\u0004&o\u001c6fGR$2!X3h!\tq6-D\u0001`\u0015\t\u0001\u0017-A\u0003gS2,7OC\u0001c\u0003\u0019\u0011W\r\u001e;fe&\u0011Am\u0018\u0002\u0005\r&dW\rC\u0003g\u000f\u0001\u0007Q,A\u0004qe>TWm\u0019;\t\u000b!<\u0001\u0019A/\u0002\u001bQl\u0007\u000f\u0015:pU\u0016\u001cG\u000fR5s\u0003UA\u0017M\u001c3mKN#\u0018M\u001c3be\u0012\u0004&o\u001c6fGR$B!X6m[\")a\r\u0003a\u0001;\")\u0001\u000e\u0003a\u0001;\")q\u000b\u0003a\u00011\u0006aa-\u001b8e!J|'.Z2ugR\u0019\u0001/]:\u0011\u0007y2E\nC\u0003s\u0013\u0001\u0007Q,\u0001\u0006qe>TWm\u0019;ESJDQaV\u0005A\u0002a\u000ba![:J]\u000eKW#\u0001<\u0011\u0005q9\u0018B\u0001=\u001e\u0005\u001d\u0011un\u001c7fC:\fabY8mY\u0016\u001cGOS:GS2,7\u000f\u0006\u0003>wrt\b\"\u0002\u001f\f\u0001\u0004i\u0004\"B?\f\u0001\u0004a\u0015a\u00013je\")qk\u0003a\u00011\u0006)\u0002O]3qCJ,\u0017I\u001c3HK:,'/\u0019;f\u0007B<Gc\u0002\u001d\u0002\u0004\u0005\u0015\u0011q\u0001\u0005\u0006M2\u0001\r!\u0018\u0005\u0006Q2\u0001\r!\u0018\u0005\u0006/2\u0001\r\u0001W\u0001\u0004eVtGc\u0001\u001d\u0002\u000e!)q+\u0004a\u00011\u0006Y1m\u001c8gS\u001e4\u0015\u000e\\3t)\u0015i\u00141CA\u000b\u0011\u00159f\u00021\u0001Y\u0011\u001d\t9B\u0004a\u0001\u00033\t!\"\u001a=uK:\u001c\u0018n\u001c8t!\u0011qd)a\u0007\u0011\t\u0005u\u0011Q\u0005\b\u0005\u0003?\t\t\u0003\u0005\u0002A;%\u0019\u00111E\u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\t9#!\u000b\u0003\rM#(/\u001b8h\u0015\r\t\u0019#H\u0001\fO\u0016tWM]1uK\u000e\u0003v\tF\u00039\u0003_\t\t\u0004C\u0003X\u001f\u0001\u0007\u0001\f\u0003\u0004\u00024=\u0001\r!P\u0001\u0010UN4\u0015\u000e\\3t/&$\bNU8pi\u0002")
public class Js2Cpg {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Report report;
    private volatile byte bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);

    private Logger logger() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/js2cpg/js2cpg/src/main/scala/io/shiftleft/js2cpg/core/Js2Cpg.scala: 21");
        }
        return this.logger;
    }

    private Report report() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/js2cpg/js2cpg/src/main/scala/io/shiftleft/js2cpg/core/Js2Cpg.scala: 23");
        }
        return this.report;
    }

    private void checkCpgGenInputFiles(List<Tuple2<Path, Path>> jsFiles, Config config) {
        block4: {
            if (!jsFiles.isEmpty()) break block4;
            File project = File$.MODULE$.apply(config.srcDir(), (Seq)Nil$.MODULE$);
            this.logger().warn(new StringBuilder(48).append("'").append(project).append("' contains no *.js files. No CPG was generated.").toString());
            if (config.babelTranspiling()) {
                this.logger().warn("\t- Babel transpilation did not yield any *.js files");
            }
            if (config.tsTranspiling()) {
                this.logger().warn("\t- Typescript compilation did not yield any *.js files. Does a valid 'tsconfig.json' exist in that folder?");
            }
            if (config.vueTranspiling()) {
                this.logger().warn("\t- Vue.js transpilation did not yield any *.js files.");
            }
            if (config.templateTranspiling()) {
                this.logger().warn("\t- Template transpilation did not yield any *.js files.");
            }
            System.exit(1);
        }
    }

    private File handleVsixProject(File project, File tmpProjectDir) {
        this.logger().debug(new StringBuilder(60).append("Project is a VS code extension file (*").append(FileDefaults$.MODULE$.VSIX_SUFFIX()).append("). Unpacking it to '").append(tmpProjectDir).append("'.").toString());
        File x$1 = tmpProjectDir;
        Charset x$2 = project.streamedUnzip$default$2(x$1);
        return project.streamedUnzip(x$1, x$2).$div("extension");
    }

    private File handleStandardProject(File project, File tmpProjectDir, Config config) {
        File file;
        File realProjectPath;
        File file2 = realProjectPath = File$.MODULE$.apply(project.path().toRealPath(new LinkOption[0]));
        File file3 = tmpProjectDir;
        if (!(file2 != null ? !file2.equals(file3) : file3 != null)) {
            file = realProjectPath;
        } else {
            File file4;
            this.logger().debug(new StringBuilder(37).append("Copying '").append(realProjectPath).append("' to temporary workspace '").append(tmpProjectDir).append("'.").toString());
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                File x$1 = realProjectPath;
                File x$2 = tmpProjectDir;
                Config x$3 = config;
                Seq<CopyOption> x$4 = FileUtils$.MODULE$.copyToDirectory$default$4(x$1, x$2, x$3);
                return FileUtils$.MODULE$.copyToDirectory(x$1, x$2, x$3, x$4);
            });
            if (try_ instanceof Failure) {
                this.logger().debug(new StringBuilder(82).append("Unable to copy project to temporary workspace '").append(tmpProjectDir).append("'. Does it contain broken symlinks?").toString());
                this.logger().debug(new StringBuilder(63).append("Retrying to copy '").append(realProjectPath).append("' to temporary workspace '").append(tmpProjectDir).append("' without symlinks.").toString());
                file4 = FileUtils$.MODULE$.copyToDirectory(realProjectPath, tmpProjectDir, config, (Seq<CopyOption>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardCopyOption[]{StandardCopyOption.REPLACE_EXISTING})).$plus$plus((IterableOnce)File.LinkOptions$.MODULE$.noFollow())));
            } else if (try_ instanceof Success) {
                File value;
                Success success = (Success)try_;
                file4 = value = (File)success.value();
            } else {
                throw new MatchError((Object)try_);
            }
            file = file4;
        }
        return file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Path> findProjects(File projectDir, Config config) {
        List allProjects = FileUtils$.MODULE$.getFileTree(projectDir.path(), config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".json"}))), FileUtils$.MODULE$.getFileTree$default$4()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Js2Cpg.$anonfun$findProjects$1(x$1))).map((Function1 & Serializable)x$2 -> x$2.getParent());
        Set subProjects = (Set)Predef$.MODULE$.Set().from((IterableOnce)allProjects).$minus((Object)projectDir.path());
        List list = allProjects;
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{projectDir.path()}));
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Path head = (Path)colon2.head();
            List list3 = colon2.next$access$1();
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                Path path = head;
                Path path2 = projectDir.path();
                if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                    return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{head}));
                }
            }
        }
        this.logger().info(new StringBuilder(33).append("Found the following sub-projects:").append(((IterableOnceOps)subProjects.map((Function1 & Serializable)p -> projectDir.relativize(File$.MODULE$.apply(p)))).mkString("\n\t- ", "\n\t- ", "")).toString());
        Path path = projectDir.path();
        return (List)subProjects.toList().$plus$colon((Object)path);
    }

    private boolean isInCi() {
        return scala.sys.package$.MODULE$.env().get((Object)"CI").contains((Object)"true");
    }

    private List<Tuple2<Path, Path>> collectJsFiles(List<Tuple2<Path, Path>> jsFiles, Path dir, Config config) {
        List transpiledJsFiles = FileUtils$.MODULE$.getFileTree(dir, config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.JS_SUFFIX(), FileDefaults$.MODULE$.MJS_SUFFIX()}))), FileUtils$.MODULE$.getFileTree$default$4()).map((Function1 & Serializable)f -> new Tuple2(f, (Object)dir));
        return (List)jsFiles.filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Js2Cpg.$anonfun$collectJsFiles$2(transpiledJsFiles, x0$1))).$plus$plus((IterableOnce)transpiledJsFiles);
    }

    private void prepareAndGenerateCpg(File project, File tmpProjectDir, Config config) {
        File newTmpProjectDir = project.extension().contains((Object)FileDefaults$.MODULE$.VSIX_SUFFIX()) ? this.handleVsixProject(project, tmpProjectDir) : this.handleStandardProject(project, tmpProjectDir, config);
        FileUtils$.MODULE$.logAndClearExcludedPaths();
        List jsFilesBeforeTranspiling = FileUtils$.MODULE$.getFileTree(newTmpProjectDir.path(), config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.JS_SUFFIX(), FileDefaults$.MODULE$.MJS_SUFFIX()}))), FileUtils$.MODULE$.getFileTree$default$4()).map((Function1 & Serializable)f -> new Tuple2(f, (Object)newTmpProjectDir.path()));
        File$.MODULE$.usingTemporaryDirectory("js2cpgTranspileOut", File$.MODULE$.usingTemporaryDirectory$default$2(), File$.MODULE$.usingTemporaryDirectory$default$3(), (Function1 & Serializable)tmpTranspileDir -> {
            Js2Cpg.$anonfun$prepareAndGenerateCpg$2(this, newTmpProjectDir, config, jsFilesBeforeTranspiling, tmpTranspileDir);
            return BoxedUnit.UNIT;
        });
    }

    public void run(Config config) {
        File project = File$.MODULE$.apply(config.srcDir(), (Seq)Nil$.MODULE$);
        String absoluteProjectPath = project.canonicalFile().pathAsString();
        Config configWithAbsolutProjectPath = config.copy(absoluteProjectPath, config.copy$default$2(), config.copy$default$3(), config.copy$default$4(), config.copy$default$5(), config.copy$default$6(), config.copy$default$7(), config.copy$default$8(), config.copy$default$9(), config.copy$default$10(), config.copy$default$11(), config.copy$default$12(), config.copy$default$13(), config.copy$default$14(), config.copy$default$15(), config.copy$default$16(), config.copy$default$17(), config.copy$default$18(), config.copy$default$19(), config.copy$default$20());
        this.logger().info(new StringBuilder(45).append("Generating CPG from Javascript sources in: '").append(absoluteProjectPath).append("'").toString());
        this.logger().debug(new StringBuilder(14).append("Configuration:").append(configWithAbsolutProjectPath).toString());
        if (this.isInCi()) {
            this.prepareAndGenerateCpg(project, File$.MODULE$.apply(absoluteProjectPath, (Seq)Nil$.MODULE$), configWithAbsolutProjectPath);
        } else {
            File$.MODULE$.usingTemporaryDirectory(project.name(), File$.MODULE$.usingTemporaryDirectory$default$2(), File$.MODULE$.usingTemporaryDirectory$default$3(), (Function1 & Serializable)tmpProjectDir -> {
                this.prepareAndGenerateCpg(project, tmpProjectDir, configWithAbsolutProjectPath);
                return BoxedUnit.UNIT;
            });
        }
        this.logger().info("Generation of CPG is complete.");
        this.report().print();
    }

    private List<Tuple2<Path, Path>> configFiles(Config config, List<String> extensions) {
        return FileUtils$.MODULE$.getFileTree(File$.MODULE$.apply(config.srcDir(), (Seq)Nil$.MODULE$).path(), config, extensions, false).map((Function1 & Serializable)f -> new Tuple2(f, (Object)File$.MODULE$.apply(config.srcDir(), (Seq)Nil$.MODULE$).path()));
    }

    private void generateCPG(Config config, List<Tuple2<Path, Path>> jsFilesWithRoot) {
        IntervalKeyPool metaDataKeyPool = new IntervalKeyPool(1L, 100L);
        IntervalKeyPool builtinTypesKeyPool = new IntervalKeyPool(101L, 200L);
        IntervalKeyPool dependenciesKeyPool = new IntervalKeyPool(201L, 1000100L);
        List otherPools = KeyPoolCreator$.MODULE$.obtain(5L, 1000101L, KeyPoolCreator$.MODULE$.obtain$default$3());
        IntervalKeyPool functionKeyPool = (IntervalKeyPool)otherPools.head();
        IntervalKeyPool vueAsConfigPassPool = (IntervalKeyPool)otherPools.apply(1);
        IntervalKeyPool configPassPool = (IntervalKeyPool)otherPools.apply(2);
        IntervalKeyPool privateKeyFilePassPool = (IntervalKeyPool)otherPools.apply(3);
        IntervalKeyPool htmlAsConfigPassPool = (IntervalKeyPool)otherPools.apply(4);
        Cpg cpg = X2Cpg$.MODULE$.newEmptyCpg((Option)new Some((Object)config.outputFile()));
        String hash = FileUtils$.MODULE$.md5((Seq<Path>)jsFilesWithRoot.map((Function1 & Serializable)x$5 -> (Path)x$5._1()));
        new AstCreationPass(File$.MODULE$.apply(config.srcDir(), (Seq)Nil$.MODULE$), jsFilesWithRoot, cpg, functionKeyPool, this.report()).createAndApply();
        new CallLinkerPass(cpg).createAndApply();
        new JsMetaDataPass(cpg, (KeyPool)metaDataKeyPool, hash).createAndApply();
        new BuiltinTypesPass(cpg, (KeyPool)builtinTypesKeyPool).createAndApply();
        new DependenciesPass(cpg, config, (KeyPool)dependenciesKeyPool).createAndApply();
        new ConfigPass(this.configFiles(config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.VUE_SUFFIX()})))), cpg, vueAsConfigPassPool, this.report()).createAndApply();
        new PrivateKeyFilePass(this.configFiles(config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.KEY_SUFFIX()})))), cpg, privateKeyFilePassPool, this.report()).createAndApply();
        if (config.includeHtml()) {
            new ConfigPass(this.configFiles(config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.HTML_SUFFIX()})))), cpg, htmlAsConfigPassPool, this.report()).createAndApply();
        }
        if (config.includeConfigs()) {
            new ConfigPass(this.configFiles(config, FileDefaults$.MODULE$.CONFIG_FILES()), cpg, configPassPool, this.report()).createAndApply();
        }
        cpg.close();
    }

    public static final /* synthetic */ boolean $anonfun$findProjects$1(Path x$1) {
        return ((Object)x$1).toString().endsWith(PackageJsonParser$.MODULE$.PACKAGE_JSON_FILENAME());
    }

    public static final /* synthetic */ boolean $anonfun$collectJsFiles$3(String filename$1, Tuple2 x$3) {
        return x$3._1().toString().endsWith(filename$1);
    }

    public static final /* synthetic */ boolean $anonfun$collectJsFiles$2(List transpiledJsFiles$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path f = (Path)tuple2._1();
        Path rootDir = (Path)tuple2._2();
        String filename = ((Object)f).toString().replace(((Object)rootDir).toString(), "");
        boolean bl = transpiledJsFiles$1.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Js2Cpg.$anonfun$collectJsFiles$3(filename, x$3)));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$prepareAndGenerateCpg$3(File newTmpProjectDir$1, File tmpTranspileDir$1, Config config$2, Path p) {
        String string = ((Object)p).toString();
        String string2 = newTmpProjectDir$1.toString();
        None$ subDir = (string == null ? string2 != null : !string.equals(string2)) ? new Some((Object)newTmpProjectDir$1.relativize(File$.MODULE$.apply(p))) : None$.MODULE$;
        new TranspilationRunner(p, tmpTranspileDir$1.path(), config$2, (Option<Path>)subDir).execute();
    }

    public static final /* synthetic */ void $anonfun$prepareAndGenerateCpg$2(Js2Cpg $this, File newTmpProjectDir$1, Config config$2, List jsFilesBeforeTranspiling$1, File tmpTranspileDir) {
        $this.findProjects(newTmpProjectDir$1, config$2).foreach((Function1 & Serializable)p -> {
            Js2Cpg.$anonfun$prepareAndGenerateCpg$3(newTmpProjectDir$1, tmpTranspileDir, config$2, p);
            return BoxedUnit.UNIT;
        });
        List jsFilesAfterTranspiling = (List)$this.collectJsFiles((List<Tuple2<Path, Path>>)jsFilesBeforeTranspiling$1, tmpTranspileDir.path(), config$2).$plus$plus(NuxtTranspiler$.MODULE$.collectJsFiles(newTmpProjectDir$1.path(), config$2));
        List<Tuple2<Path, Path>> privateModuleFiles = !config$2.ignorePrivateDeps() ? new TranspilationRunner(newTmpProjectDir$1.path(), tmpTranspileDir.path(), config$2, TranspilationRunner$.MODULE$.$lessinit$greater$default$4()).handlePrivateModules() : package$.MODULE$.Nil();
        List jsFiles = (List)((StrictOptimizedSeqOps)jsFilesAfterTranspiling.$plus$plus((IterableOnce)privateModuleFiles)).distinctBy((Function1 & Serializable)x$4 -> (Path)x$4._1());
        FileUtils$.MODULE$.logAndClearExcludedPaths();
        $this.checkCpgGenInputFiles((List<Tuple2<Path, Path>>)jsFiles, config$2);
        MemoryMetrics$.MODULE$.withMemoryMetrics(config$2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.generateCPG(config$2.copy(newTmpProjectDir$1.toString(), config$2.copy$default$2(), config$2.copy$default$3(), config$2.copy$default$4(), config$2.copy$default$5(), config$2.copy$default$6(), config$2.copy$default$7(), config$2.copy$default$8(), config$2.copy$default$9(), config$2.copy$default$10(), config$2.copy$default$11(), config$2.copy$default$12(), config$2.copy$default$13(), config$2.copy$default$14(), config$2.copy$default$15(), config$2.copy$default$16(), config$2.copy$default$17(), config$2.copy$default$18(), config$2.copy$default$19(), config$2.copy$default$20()), (List<Tuple2<Path, Path>>)jsFiles));
    }

    public Js2Cpg() {
        this.report = new Report();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

