/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.io;

import better.files.File;
import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.io.EmScriptenCleaner$;
import io.shiftleft.js2cpg.io.FileCollector;
import io.shiftleft.js2cpg.io.FileCollector$;
import io.shiftleft.js2cpg.io.FileDefaults$;
import io.shiftleft.js2cpg.io.FileUtils;
import io.shiftleft.js2cpg.io.PathFilter;
import io.shiftleft.js2cpg.io.PathFilter$;
import io.shiftleft.x2cpg.IOUtils$;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.SortedMap;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

public final class FileUtils$ {
    public static final FileUtils$ MODULE$ = new FileUtils$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());
    private static final TrieMap<Path, String> excludedPaths;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        excludedPaths = TrieMap$.MODULE$.empty();
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
    }

    private Logger logger() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/js2cpg/js2cpg/src/main/scala/io/shiftleft/js2cpg/io/FileUtils.scala: 18");
        }
        return logger;
    }

    private TrieMap<Path, String> excludedPaths() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/js2cpg/js2cpg/src/main/scala/io/shiftleft/js2cpg/io/FileUtils.scala: 21");
        }
        return excludedPaths;
    }

    private boolean isDirectory(Path path) {
        return path == null || !Files.exists(path, new LinkOption[0]) ? false : Files.isDirectory(path, new LinkOption[0]);
    }

    public String md5(Seq<Path> files) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        ((IterableOnceOps)((SeqOps)files.filterNot((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FileUtils$.MODULE$.isDirectory(p.toRealPath(new LinkOption[0]))))).sortBy((Function1 & Serializable)x$1 -> ((Object)x$1.toRealPath(new LinkOption[0])).toString(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)path -> {
            FileUtils$.$anonfun$md5$3(md, path);
            return BoxedUnit.UNIT;
        });
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(md.digest()), (Function1 & Serializable)b -> FileUtils$.$anonfun$md5$4(BoxesRunTime.unboxToByte((Object)b)), ClassTag$.MODULE$.apply(String.class))).mkString();
    }

    public void logAndClearExcludedPaths() {
        this.excludedPaths().foreach((Function1 & Serializable)x0$1 -> {
            FileUtils$.$anonfun$logAndClearExcludedPaths$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.excludedPaths().clear();
    }

    /*
     * WARNING - void declaration
     */
    public String cleanPath(String sourceFileName) {
        void var3_3;
        String replacedDots = sourceFileName.replace("../", "").replace("\u0000", "");
        String replacedFile = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("file:///.:.*")).matches((CharSequence)replacedDots) ? replacedDots.replace("file:///", "") : replacedDots;
        return replacedFile.matches(".*\\.vue\\?.*$") ? replacedFile.substring(0, replacedFile.lastIndexOf(".vue") + 4) : var3_3;
    }

    public List<Path> getFileTree(Path rootPath, Config config, List<String> extensions, boolean filterIgnoredFiles) {
        FileCollector fileCollector = FileCollector$.MODULE$.apply(new PathFilter(rootPath, config, filterIgnoredFiles, extensions, PathFilter$.MODULE$.apply$default$5()));
        Files.walkFileTree(rootPath, fileCollector);
        this.excludedPaths().addAll(fileCollector.excludedPaths());
        return fileCollector.files();
    }

    public boolean getFileTree$default$4() {
        return true;
    }

    private File copyTo(File from, File destination, Config config, Seq<CopyOption> copyOptions) {
        FileCollector fileCollector = FileCollector$.MODULE$.apply(new PathFilter(from.path(), config, false, (List<String>)package$.MODULE$.List().empty(), config.withNodeModuleFolder()));
        Path path = from.isDirectory(from.isDirectory$default$1()) ? Files.walkFileTree(from.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(destination, from, fileCollector, copyOptions){
            private final File destination$1;
            private final File from$1;
            private final FileCollector fileCollector$1;
            private final Seq copyOptions$1;

            private Path newPath(Path subPath) {
                return this.destination$1.path().resolve(this.from$1.path().relativize(subPath));
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                FileVisitResult fileVisitResult;
                FileVisitResult fileVisitResult2 = this.fileCollector$1.preVisitDirectory(dir, attrs);
                if (((Object)((Object)FileVisitResult.CONTINUE)).equals((Object)((Object)fileVisitResult2))) {
                    FileVisitResult fileVisitResult3 = fileVisitResult2;
                    Files.createDirectories(this.newPath(dir), new FileAttribute[0]);
                    fileVisitResult = fileVisitResult3;
                } else {
                    fileVisitResult = fileVisitResult2;
                }
                return fileVisitResult;
            }

            /*
             * WARNING - void declaration
             */
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                void var3_3;
                FileVisitResult result = this.fileCollector$1.visitFile(file, attrs);
                Object object = !this.fileCollector$1.wasExcluded(file) ? Files.copy(file, this.newPath(file), (CopyOption[])this.copyOptions$1.toArray(ClassTag$.MODULE$.apply(CopyOption.class))) : BoxedUnit.UNIT;
                return var3_3;
            }
            {
                this.destination$1 = destination$1;
                this.from$1 = from$1;
                this.fileCollector$1 = fileCollector$1;
                this.copyOptions$1 = copyOptions$1;
            }
        }) : Files.copy(from.path(), destination.path(), (CopyOption[])copyOptions.toArray(ClassTag$.MODULE$.apply(CopyOption.class)));
        this.excludedPaths().addAll(fileCollector.excludedPaths());
        return destination;
    }

    private Seq<CopyOption> copyTo$default$4(File from, File destination, Config config) {
        return File.CopyOptions$.MODULE$.apply(false);
    }

    public File copyToDirectory(File from, File directory, Config config, Seq<CopyOption> copyOptions) {
        return this.copyTo(from, directory.$div(from.name()), config, copyOptions);
    }

    public Seq<CopyOption> copyToDirectory$default$4(File from, File directory, Config config) {
        return File.CopyOptions$.MODULE$.default();
    }

    public Seq<String> readLinesInFile(Path path) {
        return EmScriptenCleaner$.MODULE$.clean((Seq<String>)IOUtils$.MODULE$.readLinesInFile(path));
    }

    public Map<Object, String> contentMapFromFile(Path path) {
        return ((IterableOnceOps)((IterableOps)this.readLinesInFile(path).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String line = (String)tuple2._1();
            int lineNumber = tuple2._2$mcI$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)lineNumber)), (Object)line);
            return tuple22;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Tuple2<SortedMap<Object, Object>, SortedMap<Object, Object>> positionLookupTables(String source) {
        int position;
        TreeMap positionToLineNumber = TreeMap$.MODULE$.empty((Ordering)Ordering.Int$.MODULE$);
        TreeMap positionToFirstPositionInLine = TreeMap$.MODULE$.empty((Ordering)Ordering.Int$.MODULE$);
        char[] data = source.toCharArray();
        int lineNumber = 1;
        int firstPositionInLine = 0;
        for (position = 0; position < data.length; ++position) {
            boolean isNewLine;
            boolean bl = isNewLine = data[position] == '\n';
            if (!isNewLine) continue;
            positionToLineNumber.put((Object)BoxesRunTime.boxToInteger((int)position), (Object)BoxesRunTime.boxToInteger((int)lineNumber));
            ++lineNumber;
            positionToFirstPositionInLine.put((Object)BoxesRunTime.boxToInteger((int)position), (Object)BoxesRunTime.boxToInteger((int)firstPositionInLine));
            firstPositionInLine = position + 1;
        }
        positionToLineNumber.put((Object)BoxesRunTime.boxToInteger((int)position), (Object)BoxesRunTime.boxToInteger((int)lineNumber));
        positionToFirstPositionInLine.put((Object)BoxesRunTime.boxToInteger((int)position), (Object)BoxesRunTime.boxToInteger((int)firstPositionInLine));
        return new Tuple2((Object)positionToLineNumber, (Object)positionToFirstPositionInLine);
    }

    public FileUtils.FileStatistics fileStatistics(Seq<String> lines) {
        LongRef linesOfCode = LongRef.create((long)0L);
        IntRef longestLineLength = IntRef.create((int)0);
        BooleanRef containsMarker = BooleanRef.create((boolean)false);
        lines.foreach((Function1 & Serializable)line -> {
            FileUtils$.$anonfun$fileStatistics$1(longestLineLength, containsMarker, linesOfCode, line);
            return BoxedUnit.UNIT;
        });
        return new FileUtils.FileStatistics(linesOfCode.elem, longestLineLength.elem, containsMarker.elem);
    }

    public static final /* synthetic */ void $anonfun$md5$3(MessageDigest md$1, Path path) {
        DigestInputStream dis = new DigestInputStream(Files.newInputStream(path, new OpenOption[0]), md$1);
        while (dis.available() > 0) {
            dis.read();
        }
        dis.close();
    }

    public static final /* synthetic */ String $anonfun$md5$4(byte b) {
        return String.format("%02x", BoxesRunTime.boxToByte((byte)b));
    }

    public static final /* synthetic */ void $anonfun$logAndClearExcludedPaths$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path path = (Path)tuple2._1();
        String reason = (String)tuple2._2();
        MODULE$.logger().debug(new StringBuilder(15).append("Excluded '").append(path).append("' (").append(reason).append(").").toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$fileStatistics$1(IntRef longestLineLength$1, BooleanRef containsMarker$1, LongRef linesOfCode$1, String line) {
        int currLength = line.length();
        if (currLength > longestLineLength$1.elem) {
            longestLineLength$1.elem = currLength;
        }
        if (!containsMarker$1.elem && FileDefaults$.MODULE$.EMSCRIPTEN_START_FUNCS().matches((CharSequence)line)) {
            containsMarker$1.elem = true;
        }
        ++linesOfCode$1.elem;
    }

    private FileUtils$() {
    }
}

