package overflowdb;

import java.util.Iterator;
import java.util.Map;

public abstract class Node extends Element {

  /**
   * Add an outgoing edge to the node with provided label and edge properties as key/value pairs.
   * These key/values must be provided in an even number where the odd numbered arguments are {@link String}
   * property keys and the even numbered arguments are the related property values.
   */
  public abstract Edge addEdge(String label, Node inNode, Object... keyValues);

  /**
   * Add an outgoing edge to the node with provided label and edge properties as key/value pairs.
   */
  public abstract Edge addEdge(String label, Node inNode, Map<String, Object> keyValues);

  /**
   * Add an outgoing edge to the node with provided label and edge properties as key/value pairs.
   * These key/values must be provided in an even number where the odd numbered arguments are {@link String}
   * property keys and the even numbered arguments are the related property values.
   * Just like {{{addEdge2}}, but doesn't instantiate and return a dummy edge
   */
  public abstract void addEdgeSilent(String label, Node inNode, Object... keyValues);

  /**
   * Add an outgoing edge to the node with provided label and edge properties as key/value pairs.
   * Just like {{{addEdge2}}, but doesn't instantiate and return a dummy edge
   */
  public abstract void addEdgeSilent(String label, Node inNode, Map<String, Object> keyValues);

  public abstract long id();

  /* adjacent OUT nodes (all labels) */
  public abstract Iterator<Node> out();

  /* adjacent OUT nodes for given labels */
  public abstract Iterator<Node> out(String... edgeLabels);

  /* adjacent IN nodes (all labels) */
  public abstract Iterator<Node> in();

  /* adjacent IN nodes for given labels */
  public abstract Iterator<Node> in(String... edgeLabels);

  /* adjacent OUT/IN nodes (all labels) */
  public abstract Iterator<Node> both();

  /* adjacent OUT/IN nodes for given labels */
  public abstract Iterator<Node> both(String... edgeLabels);

  /* adjacent OUT edges (all labels) */
  public abstract Iterator<Edge> outE();

  /* adjacent OUT edges for given labels */
  public abstract Iterator<Edge> outE(String... edgeLabels);

  /* adjacent IN edges (all labels) */
  public abstract Iterator<Edge> inE();

  /* adjacent IN edges for given labels */
  public abstract Iterator<Edge> inE(String... edgeLabels);

  /* adjacent OUT/IN edges (all labels) */
  public abstract Iterator<Edge> bothE();

  /* adjacent OUT/IN edges for given labels */
  public abstract Iterator<Edge> bothE(String... edgeLabels);
}
