/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.cpgloading;

import io.shiftleft.cpgloading.ProtoToCpgBase;
import io.shiftleft.cpgloading.ZipArchive;
import io.shiftleft.proto.cpg.Cpg;
import io.shiftleft.queryprimitives.steps.starters.Cpg;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProtoCpgLoader {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected final ProtoToCpgBase builder;

    public ProtoCpgLoader(ProtoToCpgBase builder) {
        this.builder = builder;
    }

    public Cpg loadFromProtoZip(String filename) {
        File tempDir = null;
        try {
            tempDir = Files.createTempDirectory("cpg2sp_proto", new FileAttribute[0]).toFile();
            String tempDirPathName = tempDir.getAbsolutePath();
            long start = System.currentTimeMillis();
            new ZipArchive(filename).unzip(tempDirPathName);
            this.logger.info("Unzipping completed in " + (System.currentTimeMillis() - start) + "ms.");
            start = System.currentTimeMillis();
            Cpg cpg = this.loadFromProtobufDirectory(tempDirPathName);
            this.logger.info("CPG construction finished in " + (System.currentTimeMillis() - start) + "ms.");
            Cpg cpg2 = cpg;
            return cpg2;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                if (tempDir != null) {
                    FileUtils.deleteDirectory((File)tempDir);
                }
            }
            catch (IOException exception) {
                this.logger.warn("Unable to remove temporary directory: " + tempDir);
            }
        }
    }

    public Cpg loadFromProtobufDirectory(String inputDirectory) throws IOException {
        FileInputStream inputStream;
        assert (new File(inputDirectory).isDirectory());
        for (File file : this.getFilesInDirectory(inputDirectory)) {
            inputStream = new FileInputStream(file);
            this.consumeInputStreamNodes(inputStream);
            inputStream.close();
        }
        for (File file : this.getFilesInDirectory(inputDirectory)) {
            inputStream = new FileInputStream(file);
            Cpg.CpgStruct cpgStruct = this.getNextProtoCpgFromStream(inputStream);
            this.builder.addEdges(cpgStruct.getEdgeList());
            inputStream.close();
        }
        return this.builder.build();
    }

    public Cpg loadFromInputStream(InputStream inputStream) throws IOException {
        try {
            Cpg.CpgStruct cpgStruct = this.consumeInputStreamNodes(inputStream);
            this.builder.addEdges(cpgStruct.getEdgeList());
        }
        finally {
            this.closeProtoStream(inputStream);
        }
        return this.builder.build();
    }

    private List<File> getFilesInDirectory(String inputDirectory) {
        File directory = new File(inputDirectory);
        File[] files = directory.listFiles();
        return Arrays.stream(files).filter(file -> file.isFile()).collect(Collectors.toList());
    }

    private Cpg.CpgStruct consumeInputStreamNodes(InputStream inputStream) throws IOException {
        Cpg.CpgStruct cpgStruct = this.getNextProtoCpgFromStream(inputStream);
        this.builder.addNodes(cpgStruct);
        return cpgStruct;
    }

    public Cpg loadFromListOfProtos(List<Cpg.CpgStruct> cpgs) {
        for (Cpg.CpgStruct cpgStruct : cpgs) {
            this.builder.addNodes(cpgStruct);
        }
        for (Cpg.CpgStruct cpgStruct : cpgs) {
            this.builder.addEdges(cpgStruct.getEdgeList());
        }
        return this.builder.build();
    }

    private Cpg.CpgStruct getNextProtoCpgFromStream(InputStream inputStream) throws IOException {
        return Cpg.CpgStruct.parseFrom((InputStream)inputStream);
    }

    private void closeProtoStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }
}

