/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.cpgloading;

import io.shiftleft.proto.cpg.Cpg;
import io.shiftleft.queryprimitives.steps.starters.Cpg;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public abstract class ProtoToCpgBase {
    protected Graph graph;
    protected Logger logger = LogManager.getLogger(this.getClass());
    protected Map<Long, Object> keyToVertexId = new HashMap<Long, Object>();
    protected int elementImportCounter = 0;
    protected long lastStart = System.currentTimeMillis();

    public ProtoToCpgBase(Graph graph) {
        this.graph = graph;
        this.configureGraph(graph);
    }

    public abstract void addNodes(Cpg.CpgStruct var1);

    protected void configureGraph(Graph graph) {
    }

    public void addEdges(List<Cpg.CpgStruct.Edge> protoEdges) {
        for (Cpg.CpgStruct.Edge protoEdge : protoEdges) {
            Edge edge;
            ++this.elementImportCounter;
            long srcNodeId = protoEdge.getSrc();
            long dstNodeId = protoEdge.getDst();
            Vertex srcVertex = this.lookupNodeByKey(srcNodeId);
            Vertex dstVertex = this.lookupNodeByKey(dstNodeId);
            try {
                edge = srcVertex.addEdge(protoEdge.getType().name(), dstVertex, new Object[0]);
            }
            catch (IllegalArgumentException exception) {
                this.logger.warn("Failed to insert an edge", (Throwable)exception);
                continue;
            }
            for (Cpg.CpgStruct.Edge.Property property : protoEdge.getPropertyList()) {
                this.addPropertyToElement((Element)edge, property.getName().name(), property.getValue());
            }
        }
    }

    protected Vertex lookupNodeByKey(Long nodeKey) {
        Object id = this.keyToVertexId.get(nodeKey);
        Iterator iter = this.graph.vertices(new Object[]{id});
        if (!iter.hasNext()) {
            this.logger.error("unable to find node with key=" + nodeKey + " and id=" + id);
            return null;
        }
        return (Vertex)iter.next();
    }

    protected void addPropertyToElement(Element tinkerElement, String propertyName, Cpg.PropertyValue propertyValue) {
        Cpg.PropertyValue.ValueCase valueCase = propertyValue.getValueCase();
        switch (valueCase) {
            case INT_VALUE: {
                tinkerElement.property(propertyName, (Object)propertyValue.getIntValue());
                break;
            }
            case STRING_VALUE: {
                tinkerElement.property(propertyName, (Object)propertyValue.getStringValue());
                break;
            }
            case BOOL_VALUE: {
                tinkerElement.property(propertyName, (Object)propertyValue.getBoolValue());
                break;
            }
            case STRING_LIST: {
                if (tinkerElement instanceof Vertex) {
                    propertyValue.getStringList().getValuesList().forEach(value -> ((Vertex)tinkerElement).property(VertexProperty.Cardinality.list, propertyName, value, new Object[0]));
                    break;
                }
                LinkedList propertyList = new LinkedList();
                propertyList.addAll(propertyValue.getStringList().getValuesList());
                tinkerElement.property(propertyName, propertyList);
                break;
            }
            case VALUE_NOT_SET: {
                break;
            }
            default: {
                throw new RuntimeException("Error: unsupported property case: " + valueCase.name());
            }
        }
    }

    public Cpg build() {
        this.commit();
        return new Cpg(this.graph);
    }

    public void commit() {
        if (this.graph.features().graph().supportsTransactions()) {
            System.out.println("committing tx");
            this.graph.tx().commit();
        }
    }
}

