/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.cpgloading;

import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class ZipArchive {
    private String inputFile;

    ZipArchive(String inputFile) {
        this.inputFile = inputFile;
    }

    public void unzip(final String outputDirectory) throws IOException {
        if (Files.notExists(Paths.get(outputDirectory, new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(outputDirectory, new String[0]), new FileAttribute[0]);
        }
        try (FileSystem zipFileSystem = FileSystems.newFileSystem(Paths.get(this.inputFile, new String[0]), null);){
            Path root = zipFileSystem.getRootDirectories().iterator().next();
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path destFile = Paths.get(outputDirectory.toString(), file.toString());
                    try {
                        Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (DirectoryNotEmptyException directoryNotEmptyException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

