/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.process.traversal.step.sideEffect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class TinkerGraphStep<S, E extends Element>
extends GraphStep<S, E>
implements HasContainerHolder {
    private final List<HasContainer> hasContainers = new ArrayList<HasContainer>();

    public TinkerGraphStep(GraphStep<S, E> originalGraphStep) {
        super(originalGraphStep.getTraversal(), originalGraphStep.getReturnClass(), originalGraphStep.isStartStep(), originalGraphStep.getIds());
        originalGraphStep.getLabels().forEach(arg_0 -> ((TinkerGraphStep)this).addLabel(arg_0));
        this.setIteratorSupplier(() -> Vertex.class.isAssignableFrom(this.returnClass) ? this.vertices() : this.edges());
    }

    private Iterator<? extends Edge> edges() {
        TinkerGraph graph = (TinkerGraph)this.getTraversal().getGraph().get();
        HasContainer indexedContainer = this.getIndexKey(Edge.class);
        Optional<HasContainer> hasLabelContainer = this.findHasLabelStep();
        if (null == this.ids) {
            return Collections.emptyIterator();
        }
        if (this.ids.length > 0) {
            return this.iteratorList(graph.edges(this.ids));
        }
        if (graph.ondiskOverflowEnabled && hasLabelContainer.isPresent()) {
            return graph.edgesByLabel((P<String>)hasLabelContainer.get().getPredicate());
        }
        return null == indexedContainer ? this.iteratorList(graph.edges(new Object[0])) : TinkerHelper.queryEdgeIndex(graph, indexedContainer.getKey(), indexedContainer.getPredicate().getValue()).stream().filter(edge -> HasContainer.testAll((Element)edge, this.hasContainers)).collect(Collectors.toList()).iterator();
    }

    private Iterator<? extends Vertex> vertices() {
        TinkerGraph graph = (TinkerGraph)this.getTraversal().getGraph().get();
        HasContainer indexedContainer = this.getIndexKey(Vertex.class);
        Optional<HasContainer> hasLabelContainer = this.findHasLabelStep();
        if (null == this.ids) {
            return Collections.emptyIterator();
        }
        if (this.ids.length > 0) {
            return this.iteratorList(graph.vertices(this.ids));
        }
        if (graph.ondiskOverflowEnabled && hasLabelContainer.isPresent()) {
            return graph.verticesByLabel((P<String>)hasLabelContainer.get().getPredicate());
        }
        return null == indexedContainer ? this.iteratorList(graph.vertices(new Object[0])) : IteratorUtils.filter(TinkerHelper.queryVertexIndex(graph, indexedContainer.getKey(), indexedContainer.getPredicate().getValue()).iterator(), vertex -> HasContainer.testAll((Element)vertex, this.hasContainers));
    }

    private Optional<HasContainer> findHasLabelStep() {
        if (this.hasContainers.size() == 1 && T.label.getAccessor().equals(this.hasContainers.get(0).getKey())) {
            return Optional.of(this.hasContainers.get(0));
        }
        return Optional.empty();
    }

    private HasContainer getIndexKey(Class<? extends Element> indexedClass) {
        Set<String> indexedKeys = ((TinkerGraph)this.getTraversal().getGraph().get()).getIndexedKeys(indexedClass);
        Iterator itty = IteratorUtils.filter(this.hasContainers.iterator(), c -> c.getPredicate().getBiPredicate() == Compare.eq && indexedKeys.contains(c.getKey()));
        return itty.hasNext() ? (HasContainer)itty.next() : null;
    }

    public String toString() {
        if (this.hasContainers.isEmpty()) {
            return super.toString();
        }
        return 0 == this.ids.length ? StringFactory.stepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName().toLowerCase(), this.hasContainers}) : StringFactory.stepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName().toLowerCase(), Arrays.toString(this.ids), this.hasContainers});
    }

    private <E extends Element> Iterator<E> iteratorList(Iterator<E> iterator) {
        ArrayList<Element> list = new ArrayList<Element>();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            if (!HasContainer.testAll((Element)e, this.hasContainers)) continue;
            list.add(e);
        }
        return list.iterator();
    }

    public List<HasContainer> getHasContainers() {
        return Collections.unmodifiableList(this.hasContainers);
    }

    public void addHasContainer(HasContainer hasContainer) {
        if (hasContainer.getPredicate() instanceof AndP) {
            for (P predicate : ((AndP)hasContainer.getPredicate()).getPredicates()) {
                this.addHasContainer(new HasContainer(hasContainer.getKey(), predicate));
            }
        } else {
            this.hasContainers.add(hasContainer);
        }
    }

    public int hashCode() {
        return super.hashCode() ^ this.hasContainers.hashCode();
    }
}

