/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.storage;

import java.io.IOException;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.storage.Serializer;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.SpecializedElementFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.SpecializedTinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.VertexRef;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeSerializer
extends Serializer<Edge> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final TinkerGraph graph;
    protected final Map<String, SpecializedElementFactory.ForEdge> edgeFactoryByLabel;
    private int serializedCount = 0;
    private int deserializedCount = 0;

    public EdgeSerializer(TinkerGraph graph, Map<String, SpecializedElementFactory.ForEdge> edgeFactoryByLabel) {
        this.graph = graph;
        this.edgeFactoryByLabel = edgeFactoryByLabel;
    }

    @Override
    public byte[] serialize(Edge edge) throws IOException {
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        packer.packLong(((Long)edge.id()).longValue());
        packer.packString(edge.label());
        this.packProperties(packer, edge.properties(new String[0]));
        packer.packLong(((Long)edge.outVertex().id()).longValue());
        packer.packString(edge.outVertex().label());
        packer.packLong(((Long)edge.inVertex().id()).longValue());
        packer.packString(edge.inVertex().label());
        ++this.serializedCount;
        if (this.serializedCount % 100000 == 0) {
            this.logger.debug("stats: serialized " + this.serializedCount + " edges in total");
        }
        return packer.toByteArray();
    }

    @Override
    public TinkerEdge deserialize(byte[] bytes) throws IOException {
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bytes);
        Long id = unpacker.unpackLong();
        String label = unpacker.unpackString();
        Object[] keyValues = this.unpackProperties(unpacker.unpackValue().asMapValue().map());
        long outVertexId = unpacker.unpackLong();
        String outVertexLabel = unpacker.unpackString();
        long inVertexId = unpacker.unpackLong();
        String inVertexLabel = unpacker.unpackString();
        VertexRef outVertexRef = (VertexRef)this.graph.vertex(outVertexId);
        VertexRef inVertexRef = (VertexRef)this.graph.vertex(inVertexId);
        Object edge = this.edgeFactoryByLabel.get(label).createEdge(id, this.graph, outVertexRef, inVertexRef);
        ElementHelper.attachProperties(edge, (Object[])keyValues);
        ((SpecializedTinkerEdge)edge).setModifiedSinceLastSerialization(false);
        ++this.deserializedCount;
        if (this.deserializedCount % 100000 == 0) {
            this.logger.debug("stats: deserialized " + this.deserializedCount + " edges in total");
        }
        return edge;
    }
}

