/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.storage;

import java.io.File;
import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.storage.EdgeSerializer;
import org.apache.tinkerpop.gremlin.tinkergraph.storage.VertexSerializer;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OndiskOverflow {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final VertexSerializer vertexSerializer;
    protected final EdgeSerializer edgeSerializer;
    private final MVStore vertexMVStore;
    private final MVStore edgeMVStore;
    protected final MVMap<Long, byte[]> vertexMVMap;
    protected final MVMap<Long, byte[]> edgeMVMap;
    private boolean closed;

    public OndiskOverflow(String ondiskOverflowRootDir, VertexSerializer vertexSerializer, EdgeSerializer edgeSerializer) {
        File mvstoreEdgesFile;
        File mvstoreVerticesFile;
        this.vertexSerializer = vertexSerializer;
        this.edgeSerializer = edgeSerializer;
        try {
            File cacheParentDir = ondiskOverflowRootDir != null ? new File(ondiskOverflowRootDir) : null;
            mvstoreVerticesFile = File.createTempFile("vertexMVStore", ".bin", cacheParentDir);
            mvstoreEdgesFile = File.createTempFile("edgeMVStore", ".bin", cacheParentDir);
            mvstoreVerticesFile.deleteOnExit();
            mvstoreEdgesFile.deleteOnExit();
            this.logger.debug("on-disk cache overflow files: " + mvstoreVerticesFile + ", " + mvstoreEdgesFile);
        }
        catch (IOException e) {
            throw new RuntimeException("cannot create tmp file for mvstore", e);
        }
        this.vertexMVStore = new MVStore.Builder().fileName(mvstoreVerticesFile.getAbsolutePath()).open();
        this.edgeMVStore = new MVStore.Builder().fileName(mvstoreEdgesFile.getAbsolutePath()).open();
        this.vertexMVMap = this.vertexMVStore.openMap("vertices");
        this.edgeMVMap = this.edgeMVStore.openMap("edges");
    }

    public void persist(TinkerElement element) throws IOException {
        if (!this.closed) {
            Long id = (Long)element.id();
            if (element instanceof Vertex) {
                this.vertexMVMap.put((Object)id, (Object)this.vertexSerializer.serialize((Vertex)element));
            } else if (element instanceof Edge) {
                this.edgeMVMap.put((Object)id, (Object)this.edgeSerializer.serialize((Edge)element));
            } else {
                new RuntimeException("unable to serialize " + element + " of type " + element.getClass());
            }
        }
    }

    public <A extends TinkerVertex> A readVertex(long id) throws IOException {
        return (A)this.vertexSerializer.deserialize((byte[])this.vertexMVMap.get((Object)id));
    }

    public <A extends TinkerEdge> A readEdge(long id) throws IOException {
        return (A)this.edgeSerializer.deserialize((byte[])this.edgeMVMap.get((Object)id));
    }

    public void close() {
        this.closed = true;
        this.vertexMVStore.close();
        this.edgeMVStore.close();
    }

    public void removeVertex(Long id) {
        this.vertexMVMap.remove((Object)id);
    }

    public void removeEdge(Long id) {
        this.edgeMVMap.remove((Object)id);
    }
}

