/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.storage;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;

public abstract class Serializer<A extends Element> {
    public abstract byte[] serialize(A var1) throws IOException;

    public abstract A deserialize(byte[] var1) throws IOException;

    protected void packProperties(MessageBufferPacker packer, Map<String, Object> properties) throws IOException {
        packer.packMapHeader(properties.size());
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            packer.packString(property.getKey());
            Object value = property.getValue();
            packer.packArrayHeader(2);
            if (value.getClass() == Boolean.class) {
                packer.packShort((short)1);
                packer.packBoolean(((Boolean)value).booleanValue());
                continue;
            }
            if (value.getClass() == String.class) {
                packer.packShort((short)2);
                packer.packString((String)value);
                continue;
            }
            if (value.getClass() == Byte.class) {
                packer.packShort((short)3);
                packer.packByte(((Byte)value).byteValue());
                continue;
            }
            if (value.getClass() == Short.class) {
                packer.packShort((short)4);
                packer.packShort(((Short)value).shortValue());
                continue;
            }
            if (value.getClass() == Integer.class) {
                packer.packShort((short)5);
                packer.packInt(((Integer)value).intValue());
                continue;
            }
            if (value.getClass() == Long.class) {
                packer.packShort((short)6);
                packer.packLong(((Long)value).longValue());
                continue;
            }
            if (value.getClass() == Float.class) {
                packer.packShort((short)7);
                packer.packFloat(((Float)value).floatValue());
                continue;
            }
            if (value.getClass() == Double.class) {
                packer.packShort((short)8);
                packer.packDouble(((Double)value).doubleValue());
                continue;
            }
            if (value.getClass() == int[].class) continue;
            throw new NotImplementedException("value type `" + value.getClass() + "` not yet supported (key=" + property.getKey() + ")");
        }
    }

    protected Object[] unpackProperties(Map<Value, Value> properties) {
        Object[] keyValues = new Object[properties.size() * 2];
        int idx = 0;
        for (Map.Entry<Value, Value> entry : properties.entrySet()) {
            Object value;
            String key = entry.getKey().asStringValue().asString();
            keyValues[idx++] = key;
            ArrayValue typeAndValue = entry.getValue().asArrayValue();
            short type = typeAndValue.get(0).asIntegerValue().asShort();
            Value packedValue = typeAndValue.get(1);
            switch (type) {
                case 1: {
                    value = packedValue.asBooleanValue().getBoolean();
                    break;
                }
                case 2: {
                    value = packedValue.asStringValue().asString();
                    break;
                }
                case 3: {
                    value = packedValue.asIntegerValue().asByte();
                    break;
                }
                case 4: {
                    value = packedValue.asIntegerValue().asShort();
                    break;
                }
                case 5: {
                    value = packedValue.asIntegerValue().asInt();
                    break;
                }
                case 6: {
                    value = packedValue.asIntegerValue().asLong();
                    break;
                }
                case 7: {
                    value = Float.valueOf(packedValue.asFloatValue().toFloat());
                    break;
                }
                case 8: {
                    value = packedValue.asFloatValue().toDouble();
                    break;
                }
                default: {
                    throw new NotImplementedException("type prefix `" + type + "` not yet supported (key=" + key + ", packedValue=" + packedValue + ")");
                }
            }
            keyValues[idx++] = value;
        }
        return keyValues;
    }

    protected void packProperties(MessageBufferPacker packer, Iterator<? extends Property> propertyIterator) throws IOException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.next();
            properties.put(property.key(), property.value());
        }
        this.packProperties(packer, properties);
    }
}

