/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.storage;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.IteratorUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.storage.Serializer;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.SpecializedElementFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.SpecializedTinkerVertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexSerializer
extends Serializer<Vertex> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final TinkerGraph graph;
    protected final Map<String, SpecializedElementFactory.ForVertex> vertexFactoryByLabel;
    private int serializedCount = 0;
    private int deserializedCount = 0;
    private long serializationTimeSpentMillis = 0L;
    private long deserializationTimeSpentMillis = 0L;

    public VertexSerializer(TinkerGraph graph, Map<String, SpecializedElementFactory.ForVertex> vertexFactoryByLabel) {
        this.graph = graph;
        this.vertexFactoryByLabel = vertexFactoryByLabel;
    }

    @Override
    public byte[] serialize(Vertex vertex) throws IOException {
        long start = System.currentTimeMillis();
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        packer.packLong(((Long)vertex.id()).longValue());
        packer.packString(vertex.label());
        if (vertex instanceof SpecializedTinkerVertex) {
            this.packProperties(packer, ((SpecializedTinkerVertex)vertex).valueMap());
        } else {
            this.packProperties(packer, vertex.properties(new String[0]));
        }
        this.packEdgeIds(packer, vertex);
        ++this.serializedCount;
        this.serializationTimeSpentMillis += System.currentTimeMillis() - start;
        if (this.serializedCount % 100000 == 0) {
            float avgSerializationTime = (float)this.serializationTimeSpentMillis / (float)this.serializedCount;
            this.logger.debug("stats: serialized " + this.serializedCount + " vertices in total (avg time: " + avgSerializationTime + "ms)");
        }
        return packer.toByteArray();
    }

    private void packEdgeIds(MessageBufferPacker packer, Vertex vertex) throws IOException {
        for (Direction direction : new Direction[]{Direction.IN, Direction.OUT}) {
            List edges = IteratorUtils.toList((Iterator)vertex.edges(direction, new String[0]));
            Set labels = edges.stream().map(e -> e.label()).collect(Collectors.toSet());
            packer.packMapHeader(labels.size());
            for (String label : labels) {
                packer.packString(label);
                Set edgeIds = edges.stream().filter(e -> e.label().equals(label)).map(e -> (Long)e.id()).collect(Collectors.toSet());
                packer.packArrayHeader(edgeIds.size());
                for (Long edgeId : edgeIds) {
                    packer.packLong(edgeId.longValue());
                }
            }
        }
    }

    @Override
    public TinkerVertex deserialize(byte[] bytes) throws IOException {
        long start = System.currentTimeMillis();
        if (null == bytes) {
            return null;
        }
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bytes);
        Long id = unpacker.unpackLong();
        String label = unpacker.unpackString();
        Object[] keyValues = this.unpackProperties(unpacker.unpackValue().asMapValue().map());
        SpecializedElementFactory.ForVertex vertexFactory = this.vertexFactoryByLabel.get(label);
        if (vertexFactory == null) {
            throw new AssertionError((Object)("vertexFactory not found for id=" + id + ", label=" + label));
        }
        Object vertex = vertexFactory.createVertex(id, this.graph);
        ElementHelper.attachProperties(vertex, (VertexProperty.Cardinality)VertexProperty.Cardinality.list, (Object[])keyValues);
        Map<String, long[]> inEdgeIdsByLabel = this.unpackEdges(unpacker);
        Map<String, long[]> outEdgeIdsByLabel = this.unpackEdges(unpacker);
        inEdgeIdsByLabel.entrySet().stream().forEach(entry -> {
            String edgeLabel = (String)entry.getKey();
            for (long edgeId : (long[])entry.getValue()) {
                vertex.storeInEdge(this.graph.edge(edgeId));
            }
        });
        outEdgeIdsByLabel.entrySet().stream().forEach(entry -> {
            String edgeLabel = (String)entry.getKey();
            for (long edgeId : (long[])entry.getValue()) {
                vertex.storeOutEdge(this.graph.edge(edgeId));
            }
        });
        ((SpecializedTinkerVertex)vertex).setModifiedSinceLastSerialization(false);
        ++this.deserializedCount;
        this.deserializationTimeSpentMillis += System.currentTimeMillis() - start;
        if (this.deserializedCount % 100000 == 0) {
            float avgDeserializationTime = (float)this.deserializationTimeSpentMillis / (float)this.deserializedCount;
            this.logger.debug("stats: deserialized " + this.deserializedCount + " vertices in total (avg time: " + avgDeserializationTime + "ms)");
        }
        return vertex;
    }

    private Map<String, long[]> unpackEdges(MessageUnpacker unpacker) throws IOException {
        int labelCount = unpacker.unpackMapHeader();
        HashMap<String, long[]> edgeIdsByLabel = new HashMap<String, long[]>(labelCount);
        for (int i = 0; i < labelCount; ++i) {
            String label = unpacker.unpackString();
            int edgeIdsCount = unpacker.unpackArrayHeader();
            long[] edgeIds = new long[edgeIdsCount];
            for (int j = 0; j < edgeIdsCount; ++j) {
                edgeIds[j] = unpacker.unpackLong();
            }
            edgeIdsByLabel.put(label, edgeIds);
        }
        return edgeIdsByLabel;
    }
}

