/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.io.IOException;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.ElementRef;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

public class EdgeRef<E extends TinkerEdge>
extends ElementRef<E>
implements Edge {
    public EdgeRef(E edge) {
        super(edge);
    }

    public EdgeRef(long edgeId, String label, TinkerGraph graph) {
        super(edgeId, label, graph);
    }

    @Override
    protected E readFromDisk(long edgeId) throws IOException {
        return (E)this.graph.ondiskOverflow.readEdge(edgeId);
    }

    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }

    public <V> Property<V> property(String key, V value) {
        return ((TinkerEdge)this.get()).property(key, value);
    }

    public Iterator<Vertex> vertices(Direction direction) {
        return ((TinkerEdge)this.get()).vertices(direction);
    }

    public <V> Iterator<Property<V>> properties(String ... propertyKeys) {
        return ((TinkerEdge)this.get()).properties(propertyKeys);
    }
}

