/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

public abstract class ElementRef<E extends TinkerElement>
implements Element {
    public final long id;
    public final String label;
    protected final TinkerGraph graph;
    protected E reference;
    private int serializationCount;
    private long lastDeserializedTime;
    private boolean removed = false;

    public ElementRef(E element) {
        this.id = (Long)((TinkerElement)element).id();
        this.label = ((TinkerElement)element).label();
        this.graph = (TinkerGraph)((TinkerElement)element).graph();
        this.reference = element;
        this.lastDeserializedTime = System.currentTimeMillis();
        this.graph.referenceManager.registerRef(this);
    }

    protected ElementRef(long id, String label, TinkerGraph graph) {
        this.id = id;
        this.label = label;
        this.graph = graph;
    }

    public boolean isSet() {
        return this.reference != null;
    }

    public boolean isCleared() {
        return this.reference == null;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    protected void clear() throws IOException {
        E ref = this.reference;
        if (ref != null) {
            this.graph.ondiskOverflow.persist((TinkerElement)ref);
            ++this.serializationCount;
        }
        this.reference = null;
    }

    public E get() {
        E ref = this.reference;
        if (ref != null) {
            return ref;
        }
        try {
            E element = this.readFromDisk(this.id);
            this.reference = element;
            this.lastDeserializedTime = System.currentTimeMillis();
            this.graph.referenceManager.registerRef(this);
            return element;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getSerializationCount() {
        return this.serializationCount;
    }

    public long getLastDeserializedTime() {
        return this.lastDeserializedTime;
    }

    protected abstract E readFromDisk(long var1) throws IOException;

    public Object id() {
        return this.id;
    }

    public Graph graph() {
        return this.graph;
    }

    public String label() {
        return this.label;
    }

    public void remove() {
        this.removed = true;
        this.get().remove();
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElementRef) {
            return this.id().equals(((ElementRef)obj).id());
        }
        return false;
    }
}

