/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public abstract class SpecializedTinkerEdge
extends TinkerEdge {
    private boolean modifiedSinceLastSerialization = true;
    private Semaphore modificationSemaphore = new Semaphore(1);
    private final Set<String> specificKeys;

    protected SpecializedTinkerEdge(TinkerGraph graph, Long id, Vertex outVertex, String label, Vertex inVertex, Set<String> specificKeys) {
        super(graph, id, outVertex, label, inVertex);
        this.specificKeys = specificKeys;
        if (graph.referenceManager != null) {
            graph.referenceManager.applyBackpressureMaybe();
        }
    }

    @Override
    public Set<String> keys() {
        return this.specificKeys;
    }

    @Override
    public <V> Property<V> property(String key) {
        return this.specificProperty(key);
    }

    protected abstract <V> Property<V> specificProperty(String var1);

    @Override
    public <V> Iterator<Property<V>> properties(String ... propertyKeys) {
        if (propertyKeys.length == 0) {
            return this.specificKeys.stream().map(key -> this.property((String)key)).filter(vp -> vp.isPresent()).iterator();
        }
        if (propertyKeys.length == 1) {
            Property<V> prop = this.property(propertyKeys[0]);
            return prop.isPresent() ? IteratorUtils.of(prop) : Collections.emptyIterator();
        }
        return Arrays.stream(propertyKeys).map(key -> this.property((String)key)).filter(vp -> vp.isPresent()).iterator();
    }

    @Override
    public <V> Property<V> property(String key, V value) {
        if (this.removed) {
            throw SpecializedTinkerEdge.elementAlreadyRemoved(Edge.class, this.id);
        }
        ElementHelper.validateProperty((String)key, value);
        Property oldProperty = super.property(key);
        this.acquireModificationLock();
        this.modifiedSinceLastSerialization = true;
        Property<V> p = this.updateSpecificProperty(key, value);
        TinkerHelper.autoUpdateIndex(this, key, value, oldProperty.isPresent() ? oldProperty.value() : null);
        this.releaseModificationLock();
        return p;
    }

    protected abstract <V> Property<V> updateSpecificProperty(String var1, V var2);

    public void removeProperty(String key) {
        this.acquireModificationLock();
        this.modifiedSinceLastSerialization = true;
        this.removeSpecificProperty(key);
        this.releaseModificationLock();
    }

    protected abstract void removeSpecificProperty(String var1);

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    public void remove() {
        super.remove();
        this.graph.getElementsByLabel(this.graph.edgesByLabel, this.label).remove(this);
        this.modifiedSinceLastSerialization = true;
    }

    public void setModifiedSinceLastSerialization(boolean modifiedSinceLastSerialization) {
        this.modifiedSinceLastSerialization = modifiedSinceLastSerialization;
    }

    public boolean isModifiedSinceLastSerialization() {
        return this.modifiedSinceLastSerialization;
    }

    public void acquireModificationLock() {
        try {
            this.modificationSemaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void releaseModificationLock() {
        this.modificationSemaphore.release();
    }
}

