/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.EdgeRef;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.SpecializedElementFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.SpecializedTinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.VertexRef;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.gremlin.util.iterator.MultiIterator;

public abstract class SpecializedTinkerVertex
extends TinkerVertex {
    protected Map<String, List<Edge>> outEdgesByLabel;
    protected Map<String, List<Edge>> inEdgesByLabel;
    private boolean modifiedSinceLastSerialization = true;
    private Semaphore modificationSemaphore = new Semaphore(1);

    protected abstract Set<String> specificKeys();

    public abstract Set<String> allowedOutEdgeLabels();

    public abstract Set<String> allowedInEdgeLabels();

    protected SpecializedTinkerVertex(long id, String label, TinkerGraph graph) {
        super(id, label, graph);
        if (graph != null && graph.referenceManager != null) {
            graph.referenceManager.applyBackpressureMaybe();
        }
    }

    @Override
    public Set<String> keys() {
        return this.specificKeys();
    }

    @Override
    public <V> VertexProperty<V> property(String key) {
        if (this.removed) {
            return VertexProperty.empty();
        }
        return this.specificProperty(key);
    }

    protected <V> VertexProperty<V> specificProperty(String key) {
        Iterator<VertexProperty<V>> iter = this.specificProperties(key);
        if (iter.hasNext()) {
            return iter.next();
        }
        return VertexProperty.empty();
    }

    protected abstract <V> Iterator<VertexProperty<V>> specificProperties(String var1);

    public abstract Map<String, Object> valueMap();

    @Override
    public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
        if (this.removed) {
            return Collections.emptyIterator();
        }
        if (propertyKeys.length == 0) {
            return this.specificKeys().stream().flatMap(key -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.specificProperties((String)key), 16), false)).iterator();
        }
        if (propertyKeys.length == 1) {
            return this.specificProperties(propertyKeys[0]);
        }
        return Arrays.stream(propertyKeys).flatMap(key -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.specificProperties((String)key), 16), false)).iterator();
    }

    @Override
    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        if (this.removed) {
            throw SpecializedTinkerVertex.elementAlreadyRemoved(Vertex.class, this.id);
        }
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        ElementHelper.validateProperty((String)key, value);
        this.acquireModificationLock();
        this.modifiedSinceLastSerialization = true;
        VertexProperty<V> vp = this.updateSpecificProperty(cardinality, key, value);
        TinkerHelper.autoUpdateIndex(this, key, value, null);
        this.releaseModificationLock();
        return vp;
    }

    protected abstract <V> VertexProperty<V> updateSpecificProperty(VertexProperty.Cardinality var1, String var2, V var3);

    public void removeProperty(String key) {
        this.acquireModificationLock();
        this.modifiedSinceLastSerialization = true;
        this.removeSpecificProperty(key);
        this.releaseModificationLock();
    }

    protected abstract void removeSpecificProperty(String var1);

    @Override
    public Edge addEdge(String label, Vertex inVertex, Object ... keyValues) {
        if (null == inVertex) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"inVertex");
        }
        VertexRef inVertexRef = null;
        if (inVertex instanceof VertexRef) {
            inVertexRef = (VertexRef)inVertex;
            inVertex = (Vertex)inVertexRef.get();
        }
        if (this.removed) {
            throw SpecializedTinkerVertex.elementAlreadyRemoved(Vertex.class, this.id);
        }
        if (!this.allowedOutEdgeLabels().contains(label)) {
            throw new IllegalArgumentException(this.getClass().getName() + " doesn't allow outgoing edges with label=" + label);
        }
        if (!((SpecializedTinkerVertex)inVertex).allowedInEdgeLabels().contains(label)) {
            throw new IllegalArgumentException(inVertex.getClass().getName() + " doesn't allow incoming edges with label=" + label);
        }
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        if (this.graph.specializedEdgeFactoryByLabel.containsKey(label)) {
            SpecializedElementFactory.ForEdge factory = this.graph.specializedEdgeFactoryByLabel.get(label);
            Long idValue = (Long)this.graph.edgeIdManager.convert(ElementHelper.getIdValue((Object[])keyValues).orElse(null));
            if (null != idValue) {
                if (this.graph.edges.containsKey(idValue)) {
                    throw Graph.Exceptions.edgeWithIdAlreadyExists((Object)idValue);
                }
            } else {
                idValue = (Long)this.graph.edgeIdManager.getNextId(this.graph);
            }
            this.graph.currentId.set(Long.max(idValue, this.graph.currentId.get()));
            VertexRef outVertexRef = (VertexRef)this.graph.vertices.get(this.id);
            EdgeRef edge = this.graph.ondiskOverflowEnabled ? factory.createEdgeRef(idValue, this.graph, outVertexRef, inVertexRef) : factory.createEdge(idValue, this.graph, outVertexRef, inVertexRef);
            ElementHelper.attachProperties(edge, (Object[])keyValues);
            this.graph.edges.put(edge.id(), edge);
            this.graph.getElementsByLabel(this.graph.edgesByLabel, label).add(edge);
            this.storeOutEdge(edge);
            ((SpecializedTinkerVertex)inVertex).storeInEdge(edge);
            this.modifiedSinceLastSerialization = true;
            return edge;
        }
        if (this.graph.usesSpecializedElements) {
            throw new IllegalArgumentException("this instance of TinkerGraph uses specialized elements, but doesn't have a factory for label " + label + ". Mixing specialized and generic elements is not (yet) supported");
        }
        return super.addEdge(label, inVertex, keyValues);
    }

    public void storeOutEdge(Edge edge) {
        this.storeEdge(edge, this.getOutEdgesByLabel());
    }

    public void storeInEdge(Edge edge) {
        this.storeEdge(edge, this.getInEdgesByLabel());
    }

    private void storeEdge(Edge edge, Map<String, List<Edge>> edgesByLabel) {
        if (!edgesByLabel.containsKey(edge.label())) {
            edgesByLabel.put(edge.label(), new ArrayList());
        }
        edgesByLabel.get(edge.label()).add(edge);
    }

    @Override
    public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
        MultiIterator multiIterator = new MultiIterator();
        if (edgeLabels.length == 0) {
            if (direction == Direction.OUT || direction == Direction.BOTH) {
                this.getOutEdgesByLabel().values().forEach(edges -> multiIterator.addIterator(edges.iterator()));
            }
            if (direction == Direction.IN || direction == Direction.BOTH) {
                this.getInEdgesByLabel().values().forEach(edges -> multiIterator.addIterator(edges.iterator()));
            }
        } else {
            for (String label : edgeLabels) {
                if (direction == Direction.OUT || direction == Direction.BOTH) {
                    multiIterator.addIterator(this.getOutEdgesByLabel(label).iterator());
                }
                if (direction != Direction.IN && direction != Direction.BOTH) continue;
                multiIterator.addIterator(this.getInEdgesByLabel(label).iterator());
            }
        }
        return multiIterator;
    }

    @Override
    public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
        Iterator<Edge> edges = this.edges(direction, edgeLabels);
        if (direction == Direction.IN) {
            return IteratorUtils.map(edges, Edge::outVertex);
        }
        if (direction == Direction.OUT) {
            return IteratorUtils.map(edges, Edge::inVertex);
        }
        if (direction == Direction.BOTH) {
            return IteratorUtils.concat((Iterator[])new Iterator[]{this.vertices(Direction.IN, edgeLabels), this.vertices(Direction.OUT, edgeLabels)});
        }
        return Collections.emptyIterator();
    }

    protected Map<String, List<Edge>> getOutEdgesByLabel() {
        if (this.outEdgesByLabel == null) {
            this.outEdgesByLabel = new THashMap();
        }
        return this.outEdgesByLabel;
    }

    protected Map<String, List<Edge>> getInEdgesByLabel() {
        if (this.inEdgesByLabel == null) {
            this.inEdgesByLabel = new THashMap();
        }
        return this.inEdgesByLabel;
    }

    protected List<Edge> getOutEdgesByLabel(String label) {
        return this.getOutEdgesByLabel().getOrDefault(label, new ArrayList());
    }

    protected List<Edge> getInEdgesByLabel(String label) {
        return this.getInEdgesByLabel().getOrDefault(label, new ArrayList());
    }

    protected <E extends SpecializedTinkerEdge> List<E> specializedEdges(Direction direction, String label) {
        Map<String, List<Edge>> edgesByLabel;
        if (direction == Direction.OUT) {
            edgesByLabel = this.getOutEdgesByLabel();
        } else if (direction == Direction.IN) {
            edgesByLabel = this.getInEdgesByLabel();
        } else {
            throw new IllegalArgumentException("not implemented");
        }
        return edgesByLabel.get(label).stream().map(edge -> {
            if (edge instanceof EdgeRef) {
                edge = (Edge)((EdgeRef)edge).get();
            }
            return (SpecializedTinkerEdge)edge;
        }).collect(Collectors.toList());
    }

    @Override
    public void remove() {
        super.remove();
        this.graph.getElementsByLabel(this.graph.verticesByLabel, this.label).remove(this);
        this.modifiedSinceLastSerialization = true;
    }

    public void setModifiedSinceLastSerialization(boolean modifiedSinceLastSerialization) {
        this.modifiedSinceLastSerialization = modifiedSinceLastSerialization;
    }

    public void acquireModificationLock() {
        try {
            this.modificationSemaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void releaseModificationLock() {
        this.modificationSemaphore.release();
    }
}

