/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

public abstract class TinkerElement
implements Element {
    protected final Object id;
    protected final String label;
    protected final TinkerGraph graph;
    protected boolean removed = false;

    protected TinkerElement(Object id, String label, TinkerGraph graph) {
        this.id = id;
        this.label = label;
        this.graph = graph;
    }

    public Graph graph() {
        return this.graph;
    }

    public TinkerGraph tinkerGraph() {
        return this.graph;
    }

    public int hashCode() {
        return ElementHelper.hashCode((Element)this);
    }

    public Object id() {
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual((Element)this, (Object)object);
    }

    protected static IllegalStateException elementAlreadyRemoved(Class<? extends Element> clazz, Object id) {
        return new IllegalStateException(String.format("%s with id %s was removed.", clazz.getSimpleName(), id));
    }

    public boolean isRemoved() {
        return this.removed;
    }
}

