/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoVersion;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphComputer;
import org.apache.tinkerpop.gremlin.tinkergraph.process.computer.TinkerGraphComputerView;
import org.apache.tinkerpop.gremlin.tinkergraph.process.traversal.strategy.optimization.TinkerGraphCountStrategy;
import org.apache.tinkerpop.gremlin.tinkergraph.process.traversal.strategy.optimization.TinkerGraphStepStrategy;
import org.apache.tinkerpop.gremlin.tinkergraph.storage.EdgeSerializer;
import org.apache.tinkerpop.gremlin.tinkergraph.storage.OndiskOverflow;
import org.apache.tinkerpop.gremlin.tinkergraph.storage.SerializationStats;
import org.apache.tinkerpop.gremlin.tinkergraph.storage.VertexSerializer;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.ElementRef;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.ReferenceManager;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.SpecializedElementFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraphVariables;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIndex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIoRegistryV1d0;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIoRegistryV2d0;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIoRegistryV3d0;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.gremlin.util.iterator.MultiIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Graph.OptIns(value={@Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureIntegrateSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessStandardSuite")})
public final class TinkerGraph
implements Graph {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String GREMLIN_TINKERGRAPH_VERTEX_ID_MANAGER = "gremlin.tinkergraph.vertexIdManager";
    public static final String GREMLIN_TINKERGRAPH_EDGE_ID_MANAGER = "gremlin.tinkergraph.edgeIdManager";
    public static final String GREMLIN_TINKERGRAPH_VERTEX_PROPERTY_ID_MANAGER = "gremlin.tinkergraph.vertexPropertyIdManager";
    public static final String GREMLIN_TINKERGRAPH_DEFAULT_VERTEX_PROPERTY_CARDINALITY = "gremlin.tinkergraph.defaultVertexPropertyCardinality";
    public static final String GREMLIN_TINKERGRAPH_GRAPH_LOCATION = "gremlin.tinkergraph.graphLocation";
    public static final String GREMLIN_TINKERGRAPH_GRAPH_FORMAT = "gremlin.tinkergraph.graphFormat";
    public static final String GREMLIN_TINKERGRAPH_ONDISK_OVERFLOW_ENABLED = "gremlin.tinkergraph.ondiskOverflow.enabled";
    public static final String GREMLIN_TINKERGRAPH_ONDISK_ROOT_DIR = "gremlin.tinkergraph.ondiskOverflow.rootDir";
    public static final String GREMLIN_TINKERGRAPH_OVERFLOW_HEAP_PERCENTAGE_THRESHOLD = "gremlin.tinkergraph.ondiskOverflow.heapPercentageThreshold";
    private final TinkerGraphFeatures features = new TinkerGraphFeatures();
    protected AtomicLong currentId = new AtomicLong(-1L);
    protected Map<Object, Vertex> vertices = new THashMap();
    protected Map<Object, Edge> edges = new THashMap();
    protected final THashMap<String, Set<Vertex>> verticesByLabel = new THashMap(100);
    protected final THashMap<String, Set<Edge>> edgesByLabel = new THashMap(100);
    protected TinkerGraphVariables variables = null;
    protected TinkerGraphComputerView graphComputerView = null;
    protected TinkerIndex<Vertex> vertexIndex = null;
    protected TinkerIndex<Edge> edgeIndex = null;
    protected final IdManager<?> vertexIdManager;
    protected final IdManager<?> edgeIdManager;
    protected final IdManager<?> vertexPropertyIdManager;
    protected final VertexProperty.Cardinality defaultVertexPropertyCardinality;
    protected final boolean usesSpecializedElements;
    protected final Map<String, SpecializedElementFactory.ForVertex> specializedVertexFactoryByLabel = new HashMap<String, SpecializedElementFactory.ForVertex>();
    protected final Map<String, SpecializedElementFactory.ForEdge> specializedEdgeFactoryByLabel = new HashMap<String, SpecializedElementFactory.ForEdge>();
    private final Configuration configuration;
    private final String graphLocation;
    private final String graphFormat;
    public final boolean ondiskOverflowEnabled;
    protected OndiskOverflow ondiskOverflow;
    protected ReferenceManager referenceManager;

    public static final Configuration EMPTY_CONFIGURATION() {
        return new BaseConfiguration(){
            {
                this.setProperty("gremlin.graph", TinkerGraph.class.getName());
                this.setProperty(TinkerGraph.GREMLIN_TINKERGRAPH_OVERFLOW_HEAP_PERCENTAGE_THRESHOLD, 80);
                this.setProperty(TinkerGraph.GREMLIN_TINKERGRAPH_ONDISK_OVERFLOW_ENABLED, true);
            }
        };
    }

    private TinkerGraph(Configuration configuration, boolean usesSpecializedElements) {
        this.configuration = configuration;
        this.usesSpecializedElements = usesSpecializedElements;
        this.vertexIdManager = TinkerGraph.selectIdManager(configuration, GREMLIN_TINKERGRAPH_VERTEX_ID_MANAGER, Vertex.class);
        this.edgeIdManager = TinkerGraph.selectIdManager(configuration, GREMLIN_TINKERGRAPH_EDGE_ID_MANAGER, Edge.class);
        this.vertexPropertyIdManager = TinkerGraph.selectIdManager(configuration, GREMLIN_TINKERGRAPH_VERTEX_PROPERTY_ID_MANAGER, VertexProperty.class);
        this.defaultVertexPropertyCardinality = VertexProperty.Cardinality.valueOf((String)configuration.getString(GREMLIN_TINKERGRAPH_DEFAULT_VERTEX_PROPERTY_CARDINALITY, VertexProperty.Cardinality.single.name()));
        this.graphLocation = configuration.getString(GREMLIN_TINKERGRAPH_GRAPH_LOCATION, null);
        this.graphFormat = configuration.getString(GREMLIN_TINKERGRAPH_GRAPH_FORMAT, null);
        if (this.graphLocation != null && null == this.graphFormat || null == this.graphLocation && this.graphFormat != null) {
            throw new IllegalStateException(String.format("The %s and %s must both be specified if either is present", GREMLIN_TINKERGRAPH_GRAPH_LOCATION, GREMLIN_TINKERGRAPH_GRAPH_FORMAT));
        }
        this.ondiskOverflowEnabled = configuration.getBoolean(GREMLIN_TINKERGRAPH_ONDISK_OVERFLOW_ENABLED, true);
        if (this.ondiskOverflowEnabled) {
            VertexSerializer vertexSerializer = new VertexSerializer(this, this.specializedVertexFactoryByLabel);
            EdgeSerializer edgeSerializer = new EdgeSerializer(this, this.specializedEdgeFactoryByLabel);
            this.ondiskOverflow = new OndiskOverflow(configuration.getString(GREMLIN_TINKERGRAPH_ONDISK_ROOT_DIR), vertexSerializer, edgeSerializer);
            this.referenceManager = new ReferenceManager(configuration.getInt(GREMLIN_TINKERGRAPH_OVERFLOW_HEAP_PERCENTAGE_THRESHOLD));
        }
        if (this.graphLocation != null) {
            this.loadGraph();
        }
    }

    public static TinkerGraph open() {
        return TinkerGraph.open(TinkerGraph.EMPTY_CONFIGURATION());
    }

    public static TinkerGraph open(Configuration configuration) {
        return new TinkerGraph(configuration, false);
    }

    public static TinkerGraph open(List<SpecializedElementFactory.ForVertex<?>> vertexFactories, List<SpecializedElementFactory.ForEdge<?>> edgeFactories) {
        return TinkerGraph.open(TinkerGraph.EMPTY_CONFIGURATION(), vertexFactories, edgeFactories);
    }

    public static TinkerGraph open(Configuration configuration, List<SpecializedElementFactory.ForVertex<?>> vertexFactories, List<SpecializedElementFactory.ForEdge<?>> edgeFactories) {
        boolean usesSpecializedElements = !vertexFactories.isEmpty() || !edgeFactories.isEmpty();
        TinkerGraph tg = new TinkerGraph(configuration, usesSpecializedElements);
        vertexFactories.forEach(factory -> tg.specializedVertexFactoryByLabel.put(factory.forLabel(), (SpecializedElementFactory.ForVertex)factory));
        edgeFactories.forEach(factory -> tg.specializedEdgeFactoryByLabel.put(factory.forLabel(), (SpecializedElementFactory.ForEdge)factory));
        return tg;
    }

    public Vertex addVertex(Object ... keyValues) {
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        String label = ElementHelper.getLabelValue((Object[])keyValues).orElse("vertex");
        Long idValue = (Long)this.vertexIdManager.convert(ElementHelper.getIdValue((Object[])keyValues).orElse(null));
        if (null != idValue) {
            if (this.vertices.containsKey(idValue)) {
                throw Graph.Exceptions.vertexWithIdAlreadyExists((Object)idValue);
            }
        } else {
            idValue = (Long)this.vertexIdManager.getNextId(this);
        }
        this.currentId.set(Long.max(idValue, this.currentId.get()));
        Vertex vertex = this.createVertex(idValue, label, keyValues);
        this.vertices.put(vertex.id(), vertex);
        this.getElementsByLabel(this.verticesByLabel, label).add(vertex);
        return vertex;
    }

    private Vertex createVertex(long idValue, String label, Object ... keyValues) {
        Object vertex;
        if (this.specializedVertexFactoryByLabel.containsKey(label)) {
            vertex = this.specializedVertexFactoryByLabel.get(label).createVertexRef(idValue, this);
        } else {
            if (this.usesSpecializedElements) {
                throw new IllegalArgumentException("this instance of TinkerGraph uses specialized elements, but doesn't have a factory for label " + label + ". Mixing specialized and generic elements is not (yet) supported");
            }
            vertex = new TinkerVertex(idValue, label, this);
        }
        ElementHelper.attachProperties(vertex, (VertexProperty.Cardinality)VertexProperty.Cardinality.list, (Object[])keyValues);
        return vertex;
    }

    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) {
        if (!graphComputerClass.equals(TinkerGraphComputer.class)) {
            throw Graph.Exceptions.graphDoesNotSupportProvidedGraphComputer(graphComputerClass);
        }
        return (C)new TinkerGraphComputer(this);
    }

    public GraphComputer compute() {
        return new TinkerGraphComputer(this);
    }

    public Graph.Variables variables() {
        if (null == this.variables) {
            this.variables = new TinkerGraphVariables();
        }
        return this.variables;
    }

    public <I extends Io> I io(Io.Builder<I> builder) {
        if (builder.requiresVersion((Object)GryoVersion.V1_0) || builder.requiresVersion((Object)GraphSONVersion.V1_0)) {
            return (I)builder.graph((Graph)this).onMapper(mapper -> mapper.addRegistry((IoRegistry)TinkerIoRegistryV1d0.instance())).create();
        }
        if (builder.requiresVersion((Object)GraphSONVersion.V2_0)) {
            return (I)builder.graph((Graph)this).onMapper(mapper -> mapper.addRegistry((IoRegistry)TinkerIoRegistryV2d0.instance())).create();
        }
        return (I)builder.graph((Graph)this).onMapper(mapper -> mapper.addRegistry((IoRegistry)TinkerIoRegistryV3d0.instance())).create();
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)("vertices: " + this.vertices.size() + ", edges: " + this.edges.size()));
    }

    public SerializationStats getSerializationStats() {
        HashMap<Integer, Integer> vertexSerializationGroupCount = new HashMap<Integer, Integer>();
        this.vertices.values().stream().filter(v -> v instanceof ElementRef).forEach(vertex -> {
            Integer elementSerializationCount = ((ElementRef)vertex).getSerializationCount();
            Integer groupCountBefore = vertexSerializationGroupCount.getOrDefault(elementSerializationCount, 0);
            vertexSerializationGroupCount.put(elementSerializationCount, groupCountBefore + elementSerializationCount);
        });
        HashMap<Integer, Integer> edgeSerializationGroupCount = new HashMap<Integer, Integer>();
        this.edges.values().stream().filter(e -> e instanceof ElementRef).forEach(edge -> {
            Integer elementSerializationCount = ((ElementRef)edge).getSerializationCount();
            Integer groupCountBefore = edgeSerializationGroupCount.getOrDefault(elementSerializationCount, 0);
            edgeSerializationGroupCount.put(elementSerializationCount, groupCountBefore + elementSerializationCount);
        });
        return new SerializationStats(vertexSerializationGroupCount, edgeSerializationGroupCount);
    }

    public void close() {
        if (this.graphLocation != null) {
            this.saveGraph();
        }
        if (this.ondiskOverflowEnabled) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.getSerializationStats().toString());
            }
            this.ondiskOverflow.close();
            this.referenceManager.close();
        }
    }

    public Transaction tx() {
        throw Graph.Exceptions.transactionsNotSupported();
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public Vertex vertex(Long id) {
        return this.vertices.get(id);
    }

    public Iterator<Vertex> vertices(Object ... ids) {
        return this.createElementIterator(Vertex.class, this.vertices, this.vertexIdManager, ids);
    }

    public Iterator<Vertex> verticesByLabel(P<String> labelPredicate) {
        return this.elementsByLabel(this.verticesByLabel, labelPredicate);
    }

    public Edge edge(Long id) {
        return this.edges.get(id);
    }

    public Iterator<Edge> edges(Object ... ids) {
        return this.createElementIterator(Edge.class, this.edges, this.edgeIdManager, ids);
    }

    public Iterator<Edge> edgesByLabel(P<String> labelPredicate) {
        return this.elementsByLabel(this.edgesByLabel, labelPredicate);
    }

    protected <E extends Element> Set<E> getElementsByLabel(THashMap<String, Set<E>> elementsByLabel, String label) {
        if (!elementsByLabel.containsKey((Object)label)) {
            elementsByLabel.put((Object)label, (Object)new THashSet(100000));
        }
        return (Set)elementsByLabel.get((Object)label);
    }

    protected <E extends Element> Iterator<E> elementsByLabel(THashMap<String, Set<E>> elementsByLabel, P<String> labelPredicate) {
        MultiIterator multiIterator = new MultiIterator();
        for (String label : elementsByLabel.keySet()) {
            if (!labelPredicate.test((Object)label)) continue;
            multiIterator.addIterator(((Set)elementsByLabel.get((Object)label)).iterator());
        }
        return multiIterator;
    }

    private void loadGraph() {
        File f = new File(this.graphLocation);
        if (f.exists() && f.isFile()) {
            try {
                if (this.graphFormat.equals("graphml")) {
                    ((GraphMLIo)this.io(IoCore.graphml())).readGraph(this.graphLocation);
                } else if (this.graphFormat.equals("graphson")) {
                    ((GraphSONIo)this.io(IoCore.graphson())).readGraph(this.graphLocation);
                } else if (this.graphFormat.equals("gryo")) {
                    ((GryoIo)this.io(IoCore.gryo())).readGraph(this.graphLocation);
                } else {
                    this.io(IoCore.createIoBuilder((String)this.graphFormat)).readGraph(this.graphLocation);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Could not load graph at %s with %s", this.graphLocation, this.graphFormat), ex);
            }
        }
    }

    private void saveGraph() {
        File f = new File(this.graphLocation);
        if (f.exists()) {
            f.delete();
        } else {
            File parent = f.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
        }
        try {
            if (this.graphFormat.equals("graphml")) {
                ((GraphMLIo)this.io(IoCore.graphml())).writeGraph(this.graphLocation);
            } else if (this.graphFormat.equals("graphson")) {
                ((GraphSONIo)this.io(IoCore.graphson())).writeGraph(this.graphLocation);
            } else if (this.graphFormat.equals("gryo")) {
                ((GryoIo)this.io(IoCore.gryo())).writeGraph(this.graphLocation);
            } else {
                this.io(IoCore.createIoBuilder((String)this.graphFormat)).writeGraph(this.graphLocation);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Could not save graph at %s with %s", this.graphLocation, this.graphFormat), ex);
        }
    }

    private <T extends Element> Iterator<T> createElementIterator(Class<T> clazz, Map<Object, T> elements, IdManager idManager, Object ... ids) {
        if (0 != ids.length) {
            List<Object> idList = Arrays.asList(ids);
            this.validateHomogenousIds(idList);
            return clazz.isAssignableFrom(ids[0].getClass()) ? IteratorUtils.filter(IteratorUtils.map(idList, id -> (Element)elements.get(((Element)clazz.cast(id)).id())).iterator(), Objects::nonNull) : IteratorUtils.filter(IteratorUtils.map(idList, id -> (Element)elements.get(idManager.convert(id))).iterator(), Objects::nonNull);
        }
        Iterator iterator = elements.values().iterator();
        return TinkerHelper.inComputerMode(this) ? (clazz.equals(Vertex.class) ? IteratorUtils.filter(iterator, t -> this.graphComputerView.legalVertex((Vertex)t)) : IteratorUtils.filter((Iterator)iterator, t -> this.graphComputerView.legalEdge(t.outVertex(), (Edge)t))) : iterator;
    }

    public Graph.Features features() {
        return this.features;
    }

    private void validateHomogenousIds(List<Object> ids) {
        Iterator<Object> iterator = ids.iterator();
        Object id = iterator.next();
        if (id == null) {
            throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
        }
        Class<?> firstClass = id.getClass();
        while (iterator.hasNext()) {
            id = iterator.next();
            if (id != null && id.getClass().equals(firstClass)) continue;
            throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
        }
    }

    public <E extends Element> void createIndex(String key, Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            if (null == this.vertexIndex) {
                this.vertexIndex = new TinkerIndex<Vertex>(this, Vertex.class);
            }
            this.vertexIndex.createKeyIndex(key);
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            if (null == this.edgeIndex) {
                this.edgeIndex = new TinkerIndex<Edge>(this, Edge.class);
            }
            this.edgeIndex.createKeyIndex(key);
        } else {
            throw new IllegalArgumentException("Class is not indexable: " + elementClass);
        }
    }

    public <E extends Element> void dropIndex(String key, Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            if (null != this.vertexIndex) {
                this.vertexIndex.dropKeyIndex(key);
            }
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            if (null != this.edgeIndex) {
                this.edgeIndex.dropKeyIndex(key);
            }
        } else {
            throw new IllegalArgumentException("Class is not indexable: " + elementClass);
        }
    }

    public <E extends Element> Set<String> getIndexedKeys(Class<E> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            return null == this.vertexIndex ? Collections.emptySet() : this.vertexIndex.getIndexedKeys();
        }
        if (Edge.class.isAssignableFrom(elementClass)) {
            return null == this.edgeIndex ? Collections.emptySet() : this.edgeIndex.getIndexedKeys();
        }
        throw new IllegalArgumentException("Class is not indexable: " + elementClass);
    }

    private static IdManager<?> selectIdManager(Configuration config, String configKey, Class<? extends Element> clazz) {
        return DefaultIdManager.LONG;
    }

    static {
        TraversalStrategies.GlobalCache.registerStrategies(TinkerGraph.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone().addStrategies(new TraversalStrategy[]{TinkerGraphStepStrategy.instance(), TinkerGraphCountStrategy.instance()}));
    }

    public static enum DefaultIdManager implements IdManager
    {
        LONG{

            public Long getNextId(TinkerGraph graph) {
                return Stream.generate(() -> graph.currentId.incrementAndGet()).findAny().get();
            }

            public Object convert(Object id) {
                if (null == id) {
                    return null;
                }
                if (id instanceof Long) {
                    return id;
                }
                if (id instanceof Number) {
                    return ((Number)id).longValue();
                }
                if (id instanceof String) {
                    return Long.parseLong((String)id);
                }
                throw new IllegalArgumentException(String.format("Expected an id that is convertible to Long but received %s", id.getClass()));
            }

            @Override
            public boolean allow(Object id) {
                return id instanceof Number || id instanceof String;
            }
        }
        ,
        INTEGER{

            public Integer getNextId(TinkerGraph graph) {
                return Stream.generate(() -> graph.currentId.incrementAndGet()).map(Long::intValue).findAny().get();
            }

            public Object convert(Object id) {
                if (null == id) {
                    return null;
                }
                if (id instanceof Integer) {
                    return id;
                }
                if (id instanceof Number) {
                    return ((Number)id).intValue();
                }
                if (id instanceof String) {
                    return Integer.parseInt((String)id);
                }
                throw new IllegalArgumentException(String.format("Expected an id that is convertible to Integer but received %s", id.getClass()));
            }

            @Override
            public boolean allow(Object id) {
                return id instanceof Number || id instanceof String;
            }
        }
        ,
        UUID{

            public UUID getNextId(TinkerGraph graph) {
                return java.util.UUID.randomUUID();
            }

            public Object convert(Object id) {
                if (null == id) {
                    return null;
                }
                if (id instanceof UUID) {
                    return id;
                }
                if (id instanceof String) {
                    return java.util.UUID.fromString((String)id);
                }
                throw new IllegalArgumentException(String.format("Expected an id that is convertible to UUID but received %s", id.getClass()));
            }

            @Override
            public boolean allow(Object id) {
                return id instanceof UUID || id instanceof String;
            }
        }
        ,
        ANY{

            public Long getNextId(TinkerGraph graph) {
                return Stream.generate(() -> graph.currentId.incrementAndGet()).findAny().get();
            }

            public Object convert(Object id) {
                return id;
            }

            @Override
            public boolean allow(Object id) {
                return true;
            }
        };

    }

    public static interface IdManager<T> {
        public T getNextId(TinkerGraph var1);

        public T convert(Object var1);

        public boolean allow(Object var1);
    }

    public class TinkerGraphVertexPropertyFeatures
    implements Graph.Features.VertexPropertyFeatures {
        private TinkerGraphVertexPropertyFeatures() {
        }

        public boolean supportsCustomIds() {
            return false;
        }

        public boolean willAllowId(Object id) {
            return TinkerGraph.this.vertexIdManager.allow(id);
        }
    }

    public class TinkerGraphGraphFeatures
    implements Graph.Features.GraphFeatures {
        private TinkerGraphGraphFeatures() {
        }

        public boolean supportsConcurrentAccess() {
            return false;
        }

        public boolean supportsTransactions() {
            return false;
        }

        public boolean supportsThreadedTransactions() {
            return false;
        }
    }

    public class TinkerGraphEdgeFeatures
    implements Graph.Features.EdgeFeatures {
        private TinkerGraphEdgeFeatures() {
        }

        public boolean supportsCustomIds() {
            return false;
        }

        public boolean willAllowId(Object id) {
            return TinkerGraph.this.edgeIdManager.allow(id);
        }
    }

    public class TinkerGraphVertexFeatures
    implements Graph.Features.VertexFeatures {
        private final TinkerGraphVertexPropertyFeatures vertexPropertyFeatures;

        private TinkerGraphVertexFeatures() {
            this.vertexPropertyFeatures = new TinkerGraphVertexPropertyFeatures();
        }

        public Graph.Features.VertexPropertyFeatures properties() {
            return this.vertexPropertyFeatures;
        }

        public boolean supportsCustomIds() {
            return false;
        }

        public boolean willAllowId(Object id) {
            return TinkerGraph.this.vertexIdManager.allow(id);
        }

        public VertexProperty.Cardinality getCardinality(String key) {
            return TinkerGraph.this.defaultVertexPropertyCardinality;
        }
    }

    public class TinkerGraphFeatures
    implements Graph.Features {
        private final TinkerGraphGraphFeatures graphFeatures;
        private final TinkerGraphEdgeFeatures edgeFeatures;
        private final TinkerGraphVertexFeatures vertexFeatures;

        private TinkerGraphFeatures() {
            this.graphFeatures = new TinkerGraphGraphFeatures();
            this.edgeFeatures = new TinkerGraphEdgeFeatures();
            this.vertexFeatures = new TinkerGraphVertexFeatures();
        }

        public Graph.Features.GraphFeatures graph() {
            return this.graphFeatures;
        }

        public Graph.Features.EdgeFeatures edge() {
            return this.edgeFeatures;
        }

        public Graph.Features.VertexFeatures vertex() {
            return this.vertexFeatures;
        }

        public String toString() {
            return StringFactory.featureString((Graph.Features)this);
        }
    }
}

