/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerProperty;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class TinkerVertexProperty<V>
extends TinkerElement
implements VertexProperty<V> {
    protected Map<String, Property> properties;
    private final TinkerVertex vertex;
    private final String key;
    private final V value;

    public TinkerVertexProperty(TinkerVertex vertex, String key, V value, Object ... propertyKeyValues) {
        super(vertex.tinkerGraph().vertexPropertyIdManager.getNextId(vertex.tinkerGraph()), key, vertex.tinkerGraph());
        this.vertex = vertex;
        this.key = key;
        this.value = value;
        ElementHelper.legalPropertyKeyValueArray((Object[])propertyKeyValues);
        ElementHelper.attachProperties((Element)this, (Object[])propertyKeyValues);
    }

    public TinkerVertexProperty(Object id, TinkerVertex vertex, String key, V value, Object ... propertyKeyValues) {
        super(id, key, vertex.tinkerGraph());
        this.vertex = vertex;
        this.key = key;
        this.value = value;
        ElementHelper.legalPropertyKeyValueArray((Object[])propertyKeyValues);
        ElementHelper.attachProperties((Element)this, (Object[])propertyKeyValues);
    }

    public String key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public boolean isPresent() {
        return true;
    }

    public String toString() {
        return StringFactory.propertyString((Property)this);
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public boolean equals(Object object) {
        return ElementHelper.areEqual((VertexProperty)this, (Object)object);
    }

    public Set<String> keys() {
        return null == this.properties ? Collections.emptySet() : this.properties.keySet();
    }

    public <U> Property<U> property(String key) {
        return null == this.properties ? Property.empty() : this.properties.getOrDefault(key, Property.empty());
    }

    public <U> Property<U> property(String key, U value) {
        if (this.removed) {
            throw TinkerVertexProperty.elementAlreadyRemoved(VertexProperty.class, this.id);
        }
        TinkerProperty<U> property = new TinkerProperty<U>(this, key, value);
        if (this.properties == null) {
            this.properties = new HashMap<String, Property>();
        }
        this.properties.put(key, property);
        return property;
    }

    public Vertex element() {
        return this.vertex;
    }

    public void remove() {
        if (null != this.vertex.properties && this.vertex.properties.containsKey(this.key)) {
            this.vertex.properties.get(this.key).remove(this);
            if (this.vertex.properties.get(this.key).size() == 0) {
                this.vertex.properties.remove(this.key);
                TinkerHelper.removeIndex(this.vertex, this.key, this.value);
            }
            AtomicBoolean delete = new AtomicBoolean(true);
            this.vertex.properties(this.key).forEachRemaining(property -> {
                if (property.value().equals(this.value)) {
                    delete.set(false);
                }
            });
            if (delete.get()) {
                TinkerHelper.removeIndex(this.vertex, this.key, this.value);
            }
            this.properties = null;
            this.removed = true;
        }
    }

    public <U> Iterator<Property<U>> properties(String ... propertyKeys) {
        if (null == this.properties) {
            return Collections.emptyIterator();
        }
        if (propertyKeys.length == 1) {
            Property property = this.properties.get(propertyKeys[0]);
            return null == property ? Collections.emptyIterator() : IteratorUtils.of((Object)property);
        }
        return this.properties.entrySet().stream().filter(entry -> ElementHelper.keyExists((String)((String)entry.getKey()), (String[])propertyKeys)).map(entry -> (Property)entry.getValue()).collect(Collectors.toList()).iterator();
    }
}

