/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.io.IOException;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.ElementRef;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;

public class VertexRef<V extends TinkerVertex>
extends ElementRef<V>
implements Vertex {
    public VertexRef(V vertex) {
        super(vertex);
    }

    public VertexRef(long vertexId, String label, TinkerGraph graph) {
        super(vertexId, label, graph);
    }

    @Override
    protected V readFromDisk(long vertexId) throws IOException {
        return (V)this.graph.ondiskOverflow.readVertex(vertexId);
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    public Edge addEdge(String label, Vertex inVertex, Object ... keyValues) {
        return ((TinkerVertex)this.get()).addEdge(label, inVertex, keyValues);
    }

    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        return ((TinkerVertex)this.get()).property(cardinality, key, value, keyValues);
    }

    public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
        return ((TinkerVertex)this.get()).properties(propertyKeys);
    }

    public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
        return ((TinkerVertex)this.get()).edges(direction, edgeLabels);
    }

    public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
        return ((TinkerVertex)this.get()).vertices(direction, edgeLabels);
    }
}

