/*
 * Decompiled with CFR 0.152.
 */
package io.sikt.iso8583;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum FieldType {
    NUMERIC(0),
    ALPHA(0),
    BINARY(0),
    LLVAR(2),
    LLBIN(2),
    LLLVAR(3),
    LLLBIN(3),
    LLLLVAR(4),
    LLLLBIN(4);

    private final int numberOfLengthDigits;
    public static final Set<FieldType> VARIABLE_LENGTH_TYPES;
    public static final Set<FieldType> BINARY_TYPE;

    private FieldType(int numberOfLengthDigits) {
        this.numberOfLengthDigits = numberOfLengthDigits;
    }

    public static boolean isBinaryType(FieldType fieldType) {
        return BINARY_TYPE.contains((Object)fieldType);
    }

    public static boolean isVariableLength(FieldType fieldType) {
        return VARIABLE_LENGTH_TYPES.contains((Object)fieldType);
    }

    public int getNumberOfLengthDigits() {
        return this.numberOfLengthDigits;
    }

    static {
        VARIABLE_LENGTH_TYPES = Collections.unmodifiableSet(EnumSet.of(LLBIN, new FieldType[]{LLLBIN, LLLLBIN, LLVAR, LLLVAR, LLLLVAR}));
        BINARY_TYPE = Collections.unmodifiableSet(EnumSet.of(BINARY, LLBIN, LLLBIN, LLLLBIN));
    }
}

