/*
 * Decompiled with CFR 0.152.
 */
package io.sikt.iso8583;

import io.sikt.iso8583.FieldType;
import io.sikt.iso8583.packager.MessagePackager;
import io.sikt.iso8583.packager.fields.PackagerField;
import java.util.BitSet;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;

public class IsoMsg {
    private MessagePackager packager;
    private String isoHeader;
    private final Map<Integer, String> fields = new TreeMap<Integer, String>();
    private final BitSet bitMap = new BitSet();

    public IsoMsg(MessagePackager packager) {
        this.packager = packager;
    }

    public void setMTI(String mti) {
        this.setField(0, mti);
    }

    public String getMTI() {
        return this.getField(0);
    }

    public boolean hasField(int field) {
        return this.getField(field) != null;
    }

    public String getField(int field) {
        PackagerField fieldPackager;
        String what = this.fields.get(field);
        if (what != null && what.length() == 0 && (fieldPackager = this.packager.getFieldPackager(field)) != null && FieldType.NUMERIC.equals((Object)fieldPackager.getType())) {
            return this.pad(fieldPackager, what);
        }
        return what;
    }

    public byte[] getFieldAsByteArray(int field) {
        return this.fields.get(field).getBytes(this.packager.getCharacterEncoding());
    }

    public void removeFields(int ... fields) {
        for (int field : fields) {
            this.fields.remove(field);
        }
        this.recalculateBitMap();
    }

    public void setField(int field, String value) {
        if (value != null) {
            this.fields.put(field, value);
        } else {
            this.fields.remove(field);
        }
        this.recalculateBitMap();
    }

    private void recalculateBitMap() {
        this.bitMap.clear();
        this.fields.keySet().stream().filter(field -> field > 0).forEach(this.bitMap::set);
    }

    public byte[] pack() {
        return this.packager.pack(this);
    }

    public String dumpMsgAsJson() {
        StringJoiner sb = new StringJoiner(",", "{", "}");
        this.fields.forEach((key, value) -> this.appendFieldToSb(sb, (int)key, (String)value));
        return sb.toString();
    }

    public IsoMsg clone() {
        IsoMsg msg = new IsoMsg();
        msg.setMTI(this.getMTI());
        msg.setPackager(this.packager);
        msg.setIsoHeader(this.getIsoHeader());
        this.fields.forEach(msg::setField);
        return msg;
    }

    private void appendFieldToSb(StringJoiner joiner, int fieldNumb, String value) {
        joiner.add("\"" + fieldNumb + "\":\"" + this.pad(this.packager.getFieldPackager(fieldNumb), value) + "\"");
    }

    private String pad(PackagerField packager, String value) {
        return packager.getPadding().pad(value, packager.getLength());
    }

    public IsoMsg() {
    }

    public void setPackager(MessagePackager packager) {
        this.packager = packager;
    }

    public MessagePackager getPackager() {
        return this.packager;
    }

    public void setIsoHeader(String isoHeader) {
        this.isoHeader = isoHeader;
    }

    public String getIsoHeader() {
        return this.isoHeader;
    }

    public BitSet getBitMap() {
        return this.bitMap;
    }
}

