/*
 * Decompiled with CFR 0.152.
 */
package io.sikt.iso8583.dto;

import io.sikt.iso8583.IsoException;
import io.sikt.iso8583.packager.fields.ALPHA;
import io.sikt.iso8583.packager.fields.BINARY;
import io.sikt.iso8583.packager.fields.GenericPackagerField;
import io.sikt.iso8583.packager.fields.LLLL_BIN;
import io.sikt.iso8583.packager.fields.LLLL_VAR;
import io.sikt.iso8583.packager.fields.LLL_BIN;
import io.sikt.iso8583.packager.fields.LLL_VAR;
import io.sikt.iso8583.packager.fields.LL_BIN;
import io.sikt.iso8583.packager.fields.LL_VAR;
import io.sikt.iso8583.packager.fields.NUMERIC;

public class JsonPackagerField {
    private int field;
    private String type;
    private int length;
    private String description;

    public GenericPackagerField convertToPackagerField() {
        switch (this.type.toUpperCase()) {
            case "NUMERIC": {
                return new NUMERIC(this.length, this.description);
            }
            case "ALPHA": {
                return new ALPHA(this.length, this.description);
            }
            case "BINARY": {
                return new BINARY(this.length, this.description);
            }
            case "LL_VAR": {
                return new LL_VAR(this.length, this.description);
            }
            case "LLL_VAR": {
                return new LLL_VAR(this.length, this.description);
            }
            case "LLLL_VAR": {
                return new LLLL_VAR(this.length, this.description);
            }
            case "LL_BIN": {
                return new LL_BIN(this.length, this.description);
            }
            case "LLL_BIN": {
                return new LLL_BIN(this.length, this.description);
            }
            case "LLLL_BIN": {
                return new LLLL_BIN(this.length, this.description);
            }
        }
        throw new IsoException("Unknown field type: " + this.type);
    }

    public int getField() {
        return this.field;
    }

    public String getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public String getDescription() {
        return this.description;
    }

    public void setField(int field) {
        this.field = field;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonPackagerField)) {
            return false;
        }
        JsonPackagerField other = (JsonPackagerField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getField() != other.getField()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonPackagerField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getField();
        result = result * 59 + this.getLength();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "JsonPackagerField(field=" + this.getField() + ", type=" + this.getType() + ", length=" + this.getLength() + ", description=" + this.getDescription() + ")";
    }
}

