/*
 * Decompiled with CFR 0.152.
 */
package io.sikt.iso8583.dto;

import com.grack.nanojson.JsonParserException;
import com.grack.nanojson.JsonReader;
import io.sikt.iso8583.IsoException;
import io.sikt.iso8583.dto.JsonPackagerField;
import io.sikt.iso8583.packager.PackagerConfiguration;
import io.sikt.iso8583.packager.fields.PackagerField;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPackagerParser {
    private static final Logger log = LoggerFactory.getLogger(JsonPackagerParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PackagerConfiguration readPackagerFile(String path) {
        long timer = System.nanoTime();
        PackagerConfiguration configuration = new PackagerConfiguration();
        try {
            Path filePath = Paths.get(path, new String[0]);
            configuration.setFileName(filePath.getFileName().toString());
            configuration.setFileName(configuration.getFileName().substring(0, configuration.getFileName().lastIndexOf(".")));
            InputStream stream = Files.newInputStream(filePath, new OpenOption[0]);
            JsonReader reader = JsonReader.from((InputStream)stream);
            reader.object();
            reader.next();
            JsonPackagerParser.readJsonElement(configuration, reader);
            reader.next();
            JsonPackagerParser.readJsonElement(configuration, reader);
            reader.next();
            JsonPackagerParser.readJsonElement(configuration, reader);
            if (log.isTraceEnabled()) {
                log.trace("imported PackagerConfiguration: {}", (Object)configuration);
            }
        }
        catch (Exception ex) {
            log.error("Failed to parse packager-file: {}", (Object)path, (Object)ex);
        }
        finally {
            log.debug("readPackagersFromFile ({}) finished in {} ms", (Object)configuration.getFileName(), (Object)((double)(System.nanoTime() - timer) / 1000000.0));
        }
        return configuration;
    }

    private static void readJsonElement(PackagerConfiguration configuration, JsonReader reader) throws JsonParserException {
        switch (reader.key()) {
            case "messageEncoding": {
                configuration.setEncoding(JsonPackagerParser.readMessageEncoding(reader));
                break;
            }
            case "messageTypes": {
                configuration.setMessageTypeParserGuide(JsonPackagerParser.readFieldParseGuide(reader));
                break;
            }
            case "packager": {
                configuration.setPackagerInfo(JsonPackagerParser.readPackagerInfo(reader));
                break;
            }
            default: {
                throw new IsoException("Unexpected JSON element: " + reader.key());
            }
        }
    }

    private static Map<Integer, PackagerField> readPackagerInfo(JsonReader reader) throws JsonParserException {
        reader.object();
        List<JsonPackagerField> fields = JsonPackagerParser.getFields(reader);
        return fields.stream().collect(Collectors.toMap(JsonPackagerField::getField, JsonPackagerField::convertToPackagerField));
    }

    private static Charset readMessageEncoding(JsonReader reader) throws JsonParserException {
        return Charset.forName(reader.string());
    }

    private static Map<String, List<Integer>> readFieldParseGuide(JsonReader reader) throws JsonParserException {
        reader.object();
        HashMap<String, List<Integer>> fieldParserGuide = new HashMap<String, List<Integer>>();
        while (reader.next()) {
            String mti = reader.key();
            reader.array();
            ArrayList<Integer> fields = new ArrayList<Integer>();
            while (reader.next()) {
                fields.add(reader.intVal());
            }
            fieldParserGuide.put(mti, fields);
        }
        return fieldParserGuide;
    }

    private static List<JsonPackagerField> getFields(JsonReader reader) throws JsonParserException {
        ArrayList<JsonPackagerField> fields = new ArrayList<JsonPackagerField>();
        reader.next();
        reader.array();
        while (reader.next()) {
            JsonPackagerField field = new JsonPackagerField();
            reader.object();
            reader.next();
            field.setField(reader.intVal());
            reader.next();
            field.setType(reader.string());
            reader.next();
            field.setLength(reader.intVal());
            reader.next();
            field.setDescription(reader.string());
            reader.next();
            fields.add(field);
        }
        return fields;
    }

    private JsonPackagerParser() {
    }
}

