/*
 * Decompiled with CFR 0.152.
 */
package io.sikt.iso8583.packager;

import io.sikt.iso8583.FieldType;
import io.sikt.iso8583.IsoException;
import io.sikt.iso8583.IsoMsg;
import io.sikt.iso8583.packager.MessagePackager;
import io.sikt.iso8583.packager.PackagerConfiguration;
import io.sikt.iso8583.packager.fields.PackagerField;
import io.sikt.iso8583.util.ByteArrayUtil;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePackager
implements MessagePackager {
    private static final Logger log = LoggerFactory.getLogger(BasePackager.class);
    final Map<Integer, PackagerField> packagerInfo;
    final Map<String, List<Integer>> messageTypeParserGuide;
    Charset encoding;
    private static final int MTI_FIELD = 0;
    private static final int PRIMARY_BITMAP_FIELD = 1;

    protected BasePackager(PackagerConfiguration packagerConfiguration) {
        this.packagerInfo = packagerConfiguration.getPackagerInfo();
        this.messageTypeParserGuide = packagerConfiguration.getMessageTypeParserGuide();
        this.encoding = packagerConfiguration.getEncoding();
    }

    public void setPackagerField(int field, PackagerField value) {
        this.packagerInfo.put(field, value);
    }

    @Override
    public Charset getCharacterEncoding() {
        return this.encoding;
    }

    @Override
    public PackagerField getFieldPackager(int field) {
        return this.packagerInfo.get(field);
    }

    @Override
    public IsoMsg unpack(byte[] data) {
        if (data.length < 4) {
            throw new IsoException("Message length (" + data.length + ") is to short! No MTI included");
        }
        IsoMsg msg = new IsoMsg(this);
        AtomicInteger readOffset = new AtomicInteger(0);
        String mti = this.readPackagerField(data, readOffset, this.packagerInfo.get(0));
        if (mti != null && !"".equals(mti.trim())) {
            msg.setMTI(mti);
        }
        BitSet bMap = this.readBitMap(data, readOffset, this.packagerInfo.get(1));
        if (msg.hasField(0)) {
            log.debug("Unpacking mti: {}, bitmap: {}", (Object)mti, (Object)bMap);
        } else {
            log.debug("Unpacking msg with bitmap: {}", (Object)bMap);
        }
        Map<Integer, PackagerField> fieldParserGuide = this.getFieldsParserGuide(mti);
        this.validatePackagerField(mti, fieldParserGuide, 0);
        bMap.stream().forEach(field -> {
            this.validatePackagerField(mti, fieldParserGuide, field);
            msg.setField(field, this.readPackagerField(data, readOffset, this.packagerInfo.get(field)));
        });
        return msg;
    }

    @Override
    public byte[] pack(IsoMsg msg) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        String mti = msg.getField(0);
        if (mti == null) {
            log.debug("Unable to determine field parsing because field 0 (MTI) is not set.");
        }
        Map<Integer, PackagerField> fieldParserGuide = this.getFieldsParserGuide(mti);
        this.validatePackagerField(mti, fieldParserGuide, 0);
        this.printToBuffer(msg, bout, fieldParserGuide.get(0), 0);
        BitSet bs = msg.getBitMap();
        this.writeBitMap(bout, bs, this.packagerInfo.get(1));
        if (msg.getIsoHeader() != null) {
            bout.write(msg.getIsoHeader().getBytes(this.encoding.name()));
        }
        bs.stream().forEach(field -> {
            this.validatePackagerField(mti, fieldParserGuide, field);
            this.printToBuffer(msg, bout, (PackagerField)fieldParserGuide.get(field), field);
        });
        return bout.toByteArray();
    }

    private Map<Integer, PackagerField> getFieldsParserGuide(String mti) {
        List<Integer> expectedFields = this.messageTypeParserGuide.get(mti);
        if (expectedFields == null || expectedFields.isEmpty()) {
            return this.packagerInfo;
        }
        return this.packagerInfo.entrySet().stream().filter(entry -> expectedFields.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void validatePackagerField(String mti, Map<Integer, PackagerField> fieldParserGuide, int field) {
        if (!fieldParserGuide.containsKey(field)) {
            throw new IsoException("Field " + field + " does not exist in packager for type " + mti + "!");
        }
    }

    private void printToBuffer(IsoMsg msg, ByteArrayOutputStream bout, PackagerField packagerField, int field) {
        if (packagerField == null || !msg.hasField(field) || packagerField.getLength() <= 0) {
            return;
        }
        bout.write(packagerField.pack(msg.getField(field), this.encoding));
    }

    private void writeBitMap(ByteArrayOutputStream bout, BitSet bs, PackagerField bitMapField) {
        int len = bitMapField.getLength() >= 8 ? bs.length() + 62 >> 6 << 3 : bitMapField.getLength();
        byte[] bitmap = ByteArrayUtil.bitSet2byte(bs, len);
        if (FieldType.isBinaryType(bitMapField.getType())) {
            bout.write(bitmap);
        } else {
            bout.write(ByteArrayUtil.byte2hex(bitmap).getBytes());
        }
    }

    private BitSet readBitMap(byte[] data, AtomicInteger offset, PackagerField bitMapField) {
        BitSet bmap = ByteArrayUtil.byte2BitSet(data, offset.get(), bitMapField.getLength() << 3);
        int len = bitMapField.getLength() >= 8 ? bmap.length() + 62 >> 6 << 3 : bitMapField.getLength();
        offset.addAndGet(len);
        return bmap;
    }

    private byte[] readChunk(byte[] what, AtomicInteger offset, int length) {
        int to = offset.get() + length;
        return Arrays.copyOfRange(what, offset.getAndAdd(length), to);
    }

    private String readPackagerField(byte[] what, AtomicInteger offset, PackagerField packagerField) {
        int length = packagerField.getLength();
        if (FieldType.isVariableLength(packagerField.getType())) {
            byte[] lengthRaw = this.readChunk(what, offset, packagerField.getType().getNumberOfLengthDigits());
            length = Integer.parseInt(new String(lengthRaw));
        }
        byte[] tmp = this.readChunk(what, offset, length);
        return packagerField.unpack(tmp, this.encoding);
    }
}

