/*
 * Decompiled with CFR 0.152.
 */
package io.sikt.iso8583.packager.fields;

import io.sikt.iso8583.FieldType;
import io.sikt.iso8583.packager.fields.PackagerField;
import io.sikt.iso8583.packager.padder.Padding;
import io.sikt.iso8583.util.ByteArrayUtil;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;

public abstract class GenericPackagerField
implements PackagerField {
    private final int length;
    private final String description;
    private final Padding padding;
    private final FieldType type;

    public GenericPackagerField(int length, String description, FieldType fieldType, Padding padding) {
        this.length = length;
        this.description = description;
        this.padding = padding;
        this.type = fieldType;
    }

    @Override
    public byte[] pack(String what, Charset charset) {
        byte[] paddedRaw;
        String padded = this.padding.pad(what, this.length);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        boolean isBinary = FieldType.isBinaryType(this.type);
        byte[] byArray = paddedRaw = isBinary ? ByteArrayUtil.hex2byte(what, charset) : padded.getBytes(charset);
        if (FieldType.isVariableLength(this.type)) {
            this.writeLengthHeader(bout, paddedRaw.length);
        }
        bout.write(paddedRaw);
        return bout.toByteArray();
    }

    @Override
    public String unpack(byte[] what, Charset charset) {
        boolean isBinary = FieldType.isBinaryType(this.type);
        if (isBinary) {
            what = ByteArrayUtil.byte2hex(what).getBytes(charset);
        }
        String padded = new String(what, charset);
        return this.padding.unpad(padded);
    }

    private void writeLengthHeader(ByteArrayOutputStream bout, int length) {
        if (!FieldType.isVariableLength(this.type)) {
            return;
        }
        if (this.type.getNumberOfLengthDigits() == 4) {
            bout.write(length / 1000 + 48);
            bout.write(length % 1000 / 100 + 48);
        } else if (this.type.getNumberOfLengthDigits() == 3) {
            bout.write(length / 100 + 48);
        }
        if (length >= 10) {
            bout.write(length % 100 / 10 + 48);
        } else {
            bout.write(48);
        }
        bout.write(length % 10 + 48);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public FieldType getType() {
        return this.type;
    }

    @Override
    public Padding getPadding() {
        return this.padding;
    }

    public String toString() {
        return "GenericPackagerField{length=" + this.length + ", description='" + this.description + '\'' + ", padding=" + this.padding.getClass().getSimpleName() + ", type=" + (Object)((Object)this.type) + '}';
    }
}

