/*
 * Decompiled with CFR 0.152.
 */
package io.sikt.iso8583.packager.padder;

import io.sikt.iso8583.packager.padder.Padding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceRightPadder
implements Padding {
    private static final Logger log = LoggerFactory.getLogger(SpaceRightPadder.class);
    private static final char PADDING_CHAR = ' ';

    @Override
    public String pad(String what, int maxLength) {
        int len = what.length();
        if (len < maxLength) {
            StringBuilder padded = new StringBuilder(maxLength);
            padded.append(what);
            while (len < maxLength) {
                padded.append(' ');
                ++len;
            }
            what = padded.toString();
        } else if (len > maxLength) {
            log.error("Data is longer than maxLength ({} vs {})", (Object)what.length(), (Object)maxLength);
            return this.pad(what.substring(0, maxLength), maxLength);
        }
        return what;
    }

    @Override
    public String unpad(String what) {
        int len;
        for (int i = len = what.length(); i > 0; --i) {
            if (what.charAt(i - 1) == ' ') continue;
            return what.substring(0, i);
        }
        return "";
    }
}

