/*
 * Decompiled with CFR 0.152.
 */
package io.sikt.iso8583.packager.padder;

import io.sikt.iso8583.packager.padder.Padding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroLeftPadder
implements Padding {
    private static final Logger log = LoggerFactory.getLogger(ZeroLeftPadder.class);
    private static final char PADDING_CHAR = '0';

    @Override
    public String pad(String what, int maxLength) {
        StringBuilder padded = new StringBuilder(maxLength);
        int length = what.length();
        if (length > maxLength) {
            log.error("Data is longer than maxLength ({} vs {})", (Object)length, (Object)maxLength);
            return what;
        }
        for (int i = maxLength - length; i > 0; --i) {
            padded.append('0');
        }
        padded.append(what);
        return padded.toString();
    }

    @Override
    public String unpad(String what) {
        int len = what.length();
        for (int i = 0; i < len; ++i) {
            if (what.charAt(i) == '0') continue;
            return what.substring(i);
        }
        return "";
    }
}

