/*
 * Decompiled with CFR 0.152.
 */
package io.sikt.iso8583.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.BitSet;

public class ByteArrayUtil {
    public static byte[] hex2byte(String s, Charset charset) {
        if (charset == null) {
            charset = StandardCharsets.ISO_8859_1;
        }
        if (s.length() % 2 == 0) {
            return ByteArrayUtil.hex2byte(s.getBytes(charset), 0, s.length() >> 1);
        }
        return ByteArrayUtil.hex2byte("0" + s, charset);
    }

    public static byte[] hex2byte(byte[] b, int offset, int len) {
        byte[] d = new byte[len];
        for (int i = 0; i < len * 2; ++i) {
            int shift = i % 2 == 1 ? 0 : 4;
            int n = i >> 1;
            d[n] = (byte)(d[n] | Character.digit((char)b[offset + i], 16) << shift);
        }
        return d;
    }

    public static byte[] concat(byte[] ... arrays) {
        int totalLength = Arrays.stream(arrays).mapToInt(array -> ((byte[])array).length).reduce(0, Integer::sum);
        int offset = 0;
        byte[] concatArray = new byte[totalLength];
        for (byte[] array2 : arrays) {
            System.arraycopy(array2, 0, concatArray, offset, array2.length);
            offset += array2.length;
        }
        return concatArray;
    }

    public static String byte2hex(byte[] bs) {
        return ByteArrayUtil.byte2hex(bs, 0, bs.length);
    }

    public static String byte2hex(byte[] bs, int off, int length) {
        if (bs.length > off && bs.length >= off + length) {
            StringBuilder sb = new StringBuilder(length * 2);
            ByteArrayUtil.byte2hexAppend(bs, off, length, sb);
            return sb.toString().toUpperCase();
        }
        return "";
    }

    private static void byte2hexAppend(byte[] bs, int off, int length, StringBuilder sb) {
        if (bs.length > off && bs.length >= off + length) {
            sb.ensureCapacity(sb.length() + length * 2);
            for (int i = off; i < off + length; ++i) {
                sb.append(Character.forDigit(bs[i] >>> 4 & 0xF, 16));
                sb.append(Character.forDigit(bs[i] & 0xF, 16));
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static byte[] bitSet2byte(BitSet b, int length) {
        int len = length * 8;
        byte[] d = new byte[length];
        for (int i = 0; i < len; ++i) {
            if (!b.get(i + 1)) continue;
            int n = i >> 3;
            d[n] = (byte)(d[n] | 128 >> i % 8);
        }
        if (len > 64) {
            d[0] = (byte)(d[0] | 0x80);
        }
        if (len > 128) {
            d[8] = (byte)(d[8] | 0x80);
        }
        return d;
    }

    public static BitSet byte2BitSet(byte[] b, int offset, int maxBits) {
        boolean b1 = (b[offset] & 0x80) == 128;
        boolean b65 = b.length > offset + 8 && (b[offset + 8] & 0x80) == 128;
        int len = ByteArrayUtil.getLength(maxBits, b1, b65);
        BitSet bmap = new BitSet(len);
        for (int i = 0; i < len; ++i) {
            if ((b[offset + (i >> 3)] & 128 >> i % 8) <= 0) continue;
            bmap.set(i + 1);
        }
        return bmap;
    }

    private static int getLength(int maxBits, boolean b1, boolean b65) {
        if (maxBits > 128 && b1 && b65) {
            return 192;
        }
        if (maxBits > 64 && b1) {
            return 128;
        }
        return Math.min(maxBits, 64);
    }

    private ByteArrayUtil() {
    }
}

