/*
 * Decompiled with CFR 0.152.
 */
package kikaha.cloud.aws.ec2;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import kikaha.cloud.aws.iam.AmazonConfigurationProducer;

@Singleton
public class AmazonEC2ClientProducer {
    @Inject
    ClientConfiguration clientConfiguration;
    @Inject
    @Named(value="ec2")
    AmazonConfigurationProducer.AmazonWebServiceConfiguration configuration;
    private final AtomicReference<Object> amazonEC2 = new AtomicReference();

    @Produces
    public AmazonEC2 produceAmazonEC2Client() {
        return this.getAmazonEC2();
    }

    AmazonEC2 createAmazonEC2Client() {
        return (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withClientConfiguration(this.clientConfiguration)).withCredentials(this.configuration.getIamPolicy())).withRegion(this.configuration.getRegion())).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonEC2 getAmazonEC2() {
        Object object = this.amazonEC2.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.amazonEC2;
            synchronized (atomicReference) {
                object = this.amazonEC2.get();
                if (object == null) {
                    AmazonEC2 amazonEC2 = this.createAmazonEC2Client();
                    object = amazonEC2 == null ? this.amazonEC2 : amazonEC2;
                    this.amazonEC2.set(object);
                }
            }
        }
        return (AmazonEC2)(object == this.amazonEC2 ? null : object);
    }
}

