/*
 * Decompiled with CFR 0.152.
 */
package kikaha.cloud.aws.ec2;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kikaha.config.Config;

public class AmazonEC2Config
implements Config {
    final Supplier<Map<String, String>> tagProducer;
    final Config fallback;
    private final AtomicReference<Object> tags = new AtomicReference();

    public String getString(String string) {
        String string2 = this.getTags().get(string);
        if (string2 == null) {
            return this.fallback.getString(string);
        }
        return string2;
    }

    public String getString(String string, String string2) {
        String string3 = this.getTags().get(string);
        if (string3 == null) {
            return this.fallback.getString(string, string2);
        }
        return string3;
    }

    public byte[] getBytes(String string, String string2) {
        String string3 = this.getTags().get(string);
        if (string3 == null) {
            return this.fallback.getBytes(string, string2);
        }
        return string3.getBytes();
    }

    public int getInteger(String string, int n) {
        String string2 = this.getTags().get(string);
        if (string2 == null) {
            return this.fallback.getInteger(string, n);
        }
        return Integer.valueOf(string2);
    }

    public long getLong(String string, long l) {
        String string2 = this.getTags().get(string);
        if (string2 == null) {
            return this.fallback.getLong(string, l);
        }
        return Long.valueOf(string2);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.getTags().get(string);
        if (string2 == null) {
            return this.fallback.getBoolean(string, bl);
        }
        return Boolean.valueOf(string2);
    }

    public List<Config> getConfigList(String string) {
        return this.fallback.getConfigList(string);
    }

    public List<String> getStringList(String string, List<String> list) {
        return this.fallback.getStringList(string, list);
    }

    public Set<String> getKeys() {
        return this.fallback.getKeys();
    }

    public Config getConfig(String string) {
        Config config = this.fallback.getConfig(string);
        if (config == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : this.getTags().keySet()) {
            if (!string2.startsWith(string)) continue;
            hashMap.put(string2.replace(string + ".", ""), this.getTags().get(string2));
        }
        return new AmazonEC2Config(() -> hashMap, config);
    }

    public Object getObject(String string) {
        String string2 = this.getTags().get(string);
        if (string2 == null) {
            return this.fallback.getObject(string);
        }
        return string2;
    }

    public Class<?> getClass(String string, Class<?> clazz) {
        String string2 = this.getTags().get(string);
        if (string2 == null) {
            return this.fallback.getClass(string, clazz);
        }
        return this.instantiate(string2);
    }

    private Class<?> instantiate(String string) {
        try {
            return Class.forName(string);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Can't load " + string, throwable);
        }
    }

    public Map<String, Object> toMap() {
        Map map = this.fallback.toMap();
        map.putAll(this.getTags());
        return map;
    }

    @ConstructorProperties(value={"tagProducer", "fallback"})
    public AmazonEC2Config(Supplier<Map<String, String>> supplier, Config config) {
        this.tagProducer = supplier;
        this.fallback = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getTags() {
        Object object = this.tags.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.tags;
            synchronized (atomicReference) {
                object = this.tags.get();
                if (object == null) {
                    Map<String, String> map = this.tagProducer.get();
                    object = map == null ? this.tags : map;
                    this.tags.set(object);
                }
            }
        }
        return (Map)(object == this.tags ? null : object);
    }
}

