/*
 * Decompiled with CFR 0.152.
 */
package kikaha.cloud.aws.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import kikaha.cloud.aws.ec2.AmazonEC2Config;
import kikaha.cloud.aws.ec2.AmazonEC2MachineIdentification;
import kikaha.cloud.aws.iam.AmazonCredentialsFactory;
import kikaha.config.Config;
import kikaha.config.ConfigEnrichment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AmazonEC2ConfigEnrichment
implements ConfigEnrichment {
    private static final Logger log = LoggerFactory.getLogger(AmazonEC2ConfigEnrichment.class);
    @Inject
    AmazonEC2MachineIdentification identification;
    @Inject
    AmazonCredentialsFactory.Default defaultCredentialFactory;
    private final AtomicReference<Object> ec2 = new AtomicReference();

    AmazonEC2 loadEC2Client() {
        return (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withCredentials(this.defaultCredentialFactory.loadCredentialProvider())).withRegion(this.identification.getRegion())).build();
    }

    public Config enrich(Config config) {
        if (!config.getBoolean("server.aws.ec2.tag-as-config-enabled")) {
            return config;
        }
        log.info("Using the tags associated with this EC2 instance as configuration entries.");
        return new AmazonEC2Config(this::getInstanceTagsAsMap, config);
    }

    private Map<String, String> getInstanceTagsAsMap() {
        try {
            List<Tag> list = this.getInstanceTags(this.identification.getMachineId());
            Map<String, String> map = this.toMap(list, Tag::getKey, Tag::getValue);
            log.debug("Found EC2 tags: " + map);
            return map;
        }
        catch (Throwable throwable) {
            log.error("Could not retrieve EC2 tags", throwable);
            return Collections.emptyMap();
        }
    }

    private List<Tag> getInstanceTags(String string) {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest().withInstanceIds(Collections.singletonList(string));
        DescribeInstancesResult describeInstancesResult = this.getEc2().describeInstances(describeInstancesRequest);
        for (Reservation reservation : describeInstancesResult.getReservations()) {
            for (Instance instance : reservation.getInstances()) {
                List list = instance.getTags();
                if (list == null || list.size() <= 0) continue;
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    private <T, K, V> Map<K, V> toMap(List<T> list, Function<T, K> function, Function<T, V> function2) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        for (T t : list) {
            hashMap.put(function.apply(t), function2.apply(t));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonEC2 getEc2() {
        Object object = this.ec2.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.ec2;
            synchronized (atomicReference) {
                object = this.ec2.get();
                if (object == null) {
                    AmazonEC2 amazonEC2 = this.loadEC2Client();
                    object = amazonEC2 == null ? this.ec2 : amazonEC2;
                    this.ec2.set(object);
                }
            }
        }
        return (AmazonEC2)(object == this.ec2 ? null : object);
    }
}

