/*
 * Decompiled with CFR 0.152.
 */
package kikaha.cloud.aws.ec2;

import com.amazonaws.regions.Regions;
import com.amazonaws.util.EC2MetadataUtils;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Singleton;
import kikaha.cloud.smart.MachineIdentification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AmazonEC2MachineIdentification
implements MachineIdentification {
    private static final Logger log = LoggerFactory.getLogger(AmazonEC2MachineIdentification.class);
    private final AtomicReference<Object> machineId = new AtomicReference();
    private final AtomicReference<Object> ipAddress = new AtomicReference();
    private final AtomicReference<Object> region = new AtomicReference();

    public String generateTheMachineId() throws IOException {
        log.debug("Retrieving EC2 machine id...");
        return this.getMachineId();
    }

    public String getLocalAddress() throws IOException {
        log.debug("Retrieving EC2 machine IP address...");
        return this.getIpAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMachineId() {
        Object object = this.machineId.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.machineId;
            synchronized (atomicReference) {
                object = this.machineId.get();
                if (object == null) {
                    String string = EC2MetadataUtils.getInstanceId();
                    object = string == null ? this.machineId : string;
                    this.machineId.set(object);
                }
            }
        }
        return (String)(object == this.machineId ? null : object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIpAddress() {
        Object object = this.ipAddress.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.ipAddress;
            synchronized (atomicReference) {
                object = this.ipAddress.get();
                if (object == null) {
                    String string = EC2MetadataUtils.getPrivateIpAddress();
                    object = string == null ? this.ipAddress : string;
                    this.ipAddress.set(object);
                }
            }
        }
        return (String)(object == this.ipAddress ? null : object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Regions getRegion() {
        Object object = this.region.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.region;
            synchronized (atomicReference) {
                object = this.region.get();
                if (object == null) {
                    Regions regions = Regions.fromName((String)EC2MetadataUtils.getEC2InstanceRegion());
                    object = regions == null ? this.region : regions;
                    this.region.set(object);
                }
            }
        }
        return (Regions)(object == this.region ? null : object);
    }
}

