/*
 * Decompiled with CFR 0.152.
 */
package kikaha.cloud.consul;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import kikaha.cloud.consul.ConsulRegisteredClient;
import kikaha.cloud.consul.Http;
import kikaha.cloud.smart.ServiceRegistry;
import kikaha.config.Config;
import kikaha.core.util.Lang;
import kikaha.core.util.Tuple;
import kikaha.urouting.serializers.jackson.Jackson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConsulClient
implements ServiceRegistry {
    private static final Logger log = LoggerFactory.getLogger(ConsulClient.class);
    static final String REQUEST_CHECK_STRING = "{\"ID\": \"{id}\",\"Name\": \"{name}\",\"Address\": \"{host}\",\"Port\": {port}, \"Tags\": {tags},\"Check\": { \"DeregisterCriticalServiceAfter\": \"{deregister-after}m\", \"HTTP\": \"{health-check-url}\",\"Interval\": \"{health-check-interval}s\"}}";
    @Inject
    Config config;
    @Inject
    Jackson jackson;

    public void registerIntoCluster(ServiceRegistry.ApplicationData applicationData) throws IOException {
        String string = applicationData.getName() + ":" + applicationData.getVersion();
        log.info("Joining consul cluster '" + string + "' as '" + applicationData.getMachineId() + "'...");
        String string2 = this.asMessage(applicationData);
        int n = this.post("/v1/agent/service/register", string2);
        if (n != 200) {
            throw new IOException("Could not register the application on consul.io.");
        }
    }

    String asMessage(ServiceRegistry.ApplicationData applicationData) throws IOException {
        Map<String, String> map = this.asParams(applicationData);
        String string = REQUEST_CHECK_STRING;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = Optional.ofNullable(entry.getValue()).orElse("");
            string = string.replace("{" + entry.getKey() + "}", string2);
        }
        log.debug("Consul request: " + string);
        return string;
    }

    Map<String, String> asParams(ServiceRegistry.ApplicationData applicationData) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", applicationData.getMachineId());
        hashMap.put("name", applicationData.getName() + ":" + applicationData.getVersion());
        hashMap.put("host", applicationData.getLocalAddress());
        hashMap.put("port", String.valueOf(applicationData.getLocalPort()));
        hashMap.put("tags", this.asTagList(this.config.getStringList("server.smart-server.application.tags")));
        hashMap.put("deregister-after", String.valueOf(this.config.getInteger("server.consul.deregister-critical-service-after")));
        hashMap.put("health-check-interval", String.valueOf(this.config.getInteger("server.consul.health-check-interval")));
        hashMap.put("health-check-url", this.getHealthCheckUrl(applicationData));
        return hashMap;
    }

    String getHealthCheckUrl(ServiceRegistry.ApplicationData applicationData) throws IOException {
        String string = this.config.getString("server.smart-server.application.health-check-url");
        if (string == null || string.isEmpty()) {
            string = String.format("%s://%s:%d%s", applicationData.isHttps() ? "https" : "http", applicationData.getLocalAddress(), applicationData.getLocalPort(), this.config.getString("server.health-check.url"));
        }
        log.info("  Health check URL: " + string);
        return string;
    }

    private String asTagList(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, '\"' + list.get(i) + '\"');
        }
        return "[" + String.join((CharSequence)" ", list) + "]";
    }

    int post(String string, String string2) throws IOException {
        return Http.sendRequest(this.getConsulEndpointBaseURL() + string, "POST", string2);
    }

    public void deregisterFromCluster(ServiceRegistry.ApplicationData applicationData) throws IOException {
        log.info("Leaving consul cluster...");
        int n = this.put("/v1/agent/service/deregister/" + applicationData.getMachineId());
        if (n != 200) {
            throw new IOException("Could not register the application on consul.io.");
        }
    }

    int put(String string) throws IOException {
        return Http.sendRequest(this.getConsulEndpointBaseURL() + string, "PUT", null);
    }

    public List<ServiceRegistry.ApplicationData> locateSiblingNodesOnTheCluster(ServiceRegistry.ApplicationData applicationData) throws IOException {
        Tuple<Integer, String> tuple = Http.get(this.getConsulEndpointBaseURL() + "/v1/agent/services");
        if ((Integer)tuple.getFirst() != 200) {
            throw new IOException("Could not retrieve data from Consul: " + (String)tuple.getSecond());
        }
        TypeFactory typeFactory = this.jackson.objectMapper().getTypeFactory();
        MapType mapType = typeFactory.constructMapType(HashMap.class, String.class, ConsulRegisteredClient.class);
        Map map = (Map)this.jackson.objectMapper().readValue((String)tuple.getSecond(), (JavaType)mapType);
        String string = applicationData.getName() + ":" + applicationData.getVersion();
        String string2 = applicationData.getMachineId();
        List list = Lang.filter(map.values(), consulRegisteredClient -> string.equals(consulRegisteredClient.service) && !string2.equals(consulRegisteredClient.id));
        return Lang.convert((Iterable)list, consulRegisteredClient -> consulRegisteredClient.toApplicationData(applicationData));
    }

    String getConsulEndpointBaseURL() {
        String string = this.config.getString("server.consul.host", "127.0.0.1");
        int n = this.config.getInteger("server.consul.port", 8500);
        return "http://" + string + ":" + n;
    }
}

