/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Singleton;
import kikaha.urouting.Reflection;
import kikaha.urouting.api.ContextProducer;
import kikaha.urouting.api.ContextProducerFactory;

@Singleton
public class ContextProducerFactoryLoader {
    @Inject
    @Typed(value={ContextProducer.class})
    Iterable<ContextProducer> availableProducers;
    ContextProducerFactory factory;

    @PostConstruct
    public void onStartup() {
        Map<Class, ContextProducer> map = this.loadAllProducers();
        this.factory = new ContextProducerFactory(map);
    }

    @Produces
    public ContextProducerFactory produceFactory() {
        return this.factory;
    }

    private Map<Class, ContextProducer> loadAllProducers() {
        HashMap<Class, ContextProducer> hashMap = new HashMap<Class, ContextProducer>();
        for (ContextProducer contextProducer : this.availableProducers) {
            Class<?> clazz = Reflection.getFirstGenericTypeFrom(contextProducer, ContextProducer.class);
            hashMap.put(clazz, contextProducer);
        }
        return hashMap;
    }
}

