/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Singleton;
import kikaha.urouting.api.AbstractConverter;
import kikaha.urouting.api.ConversionException;
import kikaha.urouting.api.ConverterFactory;

@Singleton
public class ConverterFactoryLoader {
    @Inject
    @Typed(value={AbstractConverter.class})
    Iterable<AbstractConverter> availableConverters;
    ConverterFactory factory;

    @PostConstruct
    public void onStartup() {
        this.factory = new ConverterFactory(this.loadAllConverters());
    }

    @Produces
    public ConverterFactory produceFactory() {
        return this.factory;
    }

    public Map<String, AbstractConverter<?>> loadAllConverters() {
        Map<String, AbstractConverter<?>> map = ConverterFactoryLoader.loadPrimitiveConverters();
        for (AbstractConverter abstractConverter : this.availableConverters) {
            String string = abstractConverter.getGenericClass().getCanonicalName();
            map.put(string, abstractConverter);
        }
        return map;
    }

    private static Map<String, AbstractConverter<?>> loadPrimitiveConverters() {
        HashMap hashMap = new HashMap();
        ConverterFactoryLoader.converterFrom(hashMap, Integer.TYPE, Integer::parseInt);
        ConverterFactoryLoader.converterFrom(hashMap, Byte.TYPE, Byte::parseByte);
        ConverterFactoryLoader.converterFrom(hashMap, Float.TYPE, Float::parseFloat);
        ConverterFactoryLoader.converterFrom(hashMap, Double.TYPE, Double::parseDouble);
        ConverterFactoryLoader.converterFrom(hashMap, Long.TYPE, Long::parseLong);
        ConverterFactoryLoader.converterFrom(hashMap, Short.TYPE, Short::parseShort);
        ConverterFactoryLoader.converterFrom(hashMap, Boolean.TYPE, Boolean::parseBoolean);
        return hashMap;
    }

    private static <T> void converterFrom(Map<String, AbstractConverter<?>> map, final Class<T> clazz, final Function<String, T> function) {
        map.put(clazz.getCanonicalName(), new AbstractConverter<T>(){

            @Override
            public T convert(String string) throws ConversionException {
                return function.apply(string);
            }

            @Override
            public Class<T> getGenericClass() {
                return clazz;
            }
        });
    }
}

